/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ajax;

import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.web.BIWebComponent;
import com.kingdee.bos.ctrl.analysis.web.ajax.BIReportPage;
import com.kingdee.bos.ctrl.analysis.web.ajax.Constants;
import com.kingdee.bos.ctrl.analysis.web.ajax.MdxQueryO;
import com.kingdee.bos.ctrl.analysis.web.ajax.UIO;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSON;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONList;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONMap;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONNumber;
import com.kingdee.bos.ctrl.analysis.web.chart.ChartComponent;
import com.kingdee.bos.ctrl.analysis.web.chart.ChartTypeConstant;
import com.kingdee.bos.ctrl.analysis.web.chart.RadarChartConfig;
import com.kingdee.bos.ctrl.analysis.web.piece.DynamicPiece;
import com.kingdee.bos.ctrl.analysis.web.piece.Piece;
import com.kingdee.bos.ctrl.analysis.web.piece.SnapshotPiece;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReport;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.impl.BIReportChartComponent;
import com.kingdee.bos.ctrl.analysis.web.solution.util.IDGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ChartUIO
extends UIO {
    private BIReportChartComponent wrc;
    private MdxQueryO mdxQueryO = null;
    private ChartComponent component = null;
    private BIReportPage page;

    ChartUIO(BIReportPage page, BIReportChartComponent wrc, String schemename, int perPageRows) throws BIReportException {
        super(page, wrc.getName(), wrc.getCaption(), "chart", schemename, perPageRows);
        this.page = page;
        this.init(wrc);
    }

    private void init(BIReportChartComponent wrc) throws BIReportException {
        this.wrc = wrc;
        this.mdxQueryO = this.page.getMdxQueryOManager().getMdxQueryO(wrc.getMdxQuery());
        if (this.mdxQueryO == null) {
            this.mdxQueryO = this.page.getMdxQueryOManager().createMdxQueryO(wrc.getMdxQuery(), wrc.getMdx());
        }
    }

    public BIReportChartComponent getBIReportComponent() {
        return this.wrc;
    }

    @Override
    public BIWebComponent getComponent() {
        return this.component;
    }

    public MdxQueryO getMdxQueryO() {
        return this.mdxQueryO;
    }

    public void updateMdxQueryO(MdxQueryO mdxQueryO) {
        this.mdxQueryO = mdxQueryO;
    }

    private void initComponent(HttpServletRequest request) throws BIReportException {
        this.component = new ChartComponent(this.getId().toString(), this.getCaption(), request.getSession());
        try {
            this.wrc.setChartPropertyValues(this.component);
            this.component.setOlapModel(this.mdxQueryO.getOlapModel(request));
            this.component.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BIReportException(e);
        }
    }

    @Override
    protected Map getParametersForXSL(HttpServletRequest request) {
        Map parameters = super.getParametersForXSL(request);
        String[] keys = new String[]{"canMoveDimension", "showRowDimensionInSlicer", "showColumnDimensionInSlicer"};
        for (int i = 0; i < keys.length; ++i) {
            String s = this.wrc.getProperty(keys[i]);
            s = "true".equals(s) || s == null ? "true" : "false";
            parameters.put(keys[i], s);
        }
        return parameters;
    }

    @Override
    public String service(HttpServletRequest request) throws BIReportException {
        if (this.component == null) {
            this.initComponent(request);
        } else if (this.component.setOlapModel(this.mdxQueryO.getOlapModel(request))) {
            try {
                this.component.initialize();
            }
            catch (Exception e) {
                throw new BIReportException(e);
            }
        }
        String requestType = request.getParameter("type");
        if ("init".equalsIgnoreCase(requestType)) {
            StringBuffer sb = new StringBuffer();
            this.component.setPagePerRows(this.perPageRows);
            String attSlicer = this.wrc.getProperty("showSlicer");
            boolean showSlicer = attSlicer != null && "true".equalsIgnoreCase(attSlicer);
            this.component.getRadarConfig().setEnable(true);
            if (showSlicer) {
                sb.append(this.transXSL(request, Constants.PATH_XSL_SLICER, this.component));
            }
            sb.append(this.transXSL(request, Constants.PATH_XSL_CHART, this.component));
            this.component.getRadarConfig().setEnable(false);
            return sb.toString();
        }
        if ("clearChartStatus".equalsIgnoreCase(requestType)) {
            this.component.clearChartStatus();
        }
        if ("refresh".equalsIgnoreCase(requestType)) {
            boolean showSlicer;
            StringBuffer sb = new StringBuffer();
            String attSlicer = this.wrc.getProperty("showSlicer");
            boolean bl = showSlicer = attSlicer != null && "true".equalsIgnoreCase(attSlicer);
            if (showSlicer) {
                sb.append(this.transXSL(request, Constants.PATH_XSL_SLICER, this.component));
            }
            sb.append(this.transXSL(request, Constants.PATH_XSL_CHART, this.component));
            this.component.getRadarConfig().setEnable(false);
            if (!"true".equals(request.getParameter("keepRadarConfig"))) {
                this.component.getRadarConfig().reset();
            }
            return sb.toString();
        }
        if ("action".equalsIgnoreCase(requestType)) {
            String actionName = request.getParameter("actionName");
            if ("getSlicerChildren".equalsIgnoreCase(actionName)) {
                return this.getSlicerChildren(request, this.component.getOlapModel());
            }
            if ("getSlicerDescendant".equalsIgnoreCase(actionName)) {
                return this.getSlicerDescendant(request, this.component.getOlapModel());
            }
            if ("changeSlicer".equalsIgnoreCase(actionName)) {
                return this.changeSlicer(request, this.mdxQueryO);
            }
            if ("getAllHierarchy".equalsIgnoreCase(actionName)) {
                return this.getAllHierarchy(request, this.component.getOlapModel());
            }
            if ("changeHierarchyMembers".equalsIgnoreCase(actionName)) {
                return this.changeHierarchyMembers(request, this.mdxQueryO);
            }
            if ("swapHierarchy".equalsIgnoreCase(actionName)) {
                return this.swapHierarchy(request, this.mdxQueryO);
            }
            if ("moveAfter".equalsIgnoreCase(actionName)) {
                return this.moveAfter(request, this.mdxQueryO);
            }
            if ("moveBefore".equalsIgnoreCase(actionName)) {
                return this.moveBefore(request, this.mdxQueryO);
            }
            if ("moveTo".equalsIgnoreCase(actionName)) {
                return this.moveTo(request, this.mdxQueryO);
            }
            if ("swapAxis".equalsIgnoreCase(actionName)) {
                return this.swapAxis(request, this.mdxQueryO);
            }
            if ("getVisibleMember".equalsIgnoreCase(actionName)) {
                return this.findVisibleMembers(request, this.mdxQueryO);
            }
            if ("changeChartType".equalsIgnoreCase(actionName)) {
                return this.changeChartType(request);
            }
            if ("setSize".equalsIgnoreCase(actionName)) {
                return this.setSize(request);
            }
            if ("setCategoryLabelAllign".equalsIgnoreCase(actionName)) {
                return this.setCategoryLabelAllign(request);
            }
            if ("changeChartTopNValue".equalsIgnoreCase(actionName)) {
                return this.changeChartTopNValue(request);
            }
            if ("changeChartTopNOther".equalsIgnoreCase(actionName)) {
                return this.changeChartTopNOther(request);
            }
            if ("setPage".equalsIgnoreCase(actionName)) {
                this.component.getRadarConfig().setEnable(true);
                return this.setPage(request, this.mdxQueryO);
            }
            if ("setPerPageRows".equalsIgnoreCase(actionName)) {
                return this.setPerPageRows(request, this.mdxQueryO);
            }
            if ("getPage".equalsIgnoreCase(actionName)) {
                return this.component.getPageInfo();
            }
            if ("doSort".equalsIgnoreCase(actionName)) {
                this.component.doSort(request);
                return super.getUsedUIOString(this.mdxQueryO);
            }
            if ("getSortInfo".equalsIgnoreCase(actionName)) {
                return this.component.getSortInfo(request);
            }
            if ("savePiece".equalsIgnoreCase(actionName)) {
                String strDynamic = request.getParameter("isDynamic");
                boolean isDynamic = "true".equalsIgnoreCase(strDynamic);
                String pieceCaption = request.getParameter("pieceCaption");
                String pieceParentPath = request.getParameter("pieceParentPath");
                String pieceName = "PIECE" + IDGenerator.getUUID();
                Piece piece = null;
                if (isDynamic) {
                    OlapModel model = this.component.getOlapModel();
                    String mdx = model.getCurrentMdx();
                    Object[] params = this.page.getFilterParams();
                    Object[] filterCaptions = this.page.getFilterCaptionParams();
                    BIReport report = this.page.getBIReport();
                    String chartType = this.component.getChartConfig().getStringValue("chartType");
                    piece = new DynamicPiece(pieceName, pieceCaption, pieceParentPath, mdx, params, filterCaptions, report.getSubjectPath(), report.getPath(), "chart", chartType, this.schemename, report.getRepositoryPath(), null, this.component.getCurrentPage(), this.component.getPerPageRows());
                    if (chartType.equalsIgnoreCase(ChartTypeConstant.RADAR)) {
                        DynamicPiece dPiece = (DynamicPiece)piece;
                        dPiece.setRadarConfig(this.component.getRadarConfig());
                    }
                    int width = this.component.getChartConfig().getIntValue("chartWidth");
                    int height = this.component.getChartConfig().getIntValue("chartHeight");
                    int topNValue = this.component.getChartModel().getDataModel().getTopN().getValue();
                    boolean topNOther = this.component.getChartModel().getDataModel().getTopN().isOther();
                    ((DynamicPiece)piece).setProperty("topNValue", "" + topNValue);
                    ((DynamicPiece)piece).setProperty("topNOther", topNOther ? "true" : "false");
                    ((DynamicPiece)piece).setProperty("chartWidth", "" + width);
                    ((DynamicPiece)piece).setProperty("chartHeight", "" + height);
                } else {
                    piece = new SnapshotPiece(pieceName, pieceCaption, pieceParentPath, this.component.getFilename(), "chart", this.page.getReport().getRepositoryPath());
                }
                String id = piece.save(request);
                StringBuffer sb = new StringBuffer();
                sb.append("true");
                sb.append(pieceCaption);
                sb.append(",");
                sb.append(id);
                sb.append(",");
                sb.append(pieceParentPath + "/" + pieceName);
                sb.append(",");
                sb.append("false");
                return sb.toString();
            }
            if ("doDrillUp".equalsIgnoreCase(actionName)) {
                return this.doDrillUp(request, this.mdxQueryO);
            }
            if ("doMemberDrill".equalsIgnoreCase(actionName)) {
                return this.doMemberDrill(request, this.mdxQueryO);
            }
            if ("doLevelDrill".equalsIgnoreCase(actionName)) {
                return this.doLevelDrill(request, this.mdxQueryO);
            }
            if ("getColumnPositions".equalsIgnoreCase(actionName)) {
                try {
                    List pos = this.mdxQueryO.getOlapModel(request).getResult().getColumnAxis().getPositions();
                    ArrayList<String> list = new ArrayList<String>();
                    Iterator it = pos.iterator();
                    while (it.hasNext()) {
                        list.add(it.next().toString());
                    }
                    return new JSONList(list).toString();
                }
                catch (OlapException e) {
                    throw new BIReportException(e);
                }
            }
            if ("getRadarTargetIndex".equalsIgnoreCase(actionName)) {
                return this.wrc.getRadarTargetColumnIndex() + "";
            }
            if ("getRadarMinIndex".equalsIgnoreCase(actionName)) {
                return this.wrc.getRadarMinColumnIndex() + "";
            }
            if ("configRadarChart".equalsIgnoreCase(actionName)) {
                int targetIndex = (int)Double.parseDouble(request.getParameter("targetIndex"));
                int minIndex = (int)Double.parseDouble(request.getParameter("minIndex"));
                String[] targetSelfDefValues = request.getParameterValues("targetValues");
                String[] minSelfDefValues = request.getParameterValues("minValues");
                ArrayList<String> validIndexList = new ArrayList<String>();
                String[] factIndexies = request.getParameterValues("factIndexies");
                for (int i = 0; i < factIndexies.length; ++i) {
                    validIndexList.add((int)Double.parseDouble(factIndexies[i]) + "");
                }
                validIndexList.add(targetIndex + "");
                validIndexList.add(minIndex + "");
                RadarChartConfig rcc = this.component.getRadarConfig();
                rcc.setRadarTargetColumnIndex(targetIndex);
                rcc.setRadarMinColumnIndex(minIndex);
                rcc.setValidIndexList(validIndexList);
                rcc.setRadarTargetSelfDefValues(targetSelfDefValues);
                rcc.setRadarMinSelfDefValues(minSelfDefValues);
                boolean isDisplayName = new Boolean(request.getParameter("displayName"));
                boolean isDisplayValue = new Boolean(request.getParameter("displayValue"));
                boolean isFillBackground = new Boolean(request.getParameter("fillBackground"));
                rcc.setDisplayName(isDisplayName);
                rcc.setDisplayValue(isDisplayValue);
                rcc.setFillBackground(isFillBackground);
                rcc.setEnable(true);
                this.component.setDirty(true);
                return "";
            }
            if ("getRowPositions".equalsIgnoreCase(actionName)) {
                int page = (int)Double.parseDouble(request.getParameter("page"));
                int pageSize = (int)Double.parseDouble(request.getParameter("pageSize"));
                try {
                    List pos = this.mdxQueryO.getOlapModel(request).getResult().getRowAxis().getPositions();
                    int posCount = pos.size();
                    int fromIndex = (page - 1) * pageSize;
                    int toIndex = Math.min(page * pageSize, posCount);
                    if (fromIndex != 0 || toIndex != posCount) {
                        pos = pos.subList(fromIndex, toIndex);
                    }
                    ArrayList<String> list = new ArrayList<String>();
                    Iterator it = pos.iterator();
                    while (it.hasNext()) {
                        list.add(it.next().toString());
                    }
                    JSONList currentPageList = new JSONList(list);
                    JSONNumber rowCount = new JSONNumber(new Integer(posCount));
                    JSONNumber pageCount = new JSONNumber(new Integer((int)Math.ceil((double)posCount / (double)pageSize)));
                    HashMap<String, JSON> map = new HashMap<String, JSON>(3, 1.0f);
                    map.put("positions", currentPageList);
                    map.put("rowCount", rowCount);
                    map.put("pageCount", pageCount);
                    return new JSONMap(map).toString();
                }
                catch (OlapException e) {
                    throw new BIReportException(e);
                }
            }
            throw new BIReportException("\u975e\u6cd5\u53c2\u6570actionName\u503c\uff1a" + actionName);
        }
        if (requestType == null) {
            throw new BIReportException("\u8bf7\u6c42\u53c2\u6570\u4e2d\u5fc5\u987b\u6709requestType.");
        }
        throw new BIReportException("\u975e\u6cd5\u53c2\u6570requestType\u503c\uff1a" + requestType);
    }

    private String doMemberDrill(HttpServletRequest request, MdxQueryO mdxQueryO2) {
        String memberUniqueName = request.getParameter("memberUniqueName");
        this.component.doMemberDrill(memberUniqueName);
        return super.getUsedUIOString(this.mdxQueryO);
    }

    private String doLevelDrill(HttpServletRequest request, MdxQueryO mdxQueryO2) {
        String memberUniqueName = request.getParameter("memberUniqueName");
        this.component.doLevelDrill(memberUniqueName);
        return super.getUsedUIOString(this.mdxQueryO);
    }

    private String doDrillUp(HttpServletRequest request, MdxQueryO mdxQueryO2) {
        String memberUniqueName = request.getParameter("memberUniqueName");
        this.component.doDrillUp(memberUniqueName);
        return super.getUsedUIOString(this.mdxQueryO);
    }

    private String changeChartType(HttpServletRequest request) {
        this.component.getChartConfig().putStringValue("chartType", request.getParameter("chartType"));
        return "true";
    }

    private String changeChartTopNValue(HttpServletRequest request) throws BIReportException {
        String value = request.getParameter("value");
        this.component.getChartModel().getDataModel().getTopN().setValue(new Integer(value));
        this.component.getChartModel().setDirty(true);
        return "true";
    }

    private String changeChartTopNOther(HttpServletRequest request) throws BIReportException {
        String value = request.getParameter("other");
        this.component.getChartModel().getDataModel().getTopN().setOther("true".equals(value));
        this.component.getChartModel().setDirty(true);
        return "true";
    }

    private String setCategoryLabelAllign(HttpServletRequest request) throws BIReportException {
        String v = request.getParameter("value");
        this.component.getChartConfig().putStringValue("categoryLabelAllign", v);
        return "true";
    }

    private String setSize(HttpServletRequest request) {
        this.component.getChartConfig().putIntValue("chartHeight", (int)new Integer(request.getParameter("height")));
        this.component.getChartConfig().putIntValue("chartWidth", (int)new Integer(request.getParameter("width")));
        return "true";
    }

    @Override
    public void clearUIStatus() {
        if (this.component != null) {
            this.component.clearChartStatus();
        }
    }
}

