/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ajax;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.ajax.BIReportPage;
import com.kingdee.bos.ctrl.analysis.web.ajax.Constants;
import com.kingdee.bos.ctrl.analysis.web.ajax.IPage;
import com.kingdee.bos.ctrl.analysis.web.ajax.ReportPage;
import com.kingdee.bos.ctrl.analysis.web.ajax.WebPage;
import com.kingdee.bos.ctrl.analysis.web.bimreport.BIMFactory;
import com.kingdee.bos.ctrl.analysis.web.dupont.DupontPage;
import com.kingdee.bos.ctrl.analysis.web.dupont.IDupontReport;
import com.kingdee.bos.ctrl.analysis.web.ext.ExtReport;
import com.kingdee.bos.ctrl.analysis.web.ext.ExtReportPage;
import com.kingdee.bos.ctrl.analysis.web.kpimonitor.KPIMonitorPage;
import com.kingdee.bos.ctrl.analysis.web.permission.BIPermission_EAS;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReport;
import com.kingdee.bos.ctrl.analysis.web.solution.BISolution;
import com.kingdee.bos.ctrl.analysis.web.solution.BISubject;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.Report;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.util.IDGenerator;
import com.kingdee.bos.ctrl.common.encrypt.EncryptionStrategy;
import com.kingdee.bos.ctrl.common.encrypt.PlainTxtExtraction;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.rpts.tobi.ExtReportImpl;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class PageManager {
    private static Logger logger = CommonLogger.getLogger(PageManager.class);
    private static Map pageMap = new WeakHashMap();
    private static Map pageUserMap = new HashMap();
    private static Map paramCacheMap = new HashMap();
    public static final String SEP_UNDERLINE = "_";
    private static long timeSleep = 2000000L;
    private static long timeOut = 2400000L;
    private static long[] countTime = new long[]{200L, 1800000L, 300L, 900000L, 400L, 120000L};
    private static long[] memoryTime = new long[]{100L, 120000L, 200L, 600000L, 300L, 1200000L};
    private static TimeoutThread t = new TimeoutThread("rpt timeout clean thread");

    @Deprecated
    private static void readConfig(Context ctx) {
        String sqlQuery = "select * from T_EXT_rptcache_test";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlQuery);
            if (rowSet != null) {
                while (rowSet.next()) {
                    timeSleep = rowSet.getLong(1);
                    timeOut = rowSet.getLong(2);
                    String[] ct = rowSet.getString(3).split(",");
                    countTime = new long[ct.length];
                    for (int i = 0; i < ct.length; ++i) {
                        PageManager.countTime[i] = Long.parseLong(ct[i]);
                        if (countTime[i] >= 1L) continue;
                        PageManager.countTime[i] = 1L;
                    }
                    String[] mt = rowSet.getString(4).split(",");
                    memoryTime = new long[mt.length];
                    for (int i = 0; i < mt.length; ++i) {
                        PageManager.memoryTime[i] = Long.parseLong(mt[i]);
                        if (memoryTime[i] < 1L) {
                            PageManager.memoryTime[i] = 1L;
                        }
                        if (i % 2 != 0) continue;
                        int n = i;
                        memoryTime[n] = memoryTime[n] * 0x100000L;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.error((Object)("timeSleep: " + timeSleep));
        logger.error((Object)("timeOut: " + timeOut));
        logger.error((Object)("countTime: " + countTime));
        logger.error((Object)("memoryTime: " + memoryTime));
    }

    public static IPage getPage(String pageId) {
        return (IPage)pageMap.get(pageId);
    }

    public static ExtReportPage createExtReportPage(String pageId, String repPath, HttpServletRequest request) throws BIReportException {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        HashMap<String, String> param = PageManager.getParameterMap(request);
        param.put("pageId", pageId);
        ExtReportPage page = PageManager.createExtReportPage(ctx, param);
        return page;
    }

    public static HashMap<String, String> getParameterMap(HttpServletRequest request) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        HashMap<String, String> reqParamMap = new HashMap<String, String>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String[] values = request.getParameterValues(name);
            if (values == null || values.length <= 0) continue;
            reqParamMap.put(name, values[0]);
        }
        String queryString = request.getQueryString();
        if (!com.kingdee.bos.sql.util.StringUtil.isEmpty((String)queryString)) {
            reqParamMap.put("QueryString", queryString);
        }
        reqParamMap.put("userId", userId);
        return reqParamMap;
    }

    public static ExtReport createExtReport(Context ctx, Map<String, String> request) throws BIReportException {
        String reportPath;
        ExtReport rpt = null;
        String systemId = request.get("ExtRptsSystemID");
        String extReportId = request.get("ExtReportId");
        String extReportName = null;
        String extSystemId = null;
        String domain = null;
        String isDshExtReport = request.get("isDshExtReport");
        String userId = request.get("userId");
        String repPath = request.get("reportPath");
        if (StringUtil.isEmptyString((String)repPath)) {
            repPath = request.get("repositoryPath");
        }
        if (isDshExtReport != null) {
            String name = request.get("ExtReportName");
            reportPath = name + "\u0001" + systemId;
        } else if (systemId != null) {
            String name = null;
            name = request.get("ExtRptsReportName");
            String token = request.get("token");
            if (token == null || token.trim().equals("")) {
                throw new BIReportException("\u4e0d\u5408\u6cd5URL", new Exception());
            }
            EncryptionStrategy encryption = null;
            try {
                encryption = (EncryptionStrategy)PageManager.class.getClassLoader().loadClass("com.kingdee.bos.ctrl.common.encrypt.SpecialMd5Encryption").newInstance();
            }
            catch (Exception e) {
                throw new BIReportException("\u672a\u627e\u5230URL\u7684\u52a0\u5bc6\u7b97\u6cd5\u7c7b\uff1acom.kingdee.bos.ctrl.common.encrypt.SpecialMd5Encryption", e);
            }
            finally {
                if (encryption == null) {
                    throw new BIReportException("\u672a\u80fd\u521b\u5efa\u52a0\u5bc6\u7b97\u6cd5\u5b9e\u4f8b", new Exception());
                }
            }
            String plainTxt = PlainTxtExtraction.extractText((String)request.get("QueryString"), request, (String)userId);
            if (!encryption.verify(token.trim(), plainTxt)) {
                throw new BIReportException("\u4e0d\u5408\u6cd5URL\uff1a\u9a8c\u8bc1\u4e0d\u901a\u8fc7", new Exception());
            }
            reportPath = name + "\u0001" + systemId;
        } else if (null != extReportId) {
            reportPath = extReportId;
            extReportName = request.get("ExtReportName");
            extSystemId = request.get("ExtSystemId");
            domain = request.get("ExtDomain");
        } else {
            reportPath = PageManager.getReportPath(ctx, repPath);
        }
        rpt = PageManager.createExtReport(reportPath, repPath, extReportName, extSystemId, domain);
        if (rpt != null) {
            rpt.setHyperlink("true".equalsIgnoreCase(request.get("ExtIsHyperlink")));
            rpt.setParameterJson(request.get("pJson"));
        }
        request.put("reportPath", reportPath);
        return rpt;
    }

    public static ExtReportPage createExtReportPage(Context ctx, Map<String, String> request) throws BIReportException {
        String pageId = request.get("pageId");
        String systemId = request.get("ExtRptsSystemID");
        String extReportId = request.get("ExtReportId");
        ExtReport rpt = PageManager.createExtReport(ctx, request);
        String reportPath = request.get("reportPath");
        if (StringUtil.isEmptyString((String)reportPath)) {
            reportPath = request.get("repositoryPath");
        }
        ExtReportPage page = new ExtReportPage(pageId, rpt);
        if (systemId != null) {
            page.setExtID(reportPath);
        } else {
            page.setReportID(reportPath);
            if (null != extReportId) {
                page.setExtID(reportPath);
            }
        }
        return page;
    }

    public static ExtReport createExtReport(String reportPath, String repPath, String extReportName, String extSystemId, String domain) throws BIReportException {
        ExtReport rpt = null;
        try {
            Class<?> classReport = Class.forName("com.kingdee.eas.rpts.tobi.ExtReportImpl");
            if (classReport != null) {
                rpt = (ExtReport)classReport.getConstructor(String.class, String.class, String.class, String.class, String.class).newInstance(reportPath, repPath, extReportName, extSystemId, domain);
            }
        }
        catch (Exception e) {
            throw new BIReportException("\u672a\u627e\u5230\u6269\u5c55\u62a5\u8868\u7684\u6267\u884c\u5f15\u64ce(com.kingdee.eas.rpts.tobi.ExtReportImpl)", e);
        }
        return rpt;
    }

    public static void cachePage(IPage page, HttpServletRequest request) throws BIReportException {
        String userId = BISystem.getCurrentUser(request);
        PageManager.cachePage(page, userId);
    }

    public static synchronized void cachePage(IPage page, String userId) {
        String pageId = page.getPageId();
        pageMap.put(pageId, page);
        pageUserMap.put(pageId, userId);
        PageManager.handleSizeout();
    }

    private static void handleSizeout() {
        int size = pageMap.size();
        int len = countTime.length;
        for (int i = 0; i < len; i += 2) {
            if ((long)size <= countTime[i] || i + 1 >= len) continue;
            PageManager.handleTimeout(countTime[i + 1]);
        }
        Runtime runtime = Runtime.getRuntime();
        int len2 = memoryTime.length;
        for (int i = 0; i < len2; i += 2) {
            long freeMemory = runtime.maxMemory() - (runtime.totalMemory() - runtime.freeMemory());
            if (freeMemory > memoryTime[i] || i + 1 >= len2) continue;
            PageManager.handleTimeout(memoryTime[i + 1]);
        }
        logger.debug((Object)("\u5f53\u524d\u7f13\u5b58\u62a5\u8868\u5f20\u6570\uff1a" + pageMap.size()));
    }

    private static DupontPage createDupontReportPage(String pageId, String repPath, HttpServletRequest request, HttpServletResponse response) throws BIReportException {
        IDupontReport rpt = null;
        String reportPath = PageManager.getReportPath(request);
        try {
            Class<?> classReport = Class.forName("com.kingdee.bos.bi.model.rt.dupont.DupontExecutor");
            if (classReport != null) {
                rpt = (IDupontReport)classReport.getConstructor(String.class, String.class, HttpServletRequest.class).newInstance(reportPath, repPath, request);
            }
        }
        catch (Exception e) {
            throw new BIReportException("\u672a\u627e\u5230\u675c\u90a6\u5206\u6790\u7684\u6267\u884c\u5f15\u64ce(com.kingdee.bos.bi.model.rt.dupont.DupontExecutor)", e);
        }
        DupontPage page = new DupontPage(pageId, rpt);
        return page;
    }

    private static String getReportPath(Context ctx, String repPath) throws BIReportException {
        String reportPath = "";
        try (Repository rep = null;){
            rep = BISystem.getRepository(ctx);
            reportPath = rep.getNodePropertyByPath("RPT", repPath, "reportPath");
            if (reportPath == null) {
                throw new BIReportException("\u975e\u6cd5\u8bf7\u6c42\uff0c\u5b58\u50a8\u5e93\u4e2d\u672a\u627e\u5230\u6307\u5b9a\u62a5\u8868.");
            }
        }
        return reportPath;
    }

    private static String getReportPath(HttpServletRequest request) throws BIReportException {
        String repPath = request.getParameter("repositoryPath");
        String reportPath = "";
        try (Repository rep = null;){
            rep = BISystem.getRepository(request);
            reportPath = rep.getNodePropertyByPath("RPT", repPath, "reportPath");
            if (reportPath == null) {
                throw new BIReportException("\u975e\u6cd5\u8bf7\u6c42\uff0c\u5b58\u50a8\u5e93\u4e2d\u672a\u627e\u5230\u6307\u5b9a\u62a5\u8868.");
            }
        }
        return reportPath;
    }

    private static BIReportPage createBIMOlapReportPage(String pageId, String repPath, HttpServletRequest request, HttpServletResponse response) throws BIReportException {
        BIReport rpt = BIMFactory.getBIMReportInstance(PageManager.getReportPath(request), repPath, request);
        return new BIReportPage(pageId, rpt.getSubject(), (Report)rpt, "bimolap");
    }

    private static BIReportPage createBIReportPage(String pageId, String repPath, HttpServletRequest request, HttpServletResponse response) throws BIReportException {
        BISolution solution;
        BISubject subject;
        String subjectName = "";
        String reportPath = "";
        String datacenter = null;
        boolean useRepository = true;
        if (repPath != null) {
            try (Repository rep = null;){
                rep = BISystem.getRepository(request);
                subjectName = rep.getNodePropertyByPath("RPT", repPath, "subject");
                if (subjectName == null) {
                    throw new BIReportException("\u975e\u6cd5\u8bf7\u6c42\uff0c\u5b58\u50a8\u5e93\u4e2d\u672a\u627e\u5230\u6307\u5b9a\u62a5\u8868.");
                }
                reportPath = rep.getNodePropertyByPath("RPT", repPath, "reportPath");
                if (reportPath == null) {
                    throw new BIReportException("\u975e\u6cd5\u8bf7\u6c42\uff0c\u5b58\u50a8\u5e93\u4e2d\u672a\u627e\u5230\u6307\u5b9a\u62a5\u8868.");
                }
                try {
                    datacenter = rep.getNodePropertyByPath("RPT", repPath, "datacenter");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            useRepository = false;
            subjectName = request.getParameter("subject");
            if (subjectName == null) {
                throw new BIReportException("\u975e\u6cd5\u8bf7\u6c42\uff0c\u53c2\u6570subject\u4e0d\u80fd\u4e3a\u7a7a.");
            }
            reportPath = request.getParameter("reportPath");
            if (reportPath == null) {
                throw new BIReportException("\u975e\u6cd5\u8bf7\u6c42\uff0c\u53c2\u6570reportPath\u4e0d\u80fd\u4e3a\u7a7a.");
            }
        }
        if ((subject = (solution = BISystem.getSolution()).lookupSubject(subjectName)) == null) {
            throw new BIReportException(subjectName + "\u4e3b\u9898\u5df2\u7ecf\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u8be5\u4e3b\u9898\u3002");
        }
        BIReport report = subject.lookupReport(reportPath, datacenter);
        if (report == null) {
            throw new BIReportException(reportPath + "\u62a5\u8868\u5df2\u7ecf\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u8be5\u62a5\u8868\u3002");
        }
        if (repPath != null) {
            report.setRepositoryPath(repPath);
        }
        BIReportPage page = new BIReportPage(pageId, subject, report, useRepository);
        return page;
    }

    public static KPIMonitorPage createKPIMonitorPage(String pageId, HttpServletRequest request, HttpServletResponse response) throws BIReportException {
        KPIMonitorPage page = new KPIMonitorPage(pageId);
        return page;
    }

    public static IPage createPage(String type, HttpServletRequest request, HttpServletResponse response, String pageId) throws BIReportException {
        WebPage page = null;
        if (null == pageId || "".equals(pageId)) {
            pageId = IDGenerator.getID();
        }
        String repPath = request.getParameter("repositoryPath");
        String from = request.getParameter("from");
        if (PageManager.isCheckPermission(type, from)) {
            String itemID;
            Repository rep = BISystem.getRepository(request);
            BIPermission_EAS permission = new BIPermission_EAS(BISystem.getContext(request));
            if (!permission.hasDataPermission(Constants.PERMISSION_NAME_THEME_CONFIG, itemID = rep.getNodePropertyByPath("RPT", repPath, "permissionID"))) {
                throw new BIReportException("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u65e0\u6743\u9650\u6253\u5f00\u6b64\u62a5\u8868!");
            }
        }
        if ("report".equalsIgnoreCase(type)) {
            page = PageManager.createBIReportPage(pageId, repPath, request, response);
        } else if ("extReport".equalsIgnoreCase(type)) {
            page = PageManager.createExtReportPage(pageId, repPath, request);
        } else if ("dupontReport".equalsIgnoreCase(type)) {
            page = PageManager.createDupontReportPage(pageId, repPath, request, response);
        } else if ("kpiMonitor".equalsIgnoreCase(type)) {
            page = PageManager.createKPIMonitorPage(pageId, request, response);
        } else if ("bimOlapReport".equalsIgnoreCase(type)) {
            page = PageManager.createBIMOlapReportPage(pageId, repPath, request, response);
        } else {
            throw new BIReportException("\u672a\u77e5\u7684\u9875\u9762\u8bf7\u6c42\u7c7b\u578b\uff1a" + type);
        }
        PageManager.cachePage((IPage)page, request);
        return page;
    }

    public static IPage createPage(String type, HttpServletRequest request, HttpServletResponse response) throws BIReportException {
        return PageManager.createPage(type, request, response, null);
    }

    public static boolean isCheckPermission(String type, String from) {
        if (!BISystem.isEAS()) {
            return false;
        }
        if ("portlet".equals(from)) {
            return false;
        }
        return "report".equalsIgnoreCase(type) || "dupontReport".equalsIgnoreCase(type);
    }

    public static String createPageId() {
        return IDGenerator.getID();
    }

    public static synchronized void close(String pageId) {
        IPage page = PageManager.getPage(pageId);
        if (page != null) {
            page.close();
            pageMap.remove(page.getPageId());
            pageUserMap.remove(pageId);
            paramCacheMap.clear();
            logger.debug((Object)("close page:" + pageId));
            PageManager.closeSubReport(pageId);
        }
    }

    private static void closeSubReport(String parentPageId) {
        ArrayList<String> pageIdList = new ArrayList<String>();
        parentPageId = parentPageId + SEP_UNDERLINE;
        for (Object keyObj : pageMap.keySet()) {
            String pageId;
            if (!(keyObj instanceof String) || !(pageId = (String)keyObj).startsWith(parentPageId)) continue;
            pageIdList.add(pageId);
        }
        for (String pageId : pageIdList) {
            IPage page = PageManager.getPage(pageId);
            if (page == null) continue;
            page.close();
            pageMap.remove(pageId);
            pageUserMap.remove(pageId);
            logger.debug((Object)("close page:" + pageId));
        }
    }

    public static synchronized String addCacheParam(JSONObject oJson) {
        String paramCacheId = IDGenerator.getID();
        paramCacheMap.put(paramCacheId, oJson);
        return paramCacheId;
    }

    public static synchronized void removeCacheParam(String paramCacheId) {
        paramCacheMap.remove(paramCacheId);
    }

    public static JSONObject getCacheParam(String paramCacheId) {
        return (JSONObject)paramCacheMap.get(paramCacheId);
    }

    public static synchronized void close(HttpServletRequest request) {
        String userId;
        try {
            userId = BISystem.getCurrentUser(request);
        }
        catch (BIReportException e) {
            logger.error((Object)("close page failed!" + e.getMessage()));
            return;
        }
        ArrayList<String> lstRemovePage = new ArrayList<String>();
        for (String pageId : pageMap.keySet()) {
            String user = (String)pageUserMap.get(pageId);
            if (!userId.equals(user)) continue;
            lstRemovePage.add(pageId);
        }
        for (String pageId : lstRemovePage) {
            PageManager.close(pageId);
        }
    }

    public static void ping(String pageId) {
        IPage page = PageManager.getPage(pageId);
        if (page != null) {
            page.access();
            logger.debug((Object)("ping page:" + pageId));
        }
    }

    private static synchronized void handleTimeout(long timeout) {
        long current = System.currentTimeMillis();
        ReportPage[] pages = new ReportPage[pageMap.size()];
        pageMap.values().toArray(pages);
        for (int i = 0; i < pages.length; ++i) {
            ReportPage page = pages[i];
            if (current - page.getLastAccessTime() <= timeout) continue;
            logger.debug((Object)("page timeout,close it,pageId=" + page.pageId));
            PageManager.close(page.pageId);
        }
    }

    public static void startTimeoutThread() {
        if (!t.isAlive()) {
            t.setDaemon(true);
            t.start();
        }
    }

    public static void main(String[] args) throws InterruptedException {
        int i;
        int countThread = 10;
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch endLatch = new CountDownLatch(countThread);
        Thread[] t = new Thread[countThread];
        for (i = 0; i < countThread; ++i) {
            t[i] = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        startLatch.await();
                        try {
                            for (int n = 0; n < 5; ++n) {
                                String tName = Thread.currentThread().getName();
                                logger.error((Object)tName);
                                ExtReportPage page = new ExtReportPage(tName + n, (ExtReport)new ExtReportImpl(tName, null));
                                try {
                                    Thread.sleep(1500L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                if (tName.equals("50")) {
                                    PageManager.handleTimeout(4000L);
                                    continue;
                                }
                                PageManager.cachePage((IPage)page, tName);
                            }
                        }
                        finally {
                            endLatch.countDown();
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
            t[i].setName(i + "");
        }
        for (i = 0; i < t.length; ++i) {
            t[i].start();
        }
        long start = System.currentTimeMillis();
        startLatch.countDown();
        endLatch.await();
        logger.error((Object)(System.currentTimeMillis() - start));
        logger.error((Object)("\u5f53\u524d\u7f13\u5b58\u62a5\u8868\u5f20\u6570\uff1a" + pageMap.size()));
    }

    static class TimeoutThread
    extends Thread {
        public TimeoutThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(timeSleep);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
                PageManager.handleTimeout(timeOut);
            }
        }
    }
}

