/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.chart;

import com.kingdee.bos.ctrl.analysis.modelcore.ModelChangeEvent;
import com.kingdee.bos.ctrl.analysis.modelcore.ModelChangeListener;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.BIWebComponentSupport;
import com.kingdee.bos.ctrl.analysis.web.chart.ChartConfig;
import com.kingdee.bos.ctrl.analysis.web.chart.ChartFactory;
import com.kingdee.bos.ctrl.analysis.web.chart.ChartModel;
import com.kingdee.bos.ctrl.analysis.web.chart.ChartTypeConstant;
import com.kingdee.bos.ctrl.analysis.web.chart.EASConstant;
import com.kingdee.bos.ctrl.analysis.web.chart.EasGradientPaintFactory;
import com.kingdee.bos.ctrl.analysis.web.chart.MyCategoryURLGenerator;
import com.kingdee.bos.ctrl.analysis.web.chart.MyPieURLGenerator;
import com.kingdee.bos.ctrl.analysis.web.chart.RadarChartConfig;
import com.kingdee.bos.ctrl.analysis.web.export.ExportType;
import com.kingdee.bos.ctrl.analysis.web.export.ExportUtil;
import com.kingdee.bos.ctrl.analysis.web.pagesetup.PageSetup;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.UnitConverter;
import com.kingdee.bos.ctrl.freechart.chart.ChartRenderingInfo;
import com.kingdee.bos.ctrl.freechart.chart.JFreeChart;
import com.kingdee.bos.ctrl.freechart.chart.axis.CategoryLabelPositions;
import com.kingdee.bos.ctrl.freechart.chart.axis.NumberAxis;
import com.kingdee.bos.ctrl.freechart.chart.block.BlockBorder;
import com.kingdee.bos.ctrl.freechart.chart.block.BlockFrame;
import com.kingdee.bos.ctrl.freechart.chart.entity.ChartEntity;
import com.kingdee.bos.ctrl.freechart.chart.entity.EntityCollection;
import com.kingdee.bos.ctrl.freechart.chart.entity.StandardEntityCollection;
import com.kingdee.bos.ctrl.freechart.chart.imagemap.OverLIBToolTipTagFragmentGenerator;
import com.kingdee.bos.ctrl.freechart.chart.imagemap.StandardToolTipTagFragmentGenerator;
import com.kingdee.bos.ctrl.freechart.chart.imagemap.StandardURLTagFragmentGenerator;
import com.kingdee.bos.ctrl.freechart.chart.imagemap.ToolTipTagFragmentGenerator;
import com.kingdee.bos.ctrl.freechart.chart.imagemap.URLTagFragmentGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.CategoryItemLabelGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.ItemLabelAnchor;
import com.kingdee.bos.ctrl.freechart.chart.labels.ItemLabelPosition;
import com.kingdee.bos.ctrl.freechart.chart.labels.StandardCategoryItemLabelGenerator;
import com.kingdee.bos.ctrl.freechart.chart.plot.CategoryPlot;
import com.kingdee.bos.ctrl.freechart.chart.plot.CombinedDomainCategoryPlot;
import com.kingdee.bos.ctrl.freechart.chart.plot.MultiplePiePlot;
import com.kingdee.bos.ctrl.freechart.chart.plot.PiePlot;
import com.kingdee.bos.ctrl.freechart.chart.plot.PiePlot3D;
import com.kingdee.bos.ctrl.freechart.chart.plot.Plot;
import com.kingdee.bos.ctrl.freechart.chart.plot.PlotOrientation;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.CategoryItemRenderer;
import com.kingdee.bos.ctrl.freechart.chart.servlet.ServletUtilities;
import com.kingdee.bos.ctrl.freechart.chart.title.LegendTitle;
import com.kingdee.bos.ctrl.freechart.chart.urls.CategoryURLGenerator;
import com.kingdee.bos.ctrl.freechart.chart.urls.PieURLGenerator;
import com.kingdee.bos.ctrl.freechart.data.category.CategoryDataset;
import com.kingdee.bos.ctrl.freechart.ui.RectangleEdge;
import com.kingdee.bos.ctrl.freechart.ui.TextAnchor;
import com.kingdee.bos.ctrl.freechart.util.Rotation;
import com.kingdee.bos.ctrl.freechart.util.TableOrder;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ChartComponent
extends BIWebComponentSupport
implements ModelChangeListener {
    private static Logger logger = CommonLogger.getLogger(ChartComponent.class);
    private final String CHART_SERVLET_KEY = "chartServlet";
    private String CHART_SERVLET = "/BIReport";
    private Document document;
    private String filename = null;
    private ChartConfig chartConfig;
    private ChartModel chartModel;
    MyCategoryURLGenerator categoryUrlGenerator;
    MyPieURLGenerator pieUrlGenerator;
    private RadarChartConfig radarConfig = new RadarChartConfig();
    ChartRenderingInfo info;

    public ChartComponent(String id, String caption, HttpSession session) throws BIReportException {
        super(id, caption);
        String chartServlet = session.getServletContext().getInitParameter("chartServlet");
        if (chartServlet != null) {
            this.CHART_SERVLET = chartServlet;
        }
        this.chartConfig = new ChartConfig();
        this.chartConfig.addModelChangeListener(this);
        this.chartModel = new ChartModel(this);
        this.categoryUrlGenerator = new MyCategoryURLGenerator(this.chartModel, this.getId());
        this.pieUrlGenerator = new MyPieURLGenerator(this.chartModel, this.getId());
    }

    public ChartModel getChartModel() throws BIReportException {
        return this.chartModel;
    }

    public ChartConfig getChartConfig() {
        return this.chartConfig;
    }

    @Override
    protected void clearPaginInfo() {
        this.chartModel.setDirty(true);
    }

    @Override
    public Document render(HttpServletRequest request) throws Exception {
        this.initPageInfo(this.chartModel.getRowCount());
        int rowStart = this.getRowStart();
        int rowEnd = this.getRowEnd();
        String chartType = this.chartConfig.getStringValue("chartType");
        if (this.chartModel.isDirty()) {
            CategoryDataset[] datasets;
            CategoryDataset dataset = this.chartModel.buildDataset(rowStart, rowEnd);
            Font titleFont = new Font(this.chartConfig.getStringValue("titleFontName"), this.chartConfig.getIntValue("titleFontStyle"), this.chartConfig.getIntValue("titleFontSize"));
            JFreeChart chart = null;
            if (chartType.equalsIgnoreCase(ChartTypeConstant.BAR) || chartType.equalsIgnoreCase(ChartTypeConstant.BAR_H)) {
                chart = ChartFactory.createBarChart(this.chartConfig.getStringValue("chartTitle"), titleFont, this.chartConfig.getStringValue("horizonAxisLabel"), this.chartConfig.getStringValue("verticalAxisLabel"), dataset, chartType.equalsIgnoreCase(ChartTypeConstant.BAR) ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL, this.chartConfig.getBooleanValue("showLegend"), this.chartConfig.getBooleanValue("showTooltip"), this.chartConfig.getBooleanValue("showPercentFormatForTooltip"), this.chartConfig.getBooleanValue("drillThrough"), (CategoryURLGenerator)this.categoryUrlGenerator);
            } else if (chartType.equalsIgnoreCase(ChartTypeConstant.BAR3D) || chartType.equalsIgnoreCase(ChartTypeConstant.BAR3D_H)) {
                chart = ChartFactory.createBarChart3D(this.chartConfig.getStringValue("chartTitle"), titleFont, this.chartConfig.getStringValue("horizonAxisLabel"), this.chartConfig.getStringValue("verticalAxisLabel"), dataset, chartType.equalsIgnoreCase(ChartTypeConstant.BAR3D) ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL, this.chartConfig.getBooleanValue("showLegend"), this.chartConfig.getBooleanValue("showTooltip"), this.chartConfig.getBooleanValue("showPercentFormatForTooltip"), this.chartConfig.getBooleanValue("drillThrough"), (CategoryURLGenerator)this.categoryUrlGenerator);
            } else if (chartType.equalsIgnoreCase(ChartTypeConstant.STACKEDBAR) || chartType.equalsIgnoreCase(ChartTypeConstant.STACKEDBAR_H)) {
                chart = ChartFactory.createStackedBarChart(this.chartConfig.getStringValue("chartTitle"), titleFont, this.chartConfig.getStringValue("horizonAxisLabel"), this.chartConfig.getStringValue("verticalAxisLabel"), dataset, chartType.equalsIgnoreCase(ChartTypeConstant.STACKEDBAR) ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL, this.chartConfig.getBooleanValue("showLegend"), this.chartConfig.getBooleanValue("showTooltip"), this.chartConfig.getBooleanValue("showPercentFormatForTooltip"), this.chartConfig.getBooleanValue("drillThrough"), (CategoryURLGenerator)this.categoryUrlGenerator);
            } else if (chartType.equalsIgnoreCase(ChartTypeConstant.STATCKEDBAR3D) || chartType.equalsIgnoreCase(ChartTypeConstant.STATCKEDBAR3D_H)) {
                chart = ChartFactory.createStackedBarChart3D(this.chartConfig.getStringValue("chartTitle"), titleFont, this.chartConfig.getStringValue("horizonAxisLabel"), this.chartConfig.getStringValue("verticalAxisLabel"), dataset, chartType.equalsIgnoreCase(ChartTypeConstant.STATCKEDBAR3D) ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL, this.chartConfig.getBooleanValue("showLegend"), this.chartConfig.getBooleanValue("showTooltip"), this.chartConfig.getBooleanValue("showPercentFormatForTooltip"), this.chartConfig.getBooleanValue("drillThrough"), (CategoryURLGenerator)this.categoryUrlGenerator);
            } else if (chartType.equalsIgnoreCase(ChartTypeConstant.AREA) || chartType.equalsIgnoreCase(ChartTypeConstant.AREA_H)) {
                chart = ChartFactory.createAreaChart(this.chartConfig.getStringValue("chartTitle"), titleFont, this.chartConfig.getStringValue("horizonAxisLabel"), this.chartConfig.getStringValue("verticalAxisLabel"), dataset, chartType.equalsIgnoreCase(ChartTypeConstant.AREA) ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL, this.chartConfig.getBooleanValue("showLegend"), this.chartConfig.getBooleanValue("showTooltip"), this.chartConfig.getBooleanValue("showPercentFormatForTooltip"), this.chartConfig.getBooleanValue("drillThrough"), (CategoryURLGenerator)this.categoryUrlGenerator);
            } else if (chartType.equalsIgnoreCase(ChartTypeConstant.STATCKEDAREA) || chartType.equalsIgnoreCase(ChartTypeConstant.STATCKEDAREA_H)) {
                chart = ChartFactory.createStackedAreaChart(this.chartConfig.getStringValue("chartTitle"), titleFont, this.chartConfig.getStringValue("horizonAxisLabel"), this.chartConfig.getStringValue("verticalAxisLabel"), dataset, chartType.equalsIgnoreCase(ChartTypeConstant.STATCKEDAREA) ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL, this.chartConfig.getBooleanValue("showLegend"), this.chartConfig.getBooleanValue("showTooltip"), this.chartConfig.getBooleanValue("showPercentFormatForTooltip"), this.chartConfig.getBooleanValue("drillThrough"), (CategoryURLGenerator)this.categoryUrlGenerator);
            } else if (chartType.equalsIgnoreCase(ChartTypeConstant.LINE)) {
                chart = ChartFactory.createLineChart(this.chartConfig.getStringValue("chartTitle"), titleFont, this.chartConfig.getStringValue("horizonAxisLabel"), this.chartConfig.getStringValue("verticalAxisLabel"), dataset, PlotOrientation.VERTICAL, this.chartConfig.getBooleanValue("showLegend"), this.chartConfig.getBooleanValue("showTooltip"), this.chartConfig.getBooleanValue("showPercentFormatForTooltip"), this.chartConfig.getBooleanValue("drillThrough"), (CategoryURLGenerator)this.categoryUrlGenerator);
            } else if (chartType.equalsIgnoreCase(ChartTypeConstant.RADAR)) {
                chart = ChartFactory.createRadarChart2(this.chartConfig.getStringValue("chartTitle"), titleFont, dataset, this.getRemixedRadarMinColumnIndex(), this.getRemixedRadarTargetColumnIndex(), this.chartConfig.getBooleanValue("showLegend"), this.radarConfig.isDisplayName(), this.radarConfig.isDisplayValue(), this.radarConfig.isFillBackground(), this.chartConfig.getBooleanValue("showPercentFormatForValue"), this.chartConfig.getBooleanValue("showPercentFormatForTooltip"));
            } else if (chartType.equalsIgnoreCase(ChartTypeConstant.MULTIPIE) || chartType.equalsIgnoreCase(ChartTypeConstant.MULTIPIE_H)) {
                chart = ChartFactory.createMultiplePieChart(this.chartConfig.getStringValue("chartTitle"), titleFont, dataset, chartType.equalsIgnoreCase(ChartTypeConstant.MULTIPIE) ? TableOrder.BY_COLUMN : TableOrder.BY_ROW, this.chartConfig.getBooleanValue("showLegend"), this.chartConfig.getBooleanValue("showTooltip"), this.chartConfig.getBooleanValue("drillThrough"), (PieURLGenerator)this.pieUrlGenerator);
            } else if (chartType.equalsIgnoreCase(ChartTypeConstant.BARLINE)) {
                if (dataset.getRowCount() == 1) {
                    chart = ChartFactory.createBarChart(this.chartConfig.getStringValue("chartTitle"), titleFont, this.chartConfig.getStringValue("horizonAxisLabel"), this.chartConfig.getStringValue("verticalAxisLabel"), dataset, PlotOrientation.VERTICAL, this.chartConfig.getBooleanValue("showLegend"), this.chartConfig.getBooleanValue("showTooltip"), this.chartConfig.getBooleanValue("showPercentFormatForTooltip"), this.chartConfig.getBooleanValue("drillThrough"), (CategoryURLGenerator)this.categoryUrlGenerator);
                } else {
                    datasets = this.chartModel.splitBarLineDataset(dataset, this.chartConfig.getStringValue("lineMemberUniqueNames"));
                    chart = ChartFactory.createBarLineChart(this.chartConfig.getStringValue("chartTitle"), titleFont, this.chartConfig.getStringValue("horizonAxisLabel"), this.chartConfig.getBooleanValue("showTooltip"), this.chartConfig.getBooleanValue("drillThrough"), (CategoryURLGenerator)this.categoryUrlGenerator, this.chartConfig.getBooleanValue("showLegend"), datasets[0], "", datasets[1], "");
                }
            } else if (chartType.equalsIgnoreCase(ChartTypeConstant.COMBINEDBARLINE)) {
                if (dataset.getRowCount() == 1) {
                    chart = ChartFactory.createBarChart(this.chartConfig.getStringValue("chartTitle"), titleFont, this.chartConfig.getStringValue("horizonAxisLabel"), this.chartConfig.getStringValue("verticalAxisLabel"), dataset, PlotOrientation.VERTICAL, this.chartConfig.getBooleanValue("showLegend"), this.chartConfig.getBooleanValue("showTooltip"), this.chartConfig.getBooleanValue("showPercentFormatForTooltip"), this.chartConfig.getBooleanValue("drillThrough"), (CategoryURLGenerator)this.categoryUrlGenerator);
                } else {
                    datasets = this.chartModel.splitBarLineDataset(dataset, this.chartConfig.getStringValue("lineMemberUniqueNames"));
                    chart = ChartFactory.createCombineBarLineChart(this.chartConfig.getStringValue("chartTitle"), titleFont, this.chartConfig.getStringValue("horizonAxisLabel"), this.chartConfig.getBooleanValue("showTooltip"), this.chartConfig.getBooleanValue("drillThrough"), (CategoryURLGenerator)this.categoryUrlGenerator, this.chartConfig.getBooleanValue("showLegend"), datasets[0], "", datasets[1], "");
                }
            } else {
                throw new Exception("An unknown Chart Type was requested");
            }
            try {
                PiePlot3D piePlot;
                CategoryDataset data;
                Color backgroudColor = new Color(0xFFFFFF);
                chart.setBackgroundPaint((Paint)backgroudColor);
                Font axisFont = new Font(this.chartConfig.getStringValue("axisFontName"), this.chartConfig.getIntValue("axisFontStyle"), this.chartConfig.getIntValue("axisFontSize"));
                Font axisTickFont = new Font(this.chartConfig.getStringValue("axisTickFontName"), this.chartConfig.getIntValue("axisTickFontStyle"), this.chartConfig.getIntValue("axisTickFontSize"));
                Font legendFont = new Font(this.chartConfig.getStringValue("legendFontName"), this.chartConfig.getIntValue("legendFontStyle"), this.chartConfig.getIntValue("legendFontSize"));
                Plot plot = chart.getPlot();
                if (plot instanceof CombinedDomainCategoryPlot) {
                    CombinedDomainCategoryPlot cplot = (CombinedDomainCategoryPlot)plot;
                    List plots = cplot.getSubplots();
                    for (CategoryPlot catPlot : plots) {
                        catPlot.getDomainAxis().setLabelFont(axisFont);
                        catPlot.getRangeAxis().setLabelFont(axisFont);
                        catPlot.getDomainAxis().setTickLabelFont(axisTickFont);
                        catPlot.getRangeAxis().setTickLabelFont(axisTickFont);
                        catPlot.getDomainAxis().setMaximumCategoryLabelWidthRatio(100.0f);
                        catPlot.setBackgroundPaint((Paint)new Color(0xFFFFFF));
                        catPlot.setRangeGridIntervalBackgroudPaint((Paint)new Color(15462649));
                        CategoryDataset data2 = catPlot.getDataset();
                        CategoryItemRenderer renderer = catPlot.getRenderer();
                        int serierCount = data2.getRowCount();
                        if (serierCount > EasGradientPaintFactory.getCount()) {
                            serierCount = EasGradientPaintFactory.getCount();
                        }
                        for (int i = 0; i < serierCount; ++i) {
                            GradientPaint p = EasGradientPaintFactory.getGradientPaint(i, false);
                            GradientPaint p2 = EasGradientPaintFactory.getGradientPaint(i, true);
                            renderer.setSeriesPaint(i, (Paint)p);
                            renderer.setSeriesOutlinePaint(i, (Paint)p2);
                            renderer.setSeriesOutlineStroke(i, EASConstant.STOKE_PIESECTIONOUTLINE);
                            this.renderItemData(renderer, i, legendFont, p);
                            renderer.setSeriesItemLabelPaint(i, (Paint)Color.BLACK);
                            renderer.setSeriesPositiveItemLabelPosition(i, new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.BASELINE_CENTER));
                            renderer.setSeriesNegativeItemLabelPosition(i, new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.BASELINE_CENTER));
                        }
                        int categoryCount = data2.getColumnCount();
                        catPlot.getDomainAxis().setCategoryLabelPositions(this.getCategoryLabelPosition(categoryCount, chartType));
                        if (!this.chartConfig.getBooleanValue("showPercentFormatForValue")) continue;
                        NumberAxis rangeAxis = (NumberAxis)catPlot.getRangeAxis();
                        rangeAxis.setNumberFormatOverride(NumberFormat.getPercentInstance());
                    }
                } else if (plot instanceof CategoryPlot) {
                    CategoryPlot catPlot = (CategoryPlot)plot;
                    catPlot.getDomainAxis().setLabelFont(axisFont);
                    catPlot.getRangeAxis().setLabelFont(axisFont);
                    catPlot.getDomainAxis().setTickLabelFont(axisTickFont);
                    catPlot.getRangeAxis().setTickLabelFont(axisTickFont);
                    catPlot.getDomainAxis().setMaximumCategoryLabelWidthRatio(100.0f);
                    catPlot.setBackgroundPaint((Paint)new Color(0xFFFFFF));
                    catPlot.setRangeGridIntervalBackgroudPaint((Paint)new Color(15462649));
                    data = catPlot.getDataset();
                    CategoryItemRenderer renderer = catPlot.getRenderer();
                    int serierCount = data.getRowCount();
                    if (serierCount > EasGradientPaintFactory.getCount()) {
                        serierCount = EasGradientPaintFactory.getCount();
                    }
                    for (int i = 0; i < serierCount; ++i) {
                        GradientPaint p = EasGradientPaintFactory.getGradientPaint(i, false);
                        GradientPaint p2 = EasGradientPaintFactory.getGradientPaint(i, true);
                        renderer.setSeriesPaint(i, (Paint)p);
                        renderer.setSeriesOutlinePaint(i, (Paint)p2);
                        renderer.setSeriesOutlineStroke(i, EASConstant.STOKE_PIESECTIONOUTLINE);
                        this.renderItemData(renderer, i, legendFont, p);
                    }
                    int categoryCount = data.getColumnCount();
                    catPlot.getDomainAxis().setCategoryLabelPositions(this.getCategoryLabelPosition(categoryCount, chartType));
                    if (catPlot.getDatasetCount() > 1) {
                        data = catPlot.getDataset(1);
                        renderer = catPlot.getRenderer(1);
                        int serierCount2 = data.getRowCount();
                        if (serierCount2 > EasGradientPaintFactory.getCount()) {
                            serierCount2 = EasGradientPaintFactory.getCount();
                        }
                        for (int i = 0; i < serierCount2; ++i) {
                            GradientPaint p = EasGradientPaintFactory.getGradientPaint(i + serierCount, false);
                            GradientPaint p2 = EasGradientPaintFactory.getGradientPaint(i + serierCount, true);
                            renderer.setSeriesPaint(i, (Paint)p);
                            renderer.setSeriesOutlinePaint(i, (Paint)p2);
                            renderer.setSeriesOutlineStroke(i, EASConstant.STOKE_PIESECTIONOUTLINE);
                            this.renderItemData(renderer, i, legendFont, p);
                        }
                    }
                    if (this.chartConfig.getBooleanValue("showPercentFormatForValue")) {
                        NumberAxis rangeAxis = (NumberAxis)catPlot.getRangeAxis();
                        rangeAxis.setNumberFormatOverride(NumberFormat.getPercentInstance());
                    }
                } else if (plot instanceof MultiplePiePlot) {
                    MultiplePiePlot mpplot = (MultiplePiePlot)plot;
                    data = mpplot.getDataset();
                    PiePlot piePlot2 = (PiePlot)mpplot.getPieChart().getPlot();
                    piePlot2.setLabelFont(axisFont);
                    piePlot2.setLabelShadowPaint(null);
                    if (mpplot.getDataExtractOrder().equals((Object)TableOrder.BY_COLUMN)) {
                        int count = data.getRowCount();
                        if (count > EasGradientPaintFactory.getCount()) {
                            count = EasGradientPaintFactory.getCount();
                        }
                        for (int i = 0; i < count; ++i) {
                            piePlot2.setSectionPaint(data.getRowKey(i), (Paint)EasGradientPaintFactory.getGradientPaint(i));
                        }
                    } else {
                        int count = data.getColumnCount();
                        if (count > EasGradientPaintFactory.getCount()) {
                            count = EasGradientPaintFactory.getCount();
                        }
                        for (int i = 0; i < count; ++i) {
                            piePlot2.setSectionPaint(data.getColumnKey(i), (Paint)EasGradientPaintFactory.getGradientPaint(i, false));
                            piePlot2.setSectionOutlinePaint(data.getColumnKey(i), (Paint)EasGradientPaintFactory.getGradientPaint(i, true));
                        }
                    }
                } else if (plot instanceof PiePlot3D) {
                    piePlot = (PiePlot3D)plot;
                    piePlot.setLabelFont(axisFont);
                    piePlot.setDirection(Rotation.CLOCKWISE);
                    piePlot.setForegroundAlpha(0.5f);
                    piePlot.setNoDataMessage("No data to display");
                } else if (plot instanceof PiePlot) {
                    piePlot = (PiePlot)plot;
                    piePlot.setLabelFont(axisFont);
                }
                LegendTitle legend = chart.getLegend();
                if (legend != null) {
                    legend.setItemFont(legendFont);
                    RectangleEdge legendRectEdge = RectangleEdge.BOTTOM;
                    switch (this.chartConfig.getIntValue("legendPosition")) {
                        case 0: {
                            legendRectEdge = RectangleEdge.LEFT;
                            break;
                        }
                        case 1: {
                            legendRectEdge = RectangleEdge.TOP;
                            break;
                        }
                        case 2: {
                            legendRectEdge = RectangleEdge.RIGHT;
                            break;
                        }
                        case 3: {
                            legendRectEdge = RectangleEdge.BOTTOM;
                        }
                    }
                    legend.setPosition(legendRectEdge);
                    legend.setFrame((BlockFrame)BlockBorder.NONE);
                    legend.setItemFont(legendFont);
                    legend.setItemPaint((Paint)Color.BLACK);
                    legend.setBackgroundPaint((Paint)backgroudColor);
                }
                this.info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
                HttpSession session = request.getSession();
                this.filename = ServletUtilities.saveChartAsPNG((JFreeChart)chart, (int)this.chartConfig.getIntValue("chartWidth"), (int)this.chartConfig.getIntValue("chartHeight"), (ChartRenderingInfo)this.info, (HttpSession)session);
                this.chartModel.setDirty(false);
                return this.buildXChart(request, chartType, this.info);
            }
            catch (Exception e) {
                logger.info((Object)"\u751f\u6210\u56fe\u7247\u51fa\u9519.", (Throwable)e);
                this.filename = "public_error_500x300.png";
                this.chartModel.setDirty(true);
            }
        }
        return this.buildXChart(request, chartType, this.info);
    }

    private CategoryLabelPositions getCategoryLabelPosition(int categoryCount, String chartType) {
        if (ChartTypeConstant.isH(chartType)) {
            return CategoryLabelPositions.STANDARD;
        }
        String i = this.chartConfig.getStringValue("categoryLabelAllign");
        if ("Auto".equals(i)) {
            if (categoryCount > 5) {
                return CategoryLabelPositions.UP_45;
            }
            return CategoryLabelPositions.STANDARD;
        }
        if ("Horizon".equals(i)) {
            return CategoryLabelPositions.STANDARD;
        }
        if ("Up90".equals(i)) {
            return CategoryLabelPositions.UP_90;
        }
        if ("Down90".equals(i)) {
            return CategoryLabelPositions.DOWN_90;
        }
        if ("Up45".equals(i)) {
            return CategoryLabelPositions.UP_45;
        }
        if ("Down45".equals(i)) {
            return CategoryLabelPositions.DOWN_45;
        }
        return CategoryLabelPositions.STANDARD;
    }

    private Document buildXChart(HttpServletRequest request, String chartType, ChartRenderingInfo info) throws Exception {
        DocumentBuilder parser2 = XmlUtil.getParser();
        String xchart = "<chart>" + this.writeImageMap(this.filename, info, false) + "</chart>";
        ByteArrayInputStream stream = new ByteArrayInputStream(xchart.getBytes("UTF-8"));
        this.document = parser2.parse(stream);
        Element root = this.document.getDocumentElement();
        String graphURL = request.getContextPath() + this.CHART_SERVLET + "?" + "servletType" + "=" + "GetChart" + "&filename=" + this.filename;
        Element img = this.document.createElement("img");
        img.setAttribute("src", graphURL);
        int width = this.chartConfig.getIntValue("chartWidth");
        int height = this.chartConfig.getIntValue("chartHeight");
        img.setAttribute("mwidth", "" + width);
        img.setAttribute("width", "" + width);
        img.setAttribute("mheight", "" + height);
        img.setAttribute("height", "" + height);
        img.setAttribute("style", "border:0;");
        img.setAttribute("usemap", "#" + this.filename);
        root.appendChild(img);
        root.appendChild(this.buildSlicerDOM());
        root.appendChild(this.buildHierachyDOM(this.document, this.chartModel.getRowHierarchies(), "axis_row"));
        root.appendChild(this.buildHierachyDOM(this.document, this.chartModel.getColumnHierarchies(), "axis_col"));
        Element ele = this.document.createElement("chartType");
        ele.setAttribute("chartType", chartType);
        ele.setAttribute("showChangeType", this.chartConfig.getBooleanValue("showChangeType") ? "true" : "false");
        root.appendChild(ele);
        ele = this.document.createElement("chartConfig");
        ele.setAttribute("categoryLabelAllign", this.chartConfig.getStringValue("categoryLabelAllign"));
        ele.setAttribute("mwidth", "" + width);
        ele.setAttribute("mheight", "" + height);
        ele.setAttribute("topN_Value", "" + this.chartModel.getDataModel().getTopN().value);
        ele.setAttribute("topN_Other", this.chartModel.getDataModel().getTopN().other ? "true" : "false");
        root.appendChild(ele);
        return this.document;
    }

    private String writeImageMap(String name, ChartRenderingInfo info, boolean useOverLibForToolTips) {
        StringBuffer sb = new StringBuffer();
        sb.append("<map name=\"" + name + "\">");
        if (info != null) {
            EntityCollection entities = info.getEntityCollection();
            for (ChartEntity entity : entities) {
                String area = "";
                area = useOverLibForToolTips ? entity.getImageMapAreaTag((ToolTipTagFragmentGenerator)new OverLIBToolTipTagFragmentGenerator(), (URLTagFragmentGenerator)new StandardURLTagFragmentGenerator()) : entity.getImageMapAreaTag((ToolTipTagFragmentGenerator)new StandardToolTipTagFragmentGenerator(), (URLTagFragmentGenerator)new StandardURLTagFragmentGenerator());
                if ((area = area.replaceAll("&", "&amp;")).length() <= 0) continue;
                sb.append(area);
            }
        }
        sb.append("</map>");
        return sb.toString();
    }

    private Element buildSlicerDOM() throws OlapException {
        Element slicer = this.document.createElement("slicer");
        Member[] members = this.chartModel.getSlicerMembers();
        if (members != null) {
            for (int i = 0; i < members.length; ++i) {
                Element e = this.buildSlicerMember(members[i]);
                slicer.appendChild(e);
            }
        }
        return slicer;
    }

    private Element buildSlicerMember(Member m) {
        Element e = this.document.createElement("member");
        e.setAttribute("member.uniqueName", m.getUniqueName());
        e.setAttribute("member.caption", m.getCaption());
        e.setAttribute("hierarchy.uniqueName", m.getHierarchy().getUniqueName());
        e.setAttribute("hierarchy.caption", m.getHierarchy().getCaption());
        return e;
    }

    @Override
    public void setCurrentPage(int page) {
        super.setCurrentPage(page);
        this.setDirty(true);
    }

    private int getRemixedRadarTargetColumnIndex() {
        if (!this.radarConfig.isEnable()) {
            return 0;
        }
        List validIndexList = this.radarConfig.getValidIndexList();
        if (validIndexList == null) {
            return this.radarConfig.getRadarTargetColumnIndex();
        }
        if (this.radarConfig.getRadarTargetSelfDefValues() != null && this.radarConfig.getRadarMinSelfDefValues() != null) {
            return validIndexList.size() - 2;
        }
        ArrayList list = new ArrayList(validIndexList);
        int i = 0;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            if ((int)Double.parseDouble((String)it.next()) >= this.radarConfig.getRadarTargetColumnIndex()) continue;
            ++i;
        }
        return i;
    }

    private int getRemixedRadarMinColumnIndex() {
        if (!this.radarConfig.isEnable()) {
            return 1;
        }
        List validIndexList = this.radarConfig.getValidIndexList();
        if (validIndexList == null) {
            return this.radarConfig.getRadarMinColumnIndex();
        }
        if (this.radarConfig.getRadarTargetSelfDefValues() != null && this.radarConfig.getRadarMinSelfDefValues() != null) {
            return validIndexList.size() - 1;
        }
        ArrayList list = new ArrayList(validIndexList);
        int i = 0;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            if ((int)Double.parseDouble((String)it.next()) >= this.radarConfig.getRadarMinColumnIndex()) continue;
            ++i;
        }
        return i;
    }

    public void setDirty(boolean dirty) {
        if (this.chartModel != null) {
            this.chartModel.setDirty(dirty);
        }
    }

    public void clearChartStatus() {
        if (this.chartModel != null) {
            this.chartModel.setDataModel(null);
        }
    }

    @Override
    public void modelChanged(ModelChangeEvent e) {
        if (this.chartModel != null) {
            this.chartModel.setDirty(true);
        }
    }

    public void structureChanged(ModelChangeEvent e) {
        if (this.chartModel != null) {
            this.chartModel.setDirty(true);
        }
    }

    public RadarChartConfig getRadarConfig() {
        return this.radarConfig;
    }

    public void setRadarConfig(RadarChartConfig radarConfig) {
        this.radarConfig = radarConfig;
    }

    public String getFilename() {
        return this.filename;
    }

    private void buildChart(KDSSheet sheet, int row) throws BIReportException {
        String tempDirName = ExportUtil.getTempDir();
        File file = new File(tempDirName + this.filename);
        if (!file.exists()) {
            throw new BIReportException("File '" + file.getAbsolutePath() + "' does not exist");
        }
        Image image = Toolkit.getDefaultToolkit().createImage(tempDirName + this.filename);
        sheet.getRows().setRowHeight(row, (float)UnitConverter.px2mm((int)this.chartConfig.getIntValue("chartHeight")));
        sheet.getColumns().setColumnWidth(0, (float)UnitConverter.px2mm((int)this.chartConfig.getIntValue("chartWidth")));
        sheet.getCellStyleAttributes(row, 0).setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        sheet.getCellStyleAttributes(row, 0).setVerticalAlign(Styles.VerticalAlignment.TOP);
        sheet.setCellValue(row, 0, (Object)image);
    }

    /*
     * Loose catch block
     */
    private void buildChart(KDSBook book, String sheetName) throws BIReportException {
        String tempDirName = ExportUtil.getTempDir();
        File file = new File(tempDirName + this.filename);
        if (!file.exists()) {
            throw new BIReportException("File '" + file.getAbsolutePath() + "' does not exist");
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] byteImage = new byte[(int)file.length()];
            fis.read(byteImage);
            KDSBook.KDSImage image = new KDSBook.KDSImage(byteImage, 6, 100, 100);
            image.setSheetName(sheetName);
            book.addImage(image);
        }
        catch (FileNotFoundException byteImage) {
            CloseUtil.close((Closeable[])new Closeable[]{fis});
        }
        catch (IOException e) {
            throw new BIReportException("File '" + file.getAbsolutePath() + "' \u8bfb\u5199\u5931\u8d25\uff01");
            {
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{fis});
                    throw throwable;
                }
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{fis});
    }

    @Override
    public KDSSheet export(KDSBook book, PageSetup pageSetup, String exportType, int sheetIndex, HttpServletRequest request) throws BIReportException, OlapException {
        KDSSheet sheet = null;
        int row = 0;
        if (ExportType.TYPE_PDF.equalsIgnoreCase(exportType)) {
            sheet = new KDSSheet(book, this.getCaptionForSheet(sheetIndex));
            row = this.buildCaption(sheet, row, pageSetup.getCaption(), pageSetup.getCaptionFont());
            if (pageSetup.isShowSlicer()) {
                row = this.buildSlicer(sheet, row, this.chartModel.getSlicerMembers());
            }
            this.buildChart(sheet, row);
            int pageContentWidth = pageSetup.getPaperSizeWidth() - pageSetup.getPaperMaginLeft() - pageSetup.getPaperMaginRight();
            this.adjustCaptionSclier(sheet, 1, pageContentWidth, pageSetup.isShowSlicer());
        } else if (ExportType.TYPE_EXCEL.equalsIgnoreCase(exportType)) {
            this.buildChart(book, this.getCaptionForSheet(sheetIndex));
        } else {
            throw new BIReportException("unsupport exportType " + exportType + "!");
        }
        return sheet;
    }

    private String getCaptionForSheet(int sheetIndex) {
        if (this.getCaption() == null || "".equals(this.getCaption())) {
            return "Sheet" + sheetIndex + "(\u56fe)";
        }
        return "Sheet" + sheetIndex + "(" + this.getCaption() + ")";
    }

    public boolean doMemberDrill(String memberUniqueName) {
        return this.chartModel.doMemberDrill(memberUniqueName);
    }

    public boolean doLevelDrill(String memberUniqueName) {
        return this.chartModel.doLevelDrill(memberUniqueName);
    }

    public boolean doDrillUp(String memberUniqueName) {
        return this.chartModel.doDrillUp(memberUniqueName);
    }

    private void renderItemData(CategoryItemRenderer renderer, int index, Font font, Paint paint) {
        if (this.chartConfig.getBooleanValue("showItemData")) {
            renderer.setSeriesItemLabelGenerator(index, (CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
            renderer.setSeriesItemLabelFont(index, font);
            renderer.setSeriesItemLabelPaint(index, paint);
            renderer.setSeriesItemLabelsVisible(index, true);
        }
    }

    public boolean setOlapModel(OlapModel olapModel) {
        return this.chartModel.setOlapModel(olapModel);
    }

    @Override
    public OlapModel getOlapModel() {
        return this.chartModel.getOlapModel();
    }
}

