/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.dashboard;

import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSON;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DashBoardException;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DashBoardPage;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DashBoardPageManager;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DataSource;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.Dial;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DashboardServletHandler {
    private static final String DASHBOARD_XML_PARAMETER = "xml";
    private static final String DATASOURCE_COMMAND = "datasourceCommand";
    private static final Logger logger = CommonLogger.getLogger(DashboardServletHandler.class);

    public static JSON handle(HttpServletRequest request, HttpServletResponse response) throws DashBoardException {
        DashBoardPage page = DashBoardPageManager.create(request, response);
        return page.init(request);
    }

    public static JSON handle2(HttpServletRequest request, HttpServletResponse response) throws DashBoardException {
        String xml = request.getParameter(DASHBOARD_XML_PARAMETER);
        String datasourceCommand = request.getParameter(DATASOURCE_COMMAND);
        if (xml != null) {
            DashBoardPage page = DashBoardPageManager.create(xml);
            return page.init(request);
        }
        if (datasourceCommand != null) {
            return DashboardServletHandler.handleDatasourceCommand(request, datasourceCommand);
        }
        return DashboardServletHandler.handleCommand(request);
    }

    private static JSON handleDatasourceCommand(HttpServletRequest request, String datasourceCommand) throws DashBoardException {
        JSON ret = null;
        String pageId = request.getParameter("pageId");
        DashBoardPage page = DashBoardPageManager.get(pageId);
        if (page == null) {
            throw new DashBoardException("\u627e\u4e0d\u5230\u9875\u5bf9\u8c61");
        }
        String dsId = request.getParameter("id");
        DataSource ds = page.getDataSource(dsId);
        if (ds == null) {
            throw new DashBoardException("\u627e\u4e0d\u5230\u6570\u636e\u6e90\u5bf9\u8c61");
        }
        try {
            ret = (JSON)DataSource.class.getDeclaredMethod(datasourceCommand, HttpServletRequest.class).invoke((Object)ds, request);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            logger.warn((Object)t.getMessage(), t);
            throw new DashBoardException(t);
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            throw new DashBoardException(e);
        }
        return ret;
    }

    private static JSON handleCommand(HttpServletRequest request) throws DashBoardException {
        JSON ret = null;
        String pageId = request.getParameter("pageId");
        DashBoardPage page = DashBoardPageManager.get(pageId);
        if (page == null) {
            throw new DashBoardException("\u627e\u4e0d\u5230\u9875\u5bf9\u8c61");
        }
        String id = request.getParameter("id");
        Dial dial = page.getDial(id);
        if (dial == null) {
            throw new DashBoardException("\u627e\u4e0d\u5230\u4eea\u8868\u76d8\u5bf9\u8c61");
        }
        String command = request.getParameter("command");
        if (command == null) {
            throw new DashBoardException("\u6ca1\u6709\u6307\u5b9a\u8981\u6267\u884c\u7684\u6307\u4ee4");
        }
        try {
            ret = (JSON)dial.getClass().getDeclaredMethod(command, HttpServletRequest.class).invoke((Object)dial, request);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            logger.warn((Object)t.getMessage(), t);
            throw new DashBoardException(t);
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            throw new DashBoardException(e);
        }
        return ret;
    }
}

