/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.dashboard.chart;

import com.kingdee.bos.ctrl.analysis.web.dashboard.DashBoardException;
import com.kingdee.bos.ctrl.analysis.web.dashboard.SQLUtil;
import com.kingdee.bos.ctrl.analysis.web.dashboard.chart.ChartConfig;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.freechart.data.category.CategoryDataset;
import com.kingdee.bos.ctrl.freechart.data.category.DefaultCategoryDataset;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

public class DataSetBuilder {
    public static CategoryDataset build(ChartConfig cc) throws BIReportException {
        String[] ys = cc.getYColumns();
        if (ys.length == 0) {
            return DataSetBuilder.buildXMeasureDataSet(cc);
        }
        return DataSetBuilder.buildXYMeasureDataSet(cc);
    }

    private static CategoryDataset buildXMeasureDataSet(ChartConfig cc) throws BIReportException {
        final String[] xs = cc.getXColumns();
        final String[] ms = cc.getMeasureColumns();
        StringBuffer xSeq = new StringBuffer();
        for (int i = 0; i < xs.length; ++i) {
            xSeq.append(xs[i]).append(",");
        }
        if (xSeq.length() <= 0) {
            throw new DashBoardException("\u56fe\u8868X\u8f74\u6ca1\u6709\u7ed1\u5b9a\u5b57\u6bb5.");
        }
        xSeq.deleteCharAt(xSeq.length() - 1);
        StringBuffer mSeq = new StringBuffer();
        for (int i = 0; i < ms.length; ++i) {
            mSeq.append("SUM(").append(ms[i]).append(") AS ").append(ms[i]).append(",");
        }
        if (mSeq.length() <= 0) {
            throw new DashBoardException("\u5ea6\u91cf\u8f74\u6ca1\u6709\u7ed1\u5b9a\u6570\u636e\u6e90\u8f93\u51fa\u5217");
        }
        mSeq.deleteCharAt(mSeq.length() - 1);
        List filterList = cc.getFilterList();
        StringBuffer whereClause = new StringBuffer();
        if (filterList != null) {
            Iterator it = filterList.iterator();
            while (it.hasNext()) {
                whereClause.append(it.next()).append(" AND ");
            }
            int whereLength = whereClause.length();
            if (whereLength > 0) {
                whereClause.delete(whereLength - 4, whereLength - 1);
                whereClause.insert(0, " WHERE ");
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ").append(xSeq).append(",").append(mSeq).append(" FROM ( ").append(cc.getDataSource().getQuerySQL()).append(" ) AS AHBSNWSBSWJWJ").append(whereClause).append(" GROUP BY ").append(xSeq).append(" ORDER BY ").append(xSeq);
        return (CategoryDataset)SQLUtil.handleResultSet(cc.getRequest(), cc.getDataSource().getDatacenter(), sql.toString(), new SQLUtil.ResultSetHandler(){

            @Override
            public Object handle(ResultSet rs) throws SQLException {
                DefaultCategoryDataset set = new DefaultCategoryDataset();
                while (rs.next()) {
                    int i;
                    String category = "";
                    for (i = 0; i < xs.length; ++i) {
                        category = category + rs.getString(xs[i]);
                        if (i >= xs.length - 1) continue;
                        category = category + ",";
                    }
                    for (i = 0; i < ms.length; ++i) {
                        set.setValue((Number)rs.getBigDecimal(ms[i]), (Comparable)((Object)ms[i]), (Comparable)((Object)category));
                    }
                }
                return set;
            }
        }, "\u6784\u9020\u56fe\u8868\u6570\u636e\u96c6\u5931\u8d25");
    }

    private static CategoryDataset buildXYMeasureDataSet(ChartConfig cc) throws BIReportException {
        final String[] xs = cc.getXColumns();
        final String[] ys = cc.getYColumns();
        final String[] ms = cc.getMeasureColumns();
        StringBuffer xSeq = new StringBuffer();
        for (int i = 0; i < xs.length; ++i) {
            xSeq.append(xs[i]).append(",");
        }
        xSeq.deleteCharAt(xSeq.length() - 1);
        StringBuffer ySeq = new StringBuffer();
        for (int i = 0; i < ys.length; ++i) {
            ySeq.append(ys[i]).append(",");
        }
        ySeq.deleteCharAt(ySeq.length() - 1);
        StringBuffer mSeq = new StringBuffer();
        for (int i = 0; i < ms.length; ++i) {
            mSeq.append("SUM(").append(ms[i]).append(") AS ").append(ms[i]).append(",");
        }
        mSeq.deleteCharAt(mSeq.length() - 1);
        List filterList = cc.getFilterList();
        StringBuffer whereClause = new StringBuffer();
        if (filterList != null) {
            Iterator it = filterList.iterator();
            while (it.hasNext()) {
                whereClause.append(it.next()).append(" AND ");
            }
            int whereLength = whereClause.length();
            if (whereLength > 0) {
                whereClause.delete(whereLength - 4, whereLength - 1);
                whereClause.insert(0, " WHERE ");
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ").append(xSeq).append(",").append(ySeq).append(",").append(mSeq).append(" FROM ( ").append(cc.getDataSource().getQuerySQL()).append(" ) AS DAGNGVWENC").append(whereClause).append(" GROUP BY ").append(xSeq).append(",").append(ySeq).append(" ORDER BY ").append(xSeq).append(",").append(ySeq);
        return (CategoryDataset)SQLUtil.handleResultSet(cc.getRequest(), cc.getDataSource().getDatacenter(), sql.toString(), new SQLUtil.ResultSetHandler(){

            @Override
            public Object handle(ResultSet rs) throws SQLException {
                DefaultCategoryDataset set = new DefaultCategoryDataset();
                while (rs.next()) {
                    int i;
                    String category = "";
                    for (int i2 = 0; i2 < xs.length; ++i2) {
                        category = category + rs.getString(xs[i2]);
                        if (i2 >= xs.length - 1) continue;
                        category = category + ",";
                    }
                    String series = "";
                    for (i = 0; i < ys.length; ++i) {
                        series = series + rs.getString(ys[i]) + ",";
                    }
                    for (i = 0; i < ms.length; ++i) {
                        set.setValue((Number)rs.getBigDecimal(ms[i]), (Comparable)((Object)(series + ms[i])), (Comparable)((Object)category));
                    }
                }
                return set;
            }
        }, "\u6784\u9020\u56fe\u8868\u6570\u636e\u96c6\u5931\u8d25");
    }
}

