/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.dashboard.dial;

import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.BIWebComponent;
import com.kingdee.bos.ctrl.analysis.web.BIWebComponentSupport;
import com.kingdee.bos.ctrl.analysis.web.WebFrameworkException;
import com.kingdee.bos.ctrl.analysis.web.ajax.Constants;
import com.kingdee.bos.ctrl.analysis.web.ajax.OlapModelManager;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSON;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONMap;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONString;
import com.kingdee.bos.ctrl.analysis.web.chart.ChartComponent;
import com.kingdee.bos.ctrl.analysis.web.chart.RadarChartConfig;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DashBoardException;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.Dial;
import com.kingdee.bos.ctrl.analysis.web.piece.DynamicPiece;
import com.kingdee.bos.ctrl.analysis.web.piece.Piece;
import com.kingdee.bos.ctrl.analysis.web.piece.SnapshotPiece;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReport;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReportComponent;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReportFactory;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.impl.BIReportChartComponent;
import com.kingdee.bos.ctrl.analysis.web.worksheet.WorksheetComponent;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class PieceDial
implements Dial {
    private static Logger logger = CommonLogger.getLogger(PieceDial.class);
    private String id = "";
    private String path = "";
    private String title = "";
    private boolean isShowTitle;
    private boolean canDrill;
    private String type = "";
    Piece piece = null;
    BIWebComponentSupport component = null;
    String content = "";
    OlapModelManager olapModelManager;
    private String name;

    public PieceDial(String id, String path, String title, boolean isShowTitle, boolean canDrill, OlapModelManager olapModelManager, String name) {
        this.id = id;
        this.path = path;
        this.title = title;
        this.isShowTitle = isShowTitle;
        this.canDrill = canDrill;
        this.olapModelManager = olapModelManager;
        this.name = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.content;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean isShowTitle() {
        return this.isShowTitle;
    }

    public boolean isCanDrill() {
        return this.canDrill;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void createPiece(Repository rep) throws BIReportException {
        if (this.path.equals("")) {
            throw new BIReportException("\u672a\u7ed1\u5b9a\u7247\u6bb5\u6765\u6e90!");
        }
        if (rep.isDynamicPiece(this.path)) {
            String strXML = "";
            try {
                strXML = new String(rep.getNodeBinaryData("RPT", this.path), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.piece = DynamicPiece.fromXML(rep, strXML);
        } else if (rep.isSnapshotPiece(this.path)) {
            String ws = "RPT";
            String strType = rep.getNodePropertyByPath(ws, this.path, "componentType");
            String name = rep.getNodeNameByPath(ws, this.path);
            String caption = rep.getNodePropertyByPath(ws, this.path, "caption");
            if ("worksheet".equals(strType)) {
                String strXML = "";
                try {
                    strXML = new String(rep.getNodeBinaryData(ws, this.path), "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                this.piece = SnapshotPiece.fromXML(strXML, name, caption, this.path);
            } else if ("chart".equals(strType)) {
                byte[] bytes = rep.getNodeBinaryData(ws, this.path);
                String tempDirName = System.getProperty("java.io.tmpdir");
                if (tempDirName == null) {
                    throw new RuntimeException("Temporary directory system property (java.io.tmpdir) is null.");
                }
                File tempDir = new File(tempDirName);
                if (!tempDir.exists()) {
                    tempDir.mkdirs();
                }
                String prefix = "dashborad-piece-";
                File tempFile = null;
                try {
                    tempFile = File.createTempFile(prefix, ".png", new File(System.getProperty("java.io.tmpdir")));
                }
                catch (IOException e) {
                    throw new BIReportException("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5931\u8d25\uff01\u51fa\u9519\u539f\u56e0\uff1a" + e.getMessage());
                }
                FileOutputStream fo = null;
                try {
                    fo = new FileOutputStream(tempFile);
                    fo.write(bytes);
                    fo.close();
                }
                catch (FileNotFoundException e) {
                    throw new BIReportException("\u6587\u4ef6\u672a\u627e\u5230\uff01\u51fa\u9519\u539f\u56e0\uff1a" + e.getMessage());
                }
                catch (IOException e) {
                    throw new BIReportException("\u6587\u4ef6\u8bfb\u5199\u65f6\u51fa\u9519\uff01\u51fa\u9519\u539f\u56e0\uff1a" + e.getMessage());
                }
                finally {
                    if (null != fo) {
                        try {
                            fo.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                this.piece = new SnapshotPiece(name, caption, "", tempFile.getName(), "chart", this.path);
            }
        } else {
            throw new BIReportException("\u672a\u77e5\u7684\u7247\u6bb5\u7c7b\u578b!");
        }
    }

    protected synchronized String transXSL(HttpServletRequest request, String xslUri, BIWebComponent comp) throws BIReportException {
        Document document;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("context", request.getContextPath());
        parameters.put("uiid", this.id);
        Transformer transformer = XmlUtil.getTransformer(request.getSession(), xslUri, false);
        for (String name : parameters.keySet()) {
            Object value = parameters.get(name);
            transformer.setParameter(name, value);
        }
        try {
            document = comp.render(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BIReportException(e);
        }
        if (logger.isDebugEnabled()) {
            StringWriter sw = new StringWriter();
            XmlUtil.print(document, sw);
            logger.debug((Object)("Document is:\n" + sw.toString()));
        }
        DOMSource source = new DOMSource(document);
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw, 4096);
        StreamResult result = new StreamResult(bw);
        try {
            long start = System.currentTimeMillis();
            transformer.transform(source, result);
            sw.flush();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("xsl transform cost " + (System.currentTimeMillis() - start) + "ms.result has " + sw.getBuffer().length() + "chars."));
            }
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new BIReportException(e);
        }
        return sw.toString().replaceAll("\\n|\\r", "");
    }

    public JSON init(HttpServletRequest request) throws BIReportException {
        try (Repository rep = BISystem.getRepository(request);){
            this.createPiece(rep);
        }
        StringBuffer sb = new StringBuffer();
        if (this.piece instanceof DynamicPiece) {
            DynamicPiece dPiece = (DynamicPiece)this.piece;
            this.olapModelManager.createOlapModel(this.getId(), dPiece, request);
            OlapModel olapModel = this.olapModelManager.getOlapModel(this.getId());
            if (dPiece.getComponentType().equalsIgnoreCase("worksheet")) {
                this.type = "piece_worksheet_dynamic";
                BIReport report = BIReportFactory.buildBIReport(dPiece.getSubjectName(), dPiece.getReportPath(), dPiece.getDatacenter());
                this.component = new WorksheetComponent(this.getId().toString(), report.getCaption(), olapModel, null, null);
                this.component.setPagePerRows(dPiece.getPerPageRows());
                this.component.setCurrentPage(dPiece.getCurrentPage());
                try {
                    this.component.initialize();
                }
                catch (WebFrameworkException e) {
                    throw new BIReportException("\u7ec4\u4ef6\u521d\u59cb\u5316\u5931\u8d25!", e);
                }
                sb.append(this.transXSL(request, Constants.PATH_XSL_PIECE_WORKSHEET, this.component));
            } else if (dPiece.getComponentType().equalsIgnoreCase("chart")) {
                String chartWidth;
                this.type = "piece_chart_dynamic";
                BIReport report = BIReportFactory.buildBIReport(dPiece.getSubjectName(), dPiece.getReportPath(), dPiece.getDatacenter());
                this.component = new ChartComponent(this.getId().toString(), report.getCaption(), request.getSession());
                String schemeName = dPiece.getSchemeName();
                if (schemeName != null && !schemeName.equals("")) {
                    List lstComponent = report.getComponents(schemeName);
                    for (BIReportComponent com : lstComponent) {
                        if (!com.getType().equalsIgnoreCase("chart")) continue;
                        ((BIReportChartComponent)com).setChartPropertyValues((ChartComponent)this.component);
                        break;
                    }
                }
                this.component.setPagePerRows(dPiece.getPerPageRows());
                this.component.setCurrentPage(dPiece.getCurrentPage());
                String chartHeight = request.getParameter("height");
                if (chartHeight != null) {
                    try {
                        int height = Integer.parseInt(chartHeight);
                        if (this.isShowTitle) {
                            height -= 20;
                        }
                        if (height <= 0) {
                            throw new BIReportException("\u4eea\u8868\u677f\u5355\u5143\u683c\u9ad8\u5ea6\u8bbe\u8ba1\u8fc7\u5c0f\uff0c\u65e0\u6cd5\u751f\u6210\u7247\u6bb5\u3002\u8bf7\u5c06\u8be5\u7247\u6bb5\u6240\u5728\u7684\u5355\u5143\u683c\u8bbe\u7f6e\u9ad8\u4e00\u4e9b\u3002");
                        }
                        ((ChartComponent)this.component).getChartConfig().putIntValue("chartHeight", height);
                    }
                    catch (NumberFormatException height) {}
                } else {
                    chartHeight = dPiece.getProperty("chartHeight");
                    if (chartHeight != null) {
                        ((ChartComponent)this.component).getChartConfig().putIntValue("chartHeight", Integer.parseInt(chartHeight));
                    }
                }
                if ((chartWidth = request.getParameter("width")) != null) {
                    try {
                        int width = Integer.parseInt(chartWidth);
                        ((ChartComponent)this.component).getChartConfig().putIntValue("chartWidth", width);
                    }
                    catch (NumberFormatException width) {}
                } else {
                    chartWidth = dPiece.getProperty("chartWidth");
                    if (chartWidth != null) {
                        ((ChartComponent)this.component).getChartConfig().putIntValue("chartWidth", Integer.parseInt(chartWidth));
                    }
                }
                if (dPiece.getChartType() != null) {
                    ((ChartComponent)this.component).getChartConfig().putStringValue("chartType", dPiece.getChartType());
                }
                ((ChartComponent)this.component).getChartModel().setOlapModel(olapModel);
                RadarChartConfig rcc = ((DynamicPiece)this.piece).getRadarConfig();
                if (rcc != null) {
                    rcc.setEnable(true);
                    ((ChartComponent)this.component).setRadarConfig(rcc);
                }
                String topNValue = dPiece.getProperty("topNValue");
                String topNOther = dPiece.getProperty("topNOther");
                if (topNValue != null && !"".equals(topNValue)) {
                    ((ChartComponent)this.component).getChartModel().getDataModel().getTopN().setValue(Integer.parseInt(topNValue));
                }
                if (topNOther != null && !"".equals(topNOther)) {
                    ((ChartComponent)this.component).getChartModel().getDataModel().getTopN().setOther("true".equals(topNOther));
                }
                ((ChartComponent)this.component).getChartConfig().putBooleanValue("drillThrough", false);
                sb.append(this.transXSL(request, Constants.PATH_XSL_PIECE_CHART, this.component));
            }
            this.olapModelManager.release(this.getId());
        } else if (this.piece instanceof SnapshotPiece) {
            SnapshotPiece sPiece = (SnapshotPiece)this.piece;
            if (sPiece.getComponentType().equalsIgnoreCase("worksheet")) {
                this.type = "piece_worksheet_snapshot";
                sb.append(sPiece.getPieceContent());
            } else if (sPiece.getComponentType().equalsIgnoreCase("chart")) {
                this.type = "piece_chart_snapshot";
                sb.append(request.getContextPath() + "/" + Constants.SERVLET_URL + "?" + "servletType" + "=" + "export" + "&" + "exportType" + "=png&" + "filename" + "=" + sPiece.getPieceContent());
            }
        }
        this.content = sb.toString();
        return this.toJSON(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSON penetrate(HttpServletRequest req) throws BIReportException {
        JSONString ret = null;
        try (Repository rep = BISystem.getRepository(req);){
            ret = new JSONString(rep.getReportURLFromPiece(this.path, req.getContextPath()));
        }
        return ret;
    }

    @Override
    public JSON toJSON(HttpServletRequest req) throws DashBoardException {
        HashMap<String, Object> map = new HashMap<String, Object>(3, 1.0f);
        map.put("type", this.getType());
        map.put("id", this.getId());
        map.put("title", this.getTitle());
        map.put("isShowTitle", this.isShowTitle());
        map.put("canDrill", this.canDrill);
        map.put("name", this.name);
        map.put("content", this.content);
        return new JSONMap(map);
    }

    @Override
    public String getScript() {
        return "";
    }

    @Override
    public void setScript(String script) {
    }
}

