/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.dashboard.dial;

import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSON;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONMap;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DashBoardException;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DataSource;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.Dial;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class TableDial
implements Dial {
    private final String id;
    private final DataSource ds;
    private final List outputList;
    private final String title;
    private final boolean isShowTitle;
    private final String name;
    private final String sustainPageSize;
    private final String pageSize;
    private String dataCenter;

    public TableDial(String id, String title, boolean isShowTitle, DataSource ds, List outputList, String name, String sustainPageSize, String pageSize) {
        this.id = id;
        this.title = title;
        this.isShowTitle = isShowTitle;
        this.ds = ds;
        this.outputList = outputList;
        this.name = name;
        this.sustainPageSize = sustainPageSize;
        this.pageSize = pageSize;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getType() {
        return "table";
    }

    @Override
    public boolean isShowTitle() {
        return this.isShowTitle;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public JSON init(HttpServletRequest req) throws BIReportException {
        return this.toJSON(req);
    }

    public JSON refresh(HttpServletRequest req) throws BIReportException {
        return this.toJSON(req);
    }

    @Override
    public JSON toJSON(HttpServletRequest req) throws BIReportException {
        List<String> filterList;
        String[] filter = req.getParameterValues("filter");
        List<String> list = filterList = filter != null ? Arrays.asList(filter) : null;
        if (filter != null && filter.length > 0 && filter[0].indexOf("=") != -1 && filter[0].indexOf(",") != -1) {
            throw new DashBoardException("[" + this.name + "]\u7ec4\u4ef6\u4e0d\u652f\u6301\u591a\u9009,\u5f53\u524d\u8fc7\u6ee4\u6761\u4ef6\u4e3a\uff1a" + filter[0].toString() + ",\u8bf7\u91cd\u65b0\u8bbe\u5b9a\u8be5\u7ec4\u4ef6\u7684\u4e92\u52a8\u811a\u672c");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.getId());
        map.put("type", this.getType());
        map.put("isShowTitle", new Boolean(this.isShowTitle));
        map.put("title", this.title);
        map.put("name", this.name);
        map.put("datacenter", this.ds.getDatacenter());
        if (this.ds == null) {
            throw new DashBoardException("\u627e\u4e0d\u5230\u5217\u8868\u7ed1\u5b9a\u7684\u6570\u636e\u6e90\u3002\u53ef\u80fd\u5217\u8868\u5c1a\u672a\u7ed1\u5b9a\u6570\u636e\u6e90\u6216\u8005\u8be5\u6570\u636e\u6e90\u5df2\u7ecf\u88ab\u5220\u9664");
        }
        map.put("isOverflow", new Boolean(this.ds.isOverflow(req, filterList)));
        if (req != null) {
            map.put("data", this.ds.toJSONString(req, this.outputList, true, true, filterList));
        }
        map.put("sql", this.ds.getQuerySql(req, this.outputList, true, true, filterList));
        map.put("outputList", this.getOutputList(this.outputList));
        map.put("pageSize", this.pageSize);
        map.put("sustainPageSize", this.sustainPageSize);
        return new JSONMap(map);
    }

    private String getOutputList(List outputList) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < outputList.size(); ++i) {
            sb.append(outputList.get(i)).append(",");
        }
        if (sb.length() > 0) {
            sb = sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public String getScript() {
        return "";
    }

    @Override
    public void setScript(String script) {
    }
}

