/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.worksheet;

import com.kingdee.bos.ctrl.analysis.olap.Cell;
import com.kingdee.bos.ctrl.analysis.olap.Property;
import com.kingdee.bos.ctrl.analysis.web.worksheet.CellBuilder;
import com.kingdee.bos.ctrl.analysis.web.worksheet.PartBuilderSupport;
import java.awt.Color;
import org.w3c.dom.Element;

public class CellBuilderImpl
extends PartBuilderSupport
implements CellBuilder {
    private static final String STYLE = "style";
    private static final String NBSP = "\u00a0";

    @Override
    public Element build(Cell cell, boolean even, int row, int column) {
        Property style;
        String c;
        Color color;
        Element cellElem = this.worksheet.elem("cell");
        String s = cell.isNull() ? NBSP : cell.getFormattedValue();
        if ((s = s == null ? "" : s.trim()).length() == 0) {
            s = NBSP;
        }
        cellElem.setAttribute("value", s);
        cellElem.setAttribute("row", "" + row);
        cellElem.setAttribute("column", "" + column);
        if (cell.getForeColor() != null) {
            color = cell.getForeColor();
            c = "#" + new String(Integer.toHexString(color.getRGB())).substring(2);
            cellElem.setAttribute("fore_color", c);
        }
        if (cell.getBgColor() != null) {
            color = cell.getBgColor();
            c = "#" + new String(Integer.toHexString(color.getRGB())).substring(2);
            cellElem.setAttribute("bg_color", c);
        }
        if (cell.getStatus() != null) {
            String status = cell.getStatus();
            if (status == null) {
                return null;
            }
            if ("1".equals(status = status.trim())) {
                status = "good";
            } else if ("-1".equals(status)) {
                status = "bad";
            } else if ("0".equals(status)) {
                status = "equal";
            }
            cellElem.setAttribute("status", status);
        }
        if (cell.getTrend() != null) {
            String trend = cell.getTrend();
            if (trend == null) {
                return null;
            }
            if ("1".equals(trend = trend.trim())) {
                trend = "up";
            } else if ("-1".equals(trend)) {
                trend = "down";
            } else if ("0".equals(trend)) {
                trend = "equal";
            }
            cellElem.setAttribute("trend", trend);
        }
        if ((style = cell.getProperty(STYLE)) != null) {
            String value = style.getValue();
            if (value != null && value.length() > 0) {
                cellElem.setAttribute(STYLE, value);
            } else {
                cellElem.setAttribute(STYLE, even ? "even" : "odd");
            }
        } else {
            cellElem.setAttribute(STYLE, even ? "even" : "odd");
        }
        return cellElem;
    }
}

