/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.worksheet;

import com.kingdee.bos.ctrl.analysis.olap.Dimension;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Level;
import com.kingdee.bos.ctrl.analysis.olap.MDXElement;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.Property;
import com.kingdee.bos.ctrl.analysis.util.Displayable;
import com.kingdee.bos.ctrl.analysis.util.VisitorSupportStrict;
import com.kingdee.bos.ctrl.analysis.web.worksheet.PartBuilderSupport;
import com.kingdee.bos.ctrl.analysis.web.worksheet.SpanBuilder;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.PropertyHeading;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.Span;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.SpanVisitor;
import org.w3c.dom.Element;

public class SpanBuilderImpl
extends PartBuilderSupport
implements SpanBuilder {
    String memberName;
    String headingName;
    RenderSwitch renderSwitch = new RenderSwitch();

    public SpanBuilderImpl(String memberName, String headingName) {
        this.memberName = memberName;
        this.headingName = headingName;
    }

    @Override
    public void stopBuild() {
        super.stopBuild();
        this.renderSwitch.setElem(null);
    }

    @Override
    public Element build(Span span, boolean even) {
        Displayable v = span.getObject();
        v.accept(this.renderSwitch);
        Element elem = this.renderSwitch.getElem();
        return elem;
    }

    class RenderSwitch
    extends VisitorSupportStrict
    implements SpanVisitor {
        private static final String CAPTION = "caption";
        private static final String UNIQUENAME = "uniqueName";
        Element elem;

        RenderSwitch() {
        }

        void renderHeading(Displayable d) {
            this.elem = SpanBuilderImpl.this.worksheet.elem(SpanBuilderImpl.this.headingName);
            Element caption = SpanBuilderImpl.this.worksheet.append(CAPTION, this.elem);
            caption.setAttribute(CAPTION, d.getLabel());
        }

        void renderMember(Displayable d) {
            this.elem = SpanBuilderImpl.this.worksheet.elem(SpanBuilderImpl.this.memberName);
            Element caption = SpanBuilderImpl.this.worksheet.append(CAPTION, this.elem);
            caption.setAttribute(CAPTION, d.getLabel());
            caption.setAttribute(UNIQUENAME, ((Member)d).getUniqueName());
        }

        void renderProperty(Property p) {
            this.elem = SpanBuilderImpl.this.worksheet.elem(SpanBuilderImpl.this.memberName);
            Element caption = SpanBuilderImpl.this.worksheet.append(CAPTION, this.elem);
            caption.setAttribute(CAPTION, p.getValue());
        }

        void renderMdxElement(MDXElement mdxe) {
            this.elem = SpanBuilderImpl.this.worksheet.elem(SpanBuilderImpl.this.headingName);
            Element caption = SpanBuilderImpl.this.worksheet.append(CAPTION, this.elem);
            caption.setAttribute(CAPTION, mdxe.getCaption());
            caption.setAttribute(UNIQUENAME, mdxe.getUniqueName());
            Element uniqueName = SpanBuilderImpl.this.worksheet.append(UNIQUENAME, this.elem);
            uniqueName.setAttribute(UNIQUENAME, mdxe.getUniqueName());
        }

        @Override
        public void visitPropertyHeading(PropertyHeading v) {
            this.renderHeading(v);
        }

        @Override
        public void visitDimension(Dimension v) {
            this.renderMdxElement(v);
        }

        @Override
        public void visitHierarchy(Hierarchy v) {
            this.renderMdxElement(v);
        }

        @Override
        public void visitLevel(Level v) {
            this.renderHeading(v);
        }

        @Override
        public void visitMember(Member v) {
            this.renderMember(v);
        }

        @Override
        public void visitProperty(Property v) {
            this.renderProperty(v);
        }

        public Element getElem() {
            return this.elem;
        }

        public void setElem(Element elem) {
            this.elem = elem;
        }
    }
}

