/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.xmlutil;

import com.kingdee.bos.ctrl.analysis.xmlutil.XMLException;
import com.kingdee.bos.ctrl.analysis.xmlutil.XMLNode;
import com.kingdee.bos.ctrl.analysis.xmlutil.XmlUtilResource;
import java.io.IOException;
import java.io.OutputStream;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public abstract class AbstractXMLNode
implements XMLNode {
    private String name;
    private String alias;
    private String desc;

    public AbstractXMLNode() {
    }

    public AbstractXMLNode(Element xmlNode) throws XMLException {
        this.loadXML(xmlNode);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getAlias() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.name;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String toString() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.name;
    }

    @Override
    public void loadXML(Element xmlNode) throws XMLException {
        this.name = xmlNode.getAttributeValue("name");
        this.alias = xmlNode.getAttributeValue("alias");
        this.desc = xmlNode.getAttributeValue("desc");
    }

    @Override
    public Element saveXML() {
        if (this.getTag() == null) {
            throw new NullPointerException();
        }
        Element xmlNode = new Element(this.getTag());
        this.saveXML(xmlNode);
        return xmlNode;
    }

    protected void saveXML(Element xmlNode) {
        if (this.name != null) {
            xmlNode.setAttribute("name", this.name);
        }
        if (this.alias != null) {
            xmlNode.setAttribute("alias", this.alias);
        }
        if (this.desc != null) {
            xmlNode.setAttribute("desc", this.desc);
        }
    }

    protected void throwChildNotNullException(String element, String child) throws XMLException {
        throw new XMLException("XML element " + element + " named '" + this.getName() + "' must have child element '" + child + "'.");
    }

    protected void throwAttributeNotNullException(String element, String attribute) throws XMLException {
        throw new XMLException("XML element " + element + " named '" + this.getName() + "' must have not empty attribute '" + attribute + "'.");
    }

    protected void throwAttributeIllegalValueException(String element, String attribute, String value) throws XMLException {
        throw new XMLException("XML element " + element + " named '" + this.getName() + "'' attribute '" + attribute + "'' value is illegal:" + value + ".");
    }

    protected void checkNameNotNull() throws XMLException {
        if (this.name == null) {
            this.throwAttributeNotNullException(this.getTag(), "name");
        }
    }

    public void output(OutputStream outStream) throws XMLException {
        this.output(outStream, "UTF-8");
    }

    public void output(OutputStream outStream, String encoding) throws XMLException {
        Format format = Format.getPrettyFormat();
        format.setIndent("\t");
        format.setEncoding(encoding);
        XMLOutputter outter = new XMLOutputter(format);
        try {
            outter.output(this.saveXML(), outStream);
        }
        catch (IOException e) {
            throw new XMLException(XmlUtilResource.getString(XmlUtilResource.class, (String)"SaveFail"));
        }
    }
}

