/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.common;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.Connection;
import com.kingdee.bos.olap.OLAPException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class OlapConnectionManager
implements ServletContextListener {
    private static Logger logger = CommonLogger.getLogger((String)OlapConnectionManager.class.getName());
    private static OlapConnectionManager self = null;
    private Map conMap = new HashMap();
    private Map methodMap = new HashMap();

    public OlapConnectionManager() {
        if (self != null) {
            throw new RuntimeException("OLAP\u8fde\u63a5\u6c60\u5df2\u7ecf\u521b\u5efa\uff01");
        }
        self = this;
        logger.info((Object)"OLAP\u8fde\u63a5\u6c60\u88ab\u521b\u5efa\u3002");
    }

    public static OlapConnectionManager getInstance() {
        if (self == null) {
            new OlapConnectionManager();
        }
        return self;
    }

    public synchronized Method getMethod(Class cl, String method, Class[] argTypes) throws NoSuchMethodException, SecurityException {
        String key = this.buildMethodKey(cl, method, argTypes);
        Method mm = (Method)this.methodMap.get(key);
        if (mm == null) {
            mm = cl.getMethod(method, argTypes);
            this.methodMap.put(key, mm);
        }
        return mm;
    }

    public Connection get(Context ctx, int caller) {
        return (Connection)this.conMap.get(this.buildConKey(ctx, caller));
    }

    public void put(Context ctx, int caller, Connection con) {
        this.conMap.put(this.buildConKey(ctx, caller), con);
    }

    public void remove(Context ctx, int caller, boolean doClose) throws OLAPException {
        Connection con = (Connection)this.conMap.remove(this.buildConKey(ctx, caller));
        if (con != null) {
            con.close();
        }
    }

    private String buildConKey(Context ctx, int caller) {
        return ctx.hashCode() + "_" + caller;
    }

    private String buildMethodKey(Class cl, String method, Class[] argTypes) {
        StringBuffer sb = new StringBuffer().append(cl.getName()).append('#').append(method);
        int n = argTypes.length;
        for (int i = 0; i < n; ++i) {
            sb.append(',').append(argTypes[i].getName());
        }
        return sb.toString();
    }

    public void contextInitialized(ServletContextEvent arg0) {
        logger.info((Object)"OLAP\u8fde\u63a5\u6c60\u521d\u59cb\u5316...");
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        logger.info((Object)"\u9500\u6bc1OLAP\u8fde\u63a5\u6c60...");
        Iterator iter = this.conMap.values().iterator();
        while (iter.hasNext()) {
            try {
                ((Connection)iter.next()).close();
            }
            catch (Exception exception) {}
        }
        this.conMap.clear();
        this.methodMap.clear();
    }
}

