/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.services;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.bibench.platform.services.IDataSource;
import com.kingdee.bos.ctrl.bibench.platform.services.ServiceContext;
import com.kingdee.bos.ctrl.bibench.platform.services.ServiceWorkThreadLocal;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class AbstractService {
    protected Logger log = CommonLogger.getLogger((String)this.getClass().getName());

    public Context getBosContext() {
        return ServiceWorkThreadLocal.getServiceWorkContext().getBosContext();
    }

    public ServiceContext getServiceContext() {
        return ServiceWorkThreadLocal.getServiceWorkContext().getServiceContext();
    }

    public IDataSource getDataSource() {
        return ServiceWorkThreadLocal.getServiceWorkContext().getDataSource();
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(1);
    }

    public Connection getConnection(int transactionLevel) throws SQLException {
        IDataSource conn = this.getDataSource();
        if (conn != null) {
            Connection con = conn.requestConnection();
            return con;
        }
        throw new SQLException("Current service-work-context's " + IDataSource.class + " is null.");
    }

    public void close(Connection con) {
        this.close(con, null);
    }

    public void close(Connection con, Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (con != null) {
            try {
                this.getDataSource().releaseConnection(con);
            }
            catch (Exception e) {
                this.log.error((Object)"", (Throwable)e);
            }
        }
    }
}

