/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.services.impl;

import com.kingdee.bos.ctrl.bibench.platform.UnsupportedNodeTypeException;
import com.kingdee.bos.ctrl.bibench.platform.XContentFormatException;
import com.kingdee.bos.ctrl.bibench.platform.common.OlapConnectionManager;
import com.kingdee.bos.ctrl.bibench.platform.common.OlapRequestParams;
import com.kingdee.bos.ctrl.bibench.platform.common.OlapResponseParams;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.RDBaseNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.RDBaseNodeFactory;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.RDBaseNodeHelper;
import com.kingdee.bos.ctrl.bibench.platform.resource.BirdResource;
import com.kingdee.bos.ctrl.bibench.platform.services.AbstractService;
import com.kingdee.bos.ctrl.bibench.platform.services.BirdException;
import com.kingdee.bos.ctrl.bibench.platform.services.IDataSource;
import com.kingdee.bos.ctrl.bibench.platform.services.IPlatformFacade;
import com.kingdee.bos.ctrl.bibench.platform.services.etl.ETLContext;
import com.kingdee.bos.ctrl.bibench.platform.services.etl.ETLObjectResourceListener;
import com.kingdee.bos.ctrl.bibench.platform.services.etl.ETLResourceManager;
import com.kingdee.bos.ctrl.bibench.platform.services.etl.ETLSession;
import com.kingdee.bos.ctrl.bibench.platform.services.impl.BIPlatformSQLException;
import com.kingdee.bos.ctrl.etl.actions.EtlActionInfoEnum;
import com.kingdee.bos.ctrl.etl.actions.IActionInfo;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.script.miniscript.MiniScriptEngine;
import com.kingdee.bos.ctrl.script.miniscript.MiniScriptParseException;
import com.kingdee.bos.ctrl.script.miniscript.ScriptContext;
import com.kingdee.bos.ctrl.script.miniscript.ScriptResult;
import com.kingdee.bos.ctrl.script.miniscript.exec.ICreateObjectListener;
import com.kingdee.bos.ctrl.script.miniscript.exec.SystemObject;
import com.kingdee.bos.olap.Connection;
import com.kingdee.bos.olap.Driver;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.dbsource.SqlWithParamTableDef;
import com.kingdee.bos.olap.def.SchemaDef;
import com.kingdee.bos.olap.util.SqlWithParam;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.util.Uuid;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlatformFacadeImpl
extends AbstractService
implements IPlatformFacade {
    @Override
    public List getCatalogNodeList(String orgId) throws SQLException, BirdException {
        List<RDBaseNode> list;
        IDataSource ds = this.getDataSource();
        java.sql.Connection con = null;
        Statement stmt = null;
        try {
            con = ds.requestConnection();
            this.ensureDefaultCatalog(con, orgId);
            stmt = con.createStatement();
            String sql = "select FType,FContent,FParentID,FID,FName,FOrgID,FOrderKey from t_bi_rdcatalognode order by FType,FOrderKey asc";
            ResultSet rs = stmt.executeQuery(ds.getSql(sql));
            List<RDBaseNode> list2 = new ArrayList<RDBaseNode>();
            while (rs.next()) {
                RDBaseNode item = this.parseRDCatalogItem(rs);
                list2.add(item);
            }
            rs.close();
            list2 = RDBaseNodeHelper.buildTreeNode(list2);
            Collections.sort(list2);
            list = list2;
        }
        catch (SqlTranslateException ex) {
            try {
                throw new BIPlatformSQLException(BirdResource.getRes("KSQL_TRANS_ERROR", this.getBosContext()), ex);
            }
            catch (Throwable throwable) {
                this.close(con, stmt);
                throw throwable;
            }
        }
        this.close(con, stmt);
        return list;
    }

    private void ensureDefaultCatalog(java.sql.Connection con, String orgId) throws SQLException, BirdException {
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery("select count(1) cc from t_bi_rdcatalognode");
            rs.next();
            int c = rs.getInt(1);
            if (c == 0) {
                RDBaseNode dsRoot = RDBaseNodeFactory.createCatalogNode(1, null);
                dsRoot.setName("\u516c\u7528\u6570\u636e\u6e90");
                dsRoot.setOrderKey("0");
                dsRoot.setOrgID(orgId);
                dsRoot.setDesignStatus(1);
                this.saveCatalogNode(dsRoot);
                RDBaseNode theme = RDBaseNodeFactory.createCatalogNode(2, null);
                theme.setName("\u7f3a\u7701\u4e3b\u9898");
                theme.setOrderKey("1");
                theme.setOrgID(orgId);
                theme.setDesignStatus(1);
                this.saveCatalogNode(theme);
            }
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
        finally {
            this.close(null, stmt);
        }
    }

    private RDBaseNode parseRDCatalogItem(ResultSet rs) throws SQLException, UnsupportedNodeTypeException, XContentFormatException {
        RDBaseNode item = RDBaseNodeFactory.createCatalogNode(rs.getInt("FType"), rs.getString("FContent"));
        item.setParentID(rs.getString("FParentID"));
        item.setId(rs.getString("FID"));
        item.setName(rs.getString("FName"));
        item.setOrgID(rs.getString("FOrgID"));
        item.setOrderKey(rs.getString("FOrderKey"));
        item.setDesignStatus(0, false);
        return item;
    }

    private RDBaseNode parseRDCatalogItem(RDRowSet rs) throws SQLException, UnsupportedNodeTypeException, XContentFormatException {
        RDBaseNode item = RDBaseNodeFactory.createCatalogNode(rs.getInt("FType"), rs.getString("FContent"));
        item.setParentID(rs.getString("FParentID"));
        item.setId(rs.getString("FID"));
        item.setName(rs.getString("FName"));
        item.setOrgID(rs.getString("FOrgID"));
        item.setOrderKey(rs.getString("FOrderKey"));
        item.setDesignStatus(0, false);
        return item;
    }

    @Override
    public String saveCatalogNode(RDBaseNode item) throws SQLException, BirdException {
        IDataSource ds = this.getDataSource();
        java.sql.Connection con = null;
        try {
            String sql = null;
            con = ds.requestConnection();
            Timestamp ts = new Timestamp(new Date().getTime());
            switch (item.getDesignStatus()) {
                case 1: {
                    String id = Uuid.create().toString();
                    sql = "insert into t_bi_rdcatalognode(FID,FParentID,FName,FOrgID,FType,FContent,FOrderKey,FLastUpdated)values(?,?,?,?,?,?,?,?)";
                    PreparedStatement ps = con.prepareStatement(ds.getSql(sql));
                    ps.setString(1, id);
                    ps.setString(2, item.getParentID());
                    ps.setString(3, item.getName());
                    ps.setString(4, item.getOrgID());
                    ps.setInt(5, item.getType());
                    ps.setString(6, item.getContent());
                    ps.setString(7, item.getOrderKey());
                    ps.setTimestamp(8, ts);
                    ps.executeUpdate();
                    ps.close();
                    String string = id;
                    return string;
                }
                case 3: {
                    List ids = (List)item.getProperty("ids");
                    StringBuffer s = new StringBuffer("delete from t_bi_rdcatalognode where FID in(");
                    int n = ids.size();
                    for (int i = 0; i < n; ++i) {
                        s.append("'").append(ids.get(i)).append("'");
                        if (i == n - 1) continue;
                        s.append(",");
                    }
                    s.append(")");
                    Statement stmt = con.createStatement();
                    stmt.executeUpdate(s.toString());
                    stmt.close();
                    String string = item.getId();
                    return string;
                }
                case 2: {
                    sql = "update t_bi_rdcatalognode set FName=?,FType=?,FContent=?,FOrderKey=?,FLastUpdated=? where FID=?";
                    PreparedStatement ps = con.prepareStatement(ds.getSql(sql));
                    ps.setString(1, item.getName());
                    ps.setInt(2, item.getType());
                    ps.setString(3, item.getContent());
                    ps.setString(4, item.getOrderKey());
                    ps.setTimestamp(5, ts);
                    ps.setString(6, item.getId());
                    ps.executeUpdate();
                    ps.close();
                    String string = item.getId();
                    return string;
                }
            }
            try {
                throw new BirdException("RDCatalogItem design status(" + item.getDesignStatus() + ") can not be recognized!");
            }
            catch (SqlTranslateException ex) {
                throw new BIPlatformSQLException(BirdResource.getRes("KSQL_TRANS_ERROR", this.getBosContext()), ex);
            }
        }
        finally {
            this.close(con);
        }
    }

    @Override
    public RDBaseNode getCatalogNodeById(String id) throws SQLException, BirdException {
        String sql = "select * from t_bi_rdcatalognode where FID='" + id + "'";
        RDRowSet rs = this.executeQuery(sql);
        if (rs.next()) {
            return this.parseRDCatalogItem(rs);
        }
        throw new BirdException("\u6b64\u9879\u8bb0\u5f55\u5df2\u4e0d\u5b58\u5728\uff01");
    }

    @Override
    public RDRowSet executeQuery(String sql) throws SQLException, BirdException {
        return this.executeQuery(sql, 0, -1);
    }

    @Override
    public RDRowSet executeQuery(String sql, int from, int len) throws SQLException, BirdException {
        RDRowSet rDRowSet;
        java.sql.Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            RDRowSet dbrs;
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(this.getDataSource().getSql(sql));
            rDRowSet = dbrs = RDRowSet.parse(rs, from, len);
        }
        catch (SqlTranslateException ex) {
            try {
                throw new BIPlatformSQLException(BirdResource.getRes("KSQL_TRANS_ERROR", this.getBosContext()), ex);
            }
            catch (Throwable throwable) {
                CloseUtil.close((java.sql.Connection)con, (Statement)stmt, rs);
                throw throwable;
            }
        }
        CloseUtil.close((java.sql.Connection)con, (Statement)stmt, (ResultSet)rs);
        return rDRowSet;
    }

    @Override
    public Object invokeConnectionAction(String method, Class[] argTypes, Object[] argValues, int caller) throws OLAPException {
        OlapConnectionManager cm = OlapConnectionManager.getInstance();
        if (method.equals("close")) {
            cm.remove(this.getBosContext(), caller, true);
            return null;
        }
        Connection con = cm.get(this.getBosContext(), caller);
        try {
            Method mm = cm.getMethod(java.sql.Connection.class, method, argTypes);
            return mm.invoke((Object)con, argValues);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            throw new OLAPException(e);
        }
    }

    @Override
    public OlapResponseParams etlModel(OlapRequestParams params, boolean remoteConnection, int caller) throws SQLException, OLAPException, BirdException {
        Map dsMap = params.getDataSourceMap();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (String name : dsMap.keySet()) {
            String sql = (String)dsMap.get(name);
            SqlWithParam sqlWithParam = new SqlWithParam();
            sqlWithParam.setSql(sql);
            paramMap.put(name, new SqlWithParamTableDef(name, sqlWithParam));
        }
        paramMap.put("JdbcConnection", this.getConnection());
        Connection con = Driver.openConnection((SchemaDef)params.getSchemaDef(), paramMap, (boolean)false);
        OlapResponseParams pp = new OlapResponseParams();
        pp.setConnection(con);
        if (remoteConnection) {
            OlapConnectionManager cm = OlapConnectionManager.getInstance();
            cm.remove(this.getBosContext(), caller, true);
            cm.put(this.getBosContext(), caller, con);
        }
        return pp;
    }

    @Override
    public Object executeETLScript(String script, String resultKey, String caller) throws SQLException, BirdException, MiniScriptParseException {
        ETLSession session = new ETLSession();
        ETLContext etlCtx = new ETLContext(this.getConnection());
        ETLObjectResourceListener rl = new ETLObjectResourceListener(session, etlCtx, caller);
        ETLResourceManager.getInstance().refrence(rl);
        MiniScriptEngine se = new MiniScriptEngine();
        se.setCreateObjectListener((ICreateObjectListener)rl);
        se.parseScript(script);
        ScriptContext scriptCtx = se.getScriptContext();
        SystemObject sys = scriptCtx.getSystemObject();
        scriptCtx.setSystemVar("etl_session", (Object)session);
        scriptCtx.setSystemVar("etl_context", (Object)etlCtx);
        IActionInfo[] ias = EtlActionInfoEnum.getEtlActInfoList();
        for (int i = 0; i < ias.length; ++i) {
            sys.importPackage(ias[i].getActClass().getName());
        }
        se.executeSync(new HashMap());
        ScriptResult re = se.getScriptContext().getScriptResult();
        return re.getVar(resultKey);
    }

    @Override
    public void releaseETLResource(String caller) {
        ETLResourceManager.getInstance().release(caller);
    }
}

