/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.services.standalone.server;

import com.kingdee.bos.ctrl.bibench.platform.services.IDataSource;
import com.kingdee.bos.ctrl.bibench.platform.services.IServiceManager;
import com.kingdee.bos.ctrl.bibench.platform.services.impl.IMiniServer;
import com.kingdee.bos.ctrl.bibench.platform.services.standalone.server.IWrokerCallBack;
import com.kingdee.bos.ctrl.bibench.platform.services.standalone.server.MiniServiceWorker;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.net.Socket;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class MiniServiceController {
    private Object lock;
    private boolean hasInit = false;
    private LinkedList pool;
    private PollThread poll;
    private MiniServiceWorker[] workers;
    private LinkedList freeWorkers;
    private LinkedList workingWorkers;
    private int max;
    private Logger log = CommonLogger.getLogger((String)MiniServiceController.class.getName());
    private IServiceManager serviceManager;
    private IMiniServer server;
    private IDataSource con;
    private IWrokerCallBack callback = new IWrokerCallBack(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callback(MiniServiceWorker worker) {
            Object object = MiniServiceController.this.lock;
            synchronized (object) {
                MiniServiceController.this.workingWorkers.remove(worker);
                MiniServiceController.this.freeWorkers.addLast(worker);
                MiniServiceController.this.lock.notifyAll();
            }
            MiniServiceController.this.log.info((Object)("Worker[" + worker + "] finish work and callback to notify all."));
        }
    };

    public MiniServiceController(IServiceManager serviceManager, IMiniServer server, IDataSource con) {
        this.serviceManager = serviceManager;
        this.server = server;
        this.con = con;
    }

    public void init(int maxCount) {
        if (!this.hasInit) {
            this.hasInit = true;
            this.max = maxCount;
            this.log.info((Object)("Init service-thread pool(size=" + this.max + ")..."));
            this.lock = new Object();
            this.pool = new LinkedList();
            this.freeWorkers = new LinkedList();
            this.workingWorkers = new LinkedList();
            this.workers = new MiniServiceWorker[this.max];
            for (int i = 0; i < this.max; ++i) {
                this.workers[i] = new MiniServiceWorker(this.serviceManager, this.server, this.callback);
                this.freeWorkers.addLast(this.workers[i]);
            }
            this.poll = new PollThread();
            this.poll.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchWork(Socket s) {
        Object object = this.lock;
        synchronized (object) {
            this.pool.addFirst(s);
            this.lock.notifyAll();
        }
    }

    public int getMaxWorkerCount() {
        return this.max;
    }

    public int getWaitingWorkCount() {
        return this.pool.size();
    }

    public int getWorkingWorkCount() {
        return this.workingWorkers.size();
    }

    public int getFreeWorkerCount() {
        return this.freeWorkers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.poll.terminal();
        this.poll.stop();
        Object object = this.lock;
        synchronized (object) {
            while (this.workingWorkers.size() > 0) {
                ((MiniServiceWorker)this.workingWorkers.removeFirst()).getThread().stop();
            }
        }
        this.hasInit = false;
    }

    public void printStatus() {
        String msg = " Max-worker=" + this.getMaxWorkerCount() + " Working-Work=" + this.getWorkingWorkCount() + " Waiting-Work=" + this.getWaitingWorkCount() + " Free-Worker=" + this.getFreeWorkerCount();
        System.out.println("[Service status] " + msg);
    }

    class PollThread
    extends Thread {
        private boolean terminal = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.terminal) {
                Object object = MiniServiceController.this.lock;
                synchronized (object) {
                    while (MiniServiceController.this.pool.size() > 0 && MiniServiceController.this.freeWorkers.size() > 0) {
                        MiniServiceWorker worker = (MiniServiceWorker)MiniServiceController.this.freeWorkers.removeFirst();
                        MiniServiceController.this.workingWorkers.addLast(worker);
                        worker.switchChannel((Socket)MiniServiceController.this.pool.removeFirst(), MiniServiceController.this.con, new Thread(worker));
                        worker.getThread().start();
                    }
                    try {
                        MiniServiceController.this.log.info((Object)"Service poll-thread waiting for the next round.");
                        MiniServiceController.this.lock.wait();
                        MiniServiceController.this.log.info((Object)"Service poll-thread be notified to resume...");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public void terminal() {
            this.terminal = true;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

