/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.objtree;

import com.kingdee.bos.ctrl.bibench.platform.ui.content.objtree.ObjectNode;
import java.lang.reflect.Method;

public class MethodObjectNode
extends ObjectNode {
    private Method m;
    private Object v;
    private String prefix;

    public MethodObjectNode(String prefix, Method m, Object obj) {
        this.prefix = prefix;
        this.m = m;
        this.v = obj;
    }

    @Override
    public String getTemplateString() {
        return this.prefix + "." + this.getBaseInfo();
    }

    @Override
    public String viewDefaultValue() {
        if (this.m.getParameterTypes().length == 0) {
            try {
                Object obj = this.m.invoke(this.v, null);
                return obj == null ? null : String.valueOf(obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getLabel();
    }

    private String getBaseInfo() {
        StringBuffer s = new StringBuffer();
        Class<?>[] cls = this.m.getParameterTypes();
        s.append(this.m.getName()).append("(");
        for (int j = 0; j < cls.length; ++j) {
            s.append(MethodObjectNode.getClassName(cls[j]));
            if (j >= cls.length - 1) continue;
            s.append(", ");
        }
        s.append(")");
        return s.toString();
    }

    @Override
    public String toString() {
        return this.getBaseInfo() + " : " + MethodObjectNode.getClassName(this.m.getReturnType());
    }
}

