/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.objtree;

import com.kingdee.bos.ctrl.bibench.platform.ui.content.objtree.ConstructorObjectNode;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.objtree.FieldObjectNode;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.objtree.IObjectGenCodeConfig;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.objtree.IObjectTreeNode;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.objtree.MethodObjectNode;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.objtree.ObjectNode;
import com.kingdee.bos.ctrl.etl.actions.IActionInfo;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ObjectTree
extends KDTree
implements DragGestureListener,
DragSourceListener {
    private static Set maskMethodSet = new HashSet();
    private KingdeeTreeModel dtm;
    private DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"ROOT");
    private DefaultKingdeeTreeNode varRoot = new DefaultKingdeeTreeNode((Object)"\u73af\u5883\u53d8\u91cf");
    private DefaultKingdeeTreeNode etlRoot = null;
    private IObjectGenCodeConfig config;

    private static boolean isMaskMethod(Method m) {
        return maskMethodSet.contains(m);
    }

    public ObjectTree() {
        this(new IObjectGenCodeConfig(){

            @Override
            public String getGenFieldPrefix() {
                return "@";
            }

            @Override
            public String getGenMethodPrefix() {
                return "@";
            }
        });
    }

    public ObjectTree(IObjectGenCodeConfig config) {
        this.config = config;
        this.dtm = new KingdeeTreeModel((TreeNode)this.root);
        this.root.add((MutableTreeNode)this.varRoot);
        this.setModel((TreeModel)this.dtm);
        this.setRootVisible(false);
        DragSource ds = DragSource.getDefaultDragSource();
        ds.createDefaultDragGestureRecognizer((Component)((Object)this), 3, this);
    }

    public String getToolTipText(MouseEvent event) {
        if (event != null) {
            Point p = event.getPoint();
            int selRow = this.getRowForLocation(p.x, p.y);
            TreeCellRenderer r = this.getCellRenderer();
            if (selRow != -1 && r != null) {
                TreePath path = this.getPathForRow(selRow);
                Object v = ((DefaultKingdeeTreeNode)path.getLastPathComponent()).getUserObject();
                if (v != null) {
                    if (v instanceof ObjectNode && (v = ((ObjectNode)v).viewDefaultValue()) == null) {
                        return String.valueOf(path.getLastPathComponent());
                    }
                    return String.valueOf(v);
                }
                return String.valueOf(path.getLastPathComponent());
            }
        }
        return null;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.getSelectionPath().getLastPathComponent();
        Object obj = node.getUserObject();
        String s = obj instanceof IObjectTreeNode ? ((IObjectTreeNode)obj).getTemplateString() : node.getText();
        dge.startDrag(DragSource.DefaultCopyDrop, new StringSelection(" " + s), this);
    }

    public void addVarObject(String name, Object value) {
        this.addObject(name, name, value, false, this.varRoot);
    }

    public void setETLActsInfo(IActionInfo[] acts) {
        if (this.etlRoot == null) {
            this.etlRoot = new DefaultKingdeeTreeNode((Object)"ETL\u5bf9\u8c61");
            this.root.add((MutableTreeNode)this.etlRoot);
            this.updateUI();
        }
        if (acts != null) {
            for (IActionInfo act : acts) {
                this.addObject(act.getName(), act.getDesc(), act.getActClass(), true, this.etlRoot);
            }
        }
    }

    private void addObject(String name, String desc, Object v, boolean withConstructor, DefaultKingdeeTreeNode root) {
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode(v);
        node.setText(desc);
        root.add((MutableTreeNode)node);
        this.appendDumpInfo(name, v, withConstructor, node);
    }

    private void appendDumpInfo(String prefix, Object v, boolean withConstructor, DefaultKingdeeTreeNode root) {
        Class<?> cl = v instanceof Class ? (Class<?>)v : v.getClass();
        root.add((MutableTreeNode)new DefaultKingdeeTreeNode((Object)("class=" + ObjectNode.getClassName(cl))));
        if (cl.getPackage() == String.class.getPackage()) {
            return;
        }
        if (withConstructor) {
            DefaultKingdeeTreeNode constructor = new DefaultKingdeeTreeNode((Object)"\u6784\u9020\u65b9\u6cd5");
            root.add((MutableTreeNode)constructor);
            Constructor<?>[] cs = cl.getConstructors();
            for (int i = 0; i < cs.length; ++i) {
                Constructor<?> c = cs[i];
                constructor.add((MutableTreeNode)new DefaultKingdeeTreeNode((Object)new ConstructorObjectNode(prefix, c, v)));
            }
        }
        DefaultKingdeeTreeNode field = new DefaultKingdeeTreeNode((Object)"\u5c5e\u6027");
        root.add((MutableTreeNode)field);
        String attrP = this.config.getGenFieldPrefix();
        try {
            Field[] fs = cl.getFields();
            Arrays.sort(fs, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Field f1 = (Field)o1;
                    Field f2 = (Field)o2;
                    return f1.getName().compareTo(f2.getName());
                }
            });
            for (int i = 0; i < fs.length; ++i) {
                Field f = fs[i];
                field.add((MutableTreeNode)new DefaultKingdeeTreeNode((Object)new FieldObjectNode(attrP + prefix, f, v)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DefaultKingdeeTreeNode method = new DefaultKingdeeTreeNode((Object)"\u65b9\u6cd5");
        root.add((MutableTreeNode)method);
        String monthP = this.config.getGenMethodPrefix();
        try {
            Method[] ms = cl.getMethods();
            Arrays.sort(ms, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Method m1 = (Method)o1;
                    Method m2 = (Method)o2;
                    return m1.getName().compareTo(m2.getName());
                }
            });
            for (int i = 0; i < ms.length; ++i) {
                Method m = ms[i];
                if (ObjectTree.isMaskMethod(m)) continue;
                method.add((MutableTreeNode)new DefaultKingdeeTreeNode((Object)new MethodObjectNode(monthP + prefix, m, v)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    static {
        maskMethodSet.addAll(Arrays.asList(Object.class.getMethods()));
    }
}

