/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.x;

import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.bibench.platform.common.OlapRequestParams;
import com.kingdee.bos.ctrl.bibench.platform.common.OlapRequestor;
import com.kingdee.bos.ctrl.bibench.platform.ui.PaltformWorkBenchContext;
import com.kingdee.bos.ctrl.bibench.platform.ui.RDBaseAction;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.dsprovider.RDTableForCubeModelProvider;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.FilterDialog;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.FilterItemCollection;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.IRDReportActor;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.IRDReportContentPanel;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.title.TitlePanel;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.x.OlapCubeModelHelper;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.x.RDReportPanelX;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.x.RDReportViewDataSource;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.MsgBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractButton;

public class RDReportContentPanelX
extends KDPanel
implements IRDReportContentPanel {
    private RDReportPanelX op = new RDReportPanelX(this);
    private TitlePanel titlePanel = new TitlePanel();
    private PaltformWorkBenchContext ctx;
    private RDReportViewDataSource ds = null;
    private OlapRequestor request = new OlapRequestor();
    private IRDReportActor actor;
    private CubeModel cm;
    private RDTableForCubeModelProvider provider;
    private String mdx;
    private FilterItemCollection fc;
    private FilterDialog filterDialog;

    public RDReportContentPanelX(IRDReportActor actor, PaltformWorkBenchContext ctx) {
        this.ctx = ctx;
        this.actor = actor;
        this.initUI();
    }

    public RDReportContentPanelX(IRDReportActor actor) {
        this(actor, null);
    }

    public TitlePanel getTitlePanel() {
        return this.titlePanel;
    }

    public void setPaltformWorkBenchContext(PaltformWorkBenchContext ctx) {
        this.ctx = ctx;
        this.titlePanel.setPaltformWorkBenchContext(ctx);
    }

    @Override
    public KDTable getTable() {
        return this.op.getTable();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.titlePanel), "North");
        this.add((Component)((Object)this.op), "Center");
        this.op.setTitlePanel(this.titlePanel);
    }

    public KDToolBar getToolBar() {
        return this.op.getToolBar();
    }

    public Component[] getToolBarComponentForEmbed() {
        Component[] cs = this.op.getToolBar().getComponents();
        ArrayList<Component> list = new ArrayList<Component>();
        for (int i = 0; i < cs.length; ++i) {
            AbstractButton b;
            if (cs[i] instanceof AbstractButton && (b = (AbstractButton)cs[i]).getAction() instanceof RDBaseAction && ((RDBaseAction)b.getAction()).onlyForStandalone()) continue;
            list.add(cs[i]);
        }
        return list.toArray(new Component[0]);
    }

    public void refreshContent(CubeModel cm, RDTableForCubeModelProvider provider, String mdx, FilterItemCollection fc, String title, FilterDialog filterDialog) throws Exception {
        this.cm = cm;
        this.provider = provider;
        this.mdx = mdx;
        this.fc = fc;
        this.filterDialog = filterDialog;
        this.op.setFilterActionEnabled(filterDialog != null && filterDialog.isFilterEnabled());
        OlapModel model = this.buildModel(cm, provider, mdx, fc);
        this.op.setModel(model, this.request.getReturnParams().getConnection());
        this.op.setTitle(title);
    }

    private OlapModel buildModel(CubeModel cm, RDTableForCubeModelProvider provider, String mdx, FilterItemCollection fc) throws Exception {
        this.releaseEtlResource();
        this.ds = new RDReportViewDataSource(provider, this.ctx);
        OlapRequestParams cp = OlapCubeModelHelper.createRequestParamsFrom(cm, this.ds, fc);
        cp.setMdx(mdx);
        return this.request.requestModel(cp, this.ctx.getPlatformFacade(), false, this.hashCode());
    }

    private void releaseEtlResource() {
        if (this.ds != null) {
            Set set = this.ds.getEtlResourceSet();
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                this.ctx.getPlatformFacade().releaseETLResource((String)iter.next());
            }
        }
        this.ds = null;
    }

    @Override
    public void exit() {
        try {
            this.releaseEtlResource();
            this.request.close();
            if (this.actor != null) {
                this.actor.exit();
            }
        }
        catch (Exception e) {
            MsgBox.error("\u5173\u95ed\u8fde\u63a5\u9519\u8bef", e, (Component)((Object)this));
        }
    }

    @Override
    public void refresh() throws Exception {
        this.refreshContent(this.cm, this.provider, this.mdx, this.fc, this.op.getTitle(), this.filterDialog);
    }

    @Override
    public void showQueryDialog() throws Exception {
        FilterItemCollection cc;
        if (this.filterDialog != null && (cc = this.filterDialog.showQueryDialog()) != null) {
            this.fc = cc;
            this.refresh();
        }
    }
}

