/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.desktop;

import com.kingdee.bos.ctrl.bibench.platform.model.nodes.RDBaseNode;
import com.kingdee.bos.ctrl.bibench.platform.resource.BirdResource;
import com.kingdee.bos.ctrl.bibench.platform.ui.PaltformWorkBenchContext;
import com.kingdee.bos.ctrl.bibench.platform.ui.RDBaseAction;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.fs.RDBaseInternalFrame;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.fs.RDInnerFrameFactory;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.metadata.IRDMetaDataSource;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.metadata.RDSelectMetaObjectDlg;
import com.kingdee.bos.ctrl.bibench.platform.ui.desktop.DesktopCombineItem;
import com.kingdee.bos.ctrl.bibench.platform.ui.desktop.DesktopManager;
import com.kingdee.bos.ctrl.bibench.platform.ui.desktop.ICatalogTreeAction;
import com.kingdee.bos.ctrl.bibench.platform.ui.desktop.IDesktopCallBack;
import com.kingdee.bos.ctrl.bibench.platform.ui.desktop.RDTreePanel;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.IconUtil;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.MidiPlayer;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.MsgBox;
import com.kingdee.bos.ctrl.bibench.platform.ui.widget.CloseableTabbedPane;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.Closeable;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class RDWorkBenchFrame
extends KDFrame
implements ICatalogTreeAction {
    private PaltformWorkBenchContext ctx = null;
    private CloseableTabbedPane desktop = new CloseableTabbedPane();
    private RDTreePanel tree = new RDTreePanel();
    private KDToolBar toolBar = new KDToolBar();
    private DesktopManager deskManager = new DesktopManager();
    private RDSelectMetaObjectDlg dsQueryDialog = null;
    private RDSelectMetaObjectDlg dsEntityDialog = null;
    protected EventListenerList listenerList = new EventListenerList();
    private KDMenu editMenu = new KDMenu("\u7f16\u8f91(E)");

    public RDWorkBenchFrame(PaltformWorkBenchContext ctx) {
        this.enableEvents(64L);
        this.ctx = ctx;
        this.initUI();
    }

    public RDWorkBenchFrame() {
        this(new PaltformWorkBenchContext());
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.exit();
        } else {
            super.processWindowEvent(e);
        }
    }

    public void addDesktopCallBackListener(IDesktopCallBack l) {
        this.listenerList.add(IDesktopCallBack.class, l);
    }

    public void removeDesktopCallBackListener(IDesktopCallBack l) {
        this.listenerList.remove(IDesktopCallBack.class, l);
    }

    private void fireDesktopExit() {
        EventListener[] es = this.listenerList.getListeners(IDesktopCallBack.class);
        int n = es.length;
        for (int i = 0; i < n; ++i) {
            ((IDesktopCallBack)es[i]).beforeExit();
        }
    }

    private void initUI() {
        Container cc = this.getContentPane();
        cc.setLayout(new BorderLayout());
        this.setTitle("BI\u62a5\u8868\u5e73\u53f0");
        this.setExtendedState(6);
        this.setBounds(100, 100, 800, 600);
        this.setDefaultCloseOperation(2);
        this.ctx.setDesktop(this.desktop);
        this.ctx.setTree(this.tree);
        this.ctx.setFrame(this);
        KDSplitPane sp = new KDSplitPane(1);
        sp.getInputMap().put(KeyStroke.getKeyStroke("control P"), "midi");
        sp.getActionMap().put("midi", new AbstractAction("midi"){
            final String[] midis;
            int round;
            {
                this.midis = new String[]{"mid_dl", "mid_pal11"};
                this.round = 1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.round++ % 2 == 0) {
                    MidiPlayer.stopDefault();
                    return;
                }
                InputStream is = null;
                try {
                    SecureRandom sr = new SecureRandom();
                    is = BirdResource.class.getResourceAsStream(this.midis[(int)Math.round(sr.nextDouble() * (double)(this.midis.length - 1))]);
                    MidiPlayer.playDefault(is);
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{is});
                    throw throwable;
                }
                CloseUtil.close((Closeable[])new Closeable[]{is});
            }
        });
        sp.setDividerLocation(250);
        cc.add((Component)sp, "Center");
        sp.add((Component)((Object)this.tree), (Object)"left");
        KDPanel contentPanel = new KDPanel((LayoutManager)new BorderLayout());
        cc.add((Component)this.toolBar, "North");
        contentPanel.add((Component)((Object)this.desktop), (Object)"Center");
        sp.add((Component)contentPanel, (Object)"right");
        this.desktop.setBackground(Color.LIGHT_GRAY);
        this.tree.setCatalogTreeAction(this);
        this.deskManager.setWorkBenchContext(this.ctx);
        RDBaseAction exitAction = new RDBaseAction("\u9000\u51fa", IconUtil.getExitIcon()){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDWorkBenchFrame.this.exit();
            }
        };
        this.toolBar.add((Action)exitAction);
        KDMenuBar menuBar = new KDMenuBar();
        KDMenu km = new KDMenu("\u6587\u4ef6(F)");
        km.setMnemonic('F');
        km.add(new JMenuItem(exitAction));
        menuBar.add((JMenu)km);
        this.editMenu.setMnemonic('E');
        menuBar.add((JMenu)this.editMenu);
        this.editMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDWorkBenchFrame.this.ctx.getTree().changeMainEditMenu();
            }
        });
        this.setJMenuBar((JMenuBar)menuBar);
        this.desktop.setCloseHandler(new CloseableTabbedPane.CloseHandler(){

            @Override
            public boolean close(Component tabbedComponent, int tabIndex) {
                RDBaseInternalFrame f = (RDBaseInternalFrame)((Object)tabbedComponent);
                if (f.close()) {
                    RDWorkBenchFrame.this.desktop.remove(tabbedComponent);
                    return true;
                }
                return false;
            }
        });
        this.desktop.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RDBaseInternalFrame f = (RDBaseInternalFrame)((Object)RDWorkBenchFrame.this.desktop.getSelectedComponent());
                if (f != null) {
                    DesktopCombineItem dc = RDWorkBenchFrame.this.deskManager.getBy(f.getRDBaseNodeItem());
                    if (dc != null) {
                        dc.bindBar(RDWorkBenchFrame.this.toolBar);
                    } else {
                        RDWorkBenchFrame.this.deskManager.resetToolBar();
                    }
                } else {
                    RDWorkBenchFrame.this.deskManager.resetToolBar();
                }
            }
        });
        this.deskManager.setToolBar(this.toolBar, this.toolBar.getComponents());
    }

    public void setEditMenu(KDPopupMenu pm) {
        this.editMenu.removeAll();
        int n = pm.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.editMenu.add(pm.getComponent(0));
        }
    }

    public void onLoad() throws Exception {
        this.tree.onLoad();
    }

    public RDSelectMetaObjectDlg getQuerySelectMetaObjectDlg() {
        return this.dsQueryDialog;
    }

    public RDSelectMetaObjectDlg getEntitySelectMetaObjectDlg() {
        return this.dsEntityDialog;
    }

    public void setMetaDataSource(IRDMetaDataSource ds) {
        if (ds != null) {
            if (this.dsEntityDialog == null) {
                this.dsEntityDialog = new RDSelectMetaObjectDlg((Frame)((Object)this));
                this.dsEntityDialog.setMetaDataSource(ds);
            }
            if (this.dsQueryDialog == null) {
                this.dsQueryDialog = new RDSelectMetaObjectDlg((Frame)((Object)this));
                this.dsQueryDialog.setMetaDataSource(ds);
            }
        }
    }

    public RDTreePanel getTree() {
        return this.tree;
    }

    @Override
    public void open(RDBaseNode item) {
        DesktopCombineItem e = this.deskManager.getBy(item);
        if (e == null) {
            RDBaseInternalFrame f = RDInnerFrameFactory.createFrame(item);
            this.deskManager.add(item, f);
            try {
                f.onLoad();
            }
            catch (Exception ex) {
                MsgBox.error("\u6253\u5f00...", ex, (Component)((Object)this));
            }
        }
        this.active(item);
    }

    @Override
    public void active(RDBaseNode item) {
        Component c;
        DesktopCombineItem e = this.deskManager.getBy(item);
        if (e != null && e.f != (c = this.desktop.getSelectedComponent())) {
            if (c != null) {
                this.deskManager.getBy(((RDBaseInternalFrame)((Object)c)).getRDBaseNodeItem()).separateBar(this.toolBar);
            }
            e.bindBar(this.toolBar);
            this.desktop.setSelectedComponent((Component)((Object)e.f));
        }
    }

    @Override
    public boolean close(RDBaseNode item) {
        this.deskManager.remove(item);
        return true;
    }

    public PaltformWorkBenchContext getContext() {
        return this.ctx;
    }

    public DesktopManager getDesktopList() {
        return this.deskManager;
    }

    public void exit() {
        this.fireDesktopExit();
        this.dispose();
    }
}

