/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.etl.content;

import com.kingdee.bos.ctrl.bibench.platform.ui.etl.actions.job.JobDeleteAction;
import com.kingdee.bos.ctrl.bibench.platform.ui.etl.actions.job.JobDesignAction;
import com.kingdee.bos.ctrl.bibench.platform.ui.etl.actions.job.JobExecuteAction;
import com.kingdee.bos.ctrl.bibench.platform.ui.etl.content.CanRefresh;
import com.kingdee.bos.ctrl.bibench.platform.ui.etl.content.ContentTable;
import com.kingdee.bos.ctrl.bibench.platform.ui.etl.context.ETLConsoleContext;
import com.kingdee.bos.ctrl.bibench.platform.ui.etl.exception.ETLRemoteException;
import com.kingdee.bos.ctrl.bibench.platform.ui.etl.util.Util;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.console.AbstractConsoleAction;
import com.kingdee.bos.ctrl.common.ui.console.content.AbstractConsoleContent;
import com.kingdee.bos.ctrl.common.ui.console.content.IConsoleContent;
import com.kingdee.bos.ctrl.common.ui.console.content.ILeafContent;
import com.kingdee.bos.ctrl.etl.exception.ETLJobException;
import com.kingdee.bos.ctrl.etl.server.facade.ETLServerFacade;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class JobPackageUI
extends AbstractConsoleContent
implements ILeafContent,
CanRefresh {
    private KDPanel tablePane = null;
    private ContentTable table = null;

    public JobPackageUI() {
        this.initListener();
        this.initPopMenu();
    }

    public void importJob() {
        File file = WindowUtil.chooseFile((boolean)true, (int)0, null, (String)"", null);
        if (file == null) {
            return;
        }
        String filePathname = file.getAbsolutePath();
        try {
            this.getETLServerFacade().importJobFile(filePathname);
        }
        catch (ETLJobException e) {
            WindowUtil.showException((String)("\u4efb\u52a1\u5305\u5bfc\u5165\u5931\u8d25!\r\n\u9519\u8bef\u539f\u56e0\uff1a" + e.getMessage()), (Throwable)e, (String)"\u53d1\u751f\u5f02\u5e38", (Component)((Object)this.getTable()));
            return;
        }
        catch (ETLRemoteException e) {
            WindowUtil.alert(null, (String)("\u901a\u8baf\u6545\u969c!\u9519\u8bef\u539f\u56e0:" + e.getMessage()));
            return;
        }
    }

    public void runSelJob() {
        long id_job = this.getSelJobID();
        if (id_job == -1L) {
            return;
        }
        try {
            this.getETLServerFacade().runJob(id_job);
        }
        catch (ETLRemoteException e1) {
            WindowUtil.alert(null, (String)("\u901a\u8baf\u6545\u969c!\u9519\u8bef\u539f\u56e0:" + e1.getMessage()));
            return;
        }
        catch (Exception e) {
            WindowUtil.alert(null, (String)("\u4efb\u52a1\u5305\u6267\u884c\u5931\u8d25!\u9519\u8bef\u539f\u56e0:" + e.getMessage()));
            return;
        }
        WindowUtil.alert(null, (String)"\u4efb\u52a1\u5305\u6267\u884c\u6210\u529f!");
    }

    private ETLServerFacade getETLServerFacade() throws ETLRemoteException {
        if (this.getContext() instanceof ETLConsoleContext) {
            return ((ETLConsoleContext)this.getContext()).getETLServerController();
        }
        return null;
    }

    private long getSelJobID() {
        String sID = this.getRowID(this.getTable().getSelectionRow());
        long id_job = Util.toInt(sID, -1);
        return id_job;
    }

    private void initPopMenu() {
        this.addMenuItem(new JobDesignAction());
        this.addMenuItem(new JobExecuteAction());
        this.addMenuItem(null);
        this.addMenuItem(new JobDeleteAction());
    }

    private void initListener() {
        this.getTable().addKDTMouseListener(new TableMouseListener());
    }

    public ContentTable getTable() {
        if (this.table != null) {
            return this.table;
        }
        this.table = new ContentTable();
        this.table.addColumns(new String[]{"jobid", "jobname", "jobdescription", "JobCreateUser", "JobCreateTime"});
        this.table.setHeadText("jobid", "JobID");
        this.table.setHeadText("jobname", "\u4efb\u52a1\u540d");
        this.table.setHeadText("jobdescription", "\u4efb\u52a1\u63cf\u8ff0");
        this.table.setHeadText("JobCreateUser", "\u521b\u5efa\u4eba");
        this.table.setHeadText("JobCreateTime", "\u521b\u5efa\u65f6\u95f4");
        this.table.getStyleAttributes().setLocked(true);
        this.table.setColumnWidth("jobid", 0);
        this.table.setColumnWidth("jobname", 150);
        this.table.setColumnWidth("jobdescription", 200);
        this.table.setColumnWidth("JobCreateUser", 120);
        this.table.setColumnWidth("JobCreateTime", 120);
        return this.table;
    }

    private KDPanel makeTablePane() {
        KDPanel panel = new KDPanel((LayoutManager)new BorderLayout());
        ContentTable t = this.getTable();
        panel.add((Component)((Object)t), (Object)"Center");
        t.setParent((Component)panel);
        return panel;
    }

    public void setPopMenuShow(boolean b) {
        this.getTable().setPopMenuShow(b);
    }

    protected void addMenuItem(AbstractConsoleAction action) {
        if (action == null) {
            this.getTable().getPopMenu().add((Component)new KDSeparator());
            return;
        }
        action.setUI((IConsoleContent)this);
        this.getTable().getPopMenu().add((JMenuItem)new KDMenuItem((Action)action));
    }

    @Override
    public void refresh() {
        HashMap allAttrs;
        try {
            ETLServerFacade serverFocade = this.getETLServerFacade();
            allAttrs = serverFocade.listJobs();
        }
        catch (ETLRemoteException e) {
            e.printStackTrace();
            return;
        }
        if (allAttrs == null) {
            this.getTable().removeRows();
        } else {
            this.refresh(allAttrs);
        }
    }

    protected void refresh(HashMap allAttrs) {
        ContentTable t = this.getTable();
        t.getBody().removeRows();
        String[] names = (String[])allAttrs.get("jobname");
        int r = 0;
        for (int i = 0; i < names.length; ++i) {
            HashMap atts = Util.makeRowAtts(i, allAttrs);
            t.addRow(r);
            this.setRow(r, atts);
            ++r;
        }
    }

    public void clear() {
        this.getTable().removeRows();
    }

    private void setRow(int r, HashMap attrs) {
        ContentTable t = this.getTable();
        t.setRowUserObject(r, attrs);
        t.setCellValue(r, "jobid", attrs.get("jobid"));
        t.setCellValue(r, "jobname", attrs.get("jobname"));
        t.setCellValue(r, "jobdescription", attrs.get("jobdescription"));
        t.setCellValue(r, "JobCreateUser", attrs.get("JobCreateUser"));
        t.setCellValue(r, "JobCreateTime", attrs.get("JobCreateTime"));
    }

    private HashMap getRowAttrs(int r) {
        return (HashMap)this.getTable().getRowUserObject(r);
    }

    private String getRowID(int r) {
        return (String)this.getRowAttrs(r).get("jobid");
    }

    public void installCtrl(JPanel panel) {
        if (this.tablePane == null) {
            this.tablePane = this.makeTablePane();
        }
        this.refresh();
        panel.add((Component)this.tablePane, "Center");
    }

    private class TableMouseListener
    implements KDTMouseListener {
        private TableMouseListener() {
        }

        public void tableClicked(KDTMouseEvent e) {
            JobDesignAction action;
            if (!JobPackageUI.this.getTable().isPopMenuShow()) {
                return;
            }
            if (SwingUtilities.isLeftMouseButton((MouseEvent)e) && e.getClickCount() == 2 && (action = new JobDesignAction()) != null) {
                action.setUI((IConsoleContent)JobPackageUI.this);
                action.actionPerformed(new ActionEvent(e, 0, null));
            }
        }
    }
}

