/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.layout.table;

import com.kingdee.bos.ctrl.common.layout.table.StyleInfo;

public final class Style {
    protected static final short NULL_ALIGN = 0;
    public static final short ALIGN_LEFT = 1;
    public static final short ALIGN_RIGHT = 2;
    public static final short ALIGN_CENTER = 4;
    public static final short ALIGN_TOP = 1;
    public static final short ALIGN_BOTTOM = 2;
    public static final short ALIGN_MIDDLE = 4;
    public static final short WIDTH = 256;
    public static final short MIN_WIDTH = 512;
    public static final short MAX_WIDTH = 1024;
    public static final short ALIGNMENT_X = 2048;
    public static final short MARGIN_LEFT = 4096;
    public static final short MARGIN_RIGHT = 8192;
    public static final short PRI_X = 16384;
    public static final short HEIGHT = 1;
    public static final short MIN_HEIGHT = 2;
    public static final short MAX_HEIGHT = 4;
    public static final short ALIGNMENT_Y = 8;
    public static final short MARGIN_TOP = 16;
    public static final short MARGIN_BOTTOM = 32;
    public static final short PRI_Y = 64;
    private static final short X_FIELDS = 32512;
    private static final short Y_FIELDS = 127;
    StyleInfo _x = new StyleInfo();
    StyleInfo _y = new StyleInfo();
    protected boolean _isVisible;

    public void setVisible(boolean is) {
        this._isVisible = is;
    }

    public boolean isVisible() {
        return this._isVisible;
    }

    public Style() {
        this.clear();
    }

    public Style(Style src) {
        this.copy(src);
    }

    public final boolean has(int fields) {
        return this._x.has(fields) || this._y.has(fields);
    }

    public void clear() {
        this._isVisible = true;
        this._x.clear();
        this._y.clear();
    }

    public void clear(int field) {
        this._x.clear(field);
        this._y.clear(field);
    }

    public void copy(Style src) {
        this._isVisible = src._isVisible;
        this._x.copy(src._x);
        this._y.copy(src._y);
    }

    public void makeFields(Style src) {
        boolean bl = this._isVisible = this._isVisible && src._isVisible;
        if (this._x._fields != 32512) {
            this._x.makeFields(src._x);
        }
        if (this._y._fields != 127) {
            this._y.makeFields(src._y);
        }
    }

    public void setAlignment(short alignX, short alignY) {
        this.setAlignmentX(alignX);
        this.setAlignmentY(alignY);
    }

    public void setSize(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public void setMinSize(int minWidth, int minHeight) {
        this.setMinWidth(minWidth);
        this.setMinHeight(minHeight);
    }

    public void setMaxSize(int maxWidth, int maxHeight) {
        this.setMaxWidth(maxWidth);
        this.setMaxHeight(maxHeight);
    }

    public void lockSize(int width, int height) {
        this.lockWidth(width);
        this.lockHeight(height);
    }

    public void lockWidth(int width) {
        this.setWidth(width);
        this.setMinWidth(width);
        this.setMaxWidth(width);
    }

    public void lockHeight(int height) {
        this.setHeight(height);
        this.setMinHeight(height);
        this.setMaxHeight(height);
    }

    public void setMargin(int margin) {
        this.setMarginLeft(margin);
        this.setMarginRight(margin);
        this.setMarginTop(margin);
        this.setMarginBottom(margin);
    }

    public void setMargin(int left, int top, int right, int bottom) {
        this.setMarginLeft(left);
        this.setMarginRight(right);
        this.setMarginTop(top);
        this.setMarginBottom(bottom);
    }

    public int getPriX() {
        return this._x._pri;
    }

    public void setPriX(int pri) {
        this._x._fields |= 0x4000;
        this._x._pri = pri;
    }

    public int getWidth() {
        return this._x._val;
    }

    public void setWidth(int width) {
        this._x._fields |= 0x100;
        this._x._val = width;
    }

    public int getMinWidth() {
        return this._x._min;
    }

    public void setMinWidth(int minWidth) {
        this._x._fields |= 0x200;
        this._x._min = minWidth;
    }

    public int getMaxWidth() {
        return this._x._max;
    }

    public void setMaxWidth(int maxWidth) {
        this._x._fields |= 0x400;
        this._x._max = maxWidth;
    }

    public int getMarginLeft() {
        return this._x._margin1;
    }

    public void setMarginLeft(int left) {
        this._x._fields |= 0x1000;
        this._x._margin1 = left;
    }

    public int getMarginRight() {
        return this._x._margin2;
    }

    public void setMarginRight(int right) {
        this._x._fields |= 0x2000;
        this._x._margin2 = right;
    }

    public short getAlignmentX() {
        return this._x._alignment;
    }

    public void setAlignmentX(short alignmentX) {
        this._x._fields |= 0x800;
        this._x._alignment = alignmentX;
    }

    public int getPriY() {
        return this._y._pri;
    }

    public void setPriY(int pri) {
        this._y._fields |= 0x40;
        this._y._pri = pri;
    }

    public int getHeight() {
        return this._y._val;
    }

    public void setHeight(int height) {
        this._y._fields |= 1;
        this._y._val = height;
    }

    public int getMinHeight() {
        return this._y._min;
    }

    public void setMinHeight(int minHeight) {
        this._y._fields |= 2;
        this._y._min = minHeight;
    }

    public int getMaxHeight() {
        return this._y._max;
    }

    public void setMaxHeight(int maxHeight) {
        this._y._fields |= 4;
        this._y._max = maxHeight;
    }

    public int getMarginTop() {
        return this._y._margin1;
    }

    public void setMarginTop(int top) {
        this._y._fields |= 0x10;
        this._y._margin1 = top;
    }

    public int getMarginBottom() {
        return this._y._margin2;
    }

    public void setMarginBottom(int bottom) {
        this._y._fields |= 0x20;
        this._y._margin2 = bottom;
    }

    public short getAlignmentY() {
        return this._y._alignment;
    }

    public void setAlignmentY(short alignmentY) {
        this._y._fields |= 8;
        this._y._alignment = alignmentY;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        if ((this._x._fields & 0x4000) == 16384) {
            s.append(",priX=" + this._x._pri);
        }
        if ((this._y._fields & 0x40) == 64) {
            s.append(",priY=" + this._y._pri);
        }
        if ((this._x._fields & 0x100) == 256) {
            s.append(",width=" + this._x._val);
        }
        if ((this._y._fields & 1) == 1) {
            s.append(",height=" + this._y._val);
        }
        if ((this._x._fields & 0x200) == 512) {
            s.append(",minWidth=" + this._x._min);
        }
        if ((this._y._fields & 2) == 2) {
            s.append(",minHeight=" + this._y._min);
        }
        if ((this._x._fields & 0x400) == 1024) {
            s.append(",maxWidth=" + this._x._max);
        }
        if ((this._y._fields & 4) == 4) {
            s.append(",maxHeight=" + this._y._max);
        }
        if ((this._x._fields & 0x1000) == 4096) {
            s.append(",marginLeft=" + this._x._margin1);
        }
        if ((this._y._fields & 0x10) == 16) {
            s.append(",marginTop=" + this._y._margin1);
        }
        if ((this._x._fields & 0x2000) == 8192) {
            s.append(",marginRight=" + this._x._margin2);
        }
        if ((this._y._fields & 0x20) == 32) {
            s.append(",marginBottom=" + this._y._margin2);
        }
        if ((this._x._fields & 0x800) == 2048) {
            s.append(",alignmentX=" + this._x._alignment);
        }
        if ((this._y._fields & 8) == 8) {
            s.append(",alignmentY=" + this._y._alignment);
        }
        return s.toString();
    }
}

