/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.restype.def.io;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.restype.def.ActionDef;
import com.kingdee.bos.ctrl.common.restype.def.ActionExecutorDef;
import com.kingdee.bos.ctrl.common.restype.def.ActionGroupDef;
import com.kingdee.bos.ctrl.common.restype.def.ResTypeDef;
import com.kingdee.bos.ctrl.common.restype.def.ResTypeDefs;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class Xml2ResTypeDefs {
    public static final Logger log = LogUtil.getPackageLogger(Xml2ResTypeDefs.class);
    public static final String T_RES_TYPE_DEFS = "ResTypeDefs";
    public static final String T_RES_TYPE_DEF = "ResTypeDef";
    public static final String T_PROPERTY = "Property";
    public static final String T_ActionArg = "ActionArg";
    public static final String T_ACTION_UNDEF = "ActionUnDef";
    public static final String T_ACTION_DEF = "ActionDef";
    public static final String T_ACTION_GROUPDEF = "ActionGroupDef";
    public static final String T_ACTION_IMPORTS = "ActionImports";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_NAMES = "names";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_EXTENDS = "extends";
    public static final String ATTR_ENABLE = "enable";
    public static final String ATTR_DEFAULT = "default";
    public static final String ATTR_MULTI_OBJECTS_FILTER = "multi-objects-filter";
    public static final String ATTR_DISPLAY_LABEL = "display-label";
    public static final String ATTR_DISPLAY_ICON = "display-icon";
    public static final String ATTR_TOOLTIP = "tooltip-label";
    public static final String ATTR_ACTION_EXECUTOR = "action";
    public static final String ATTR_ACTION_GROUP = "action-group";

    public static final ResTypeDefs toObject(Element e) {
        ResTypeDefs typeDefs = new ResTypeDefs();
        try {
            ResTypeDef.ActionDefs externalActions = Xml2ResTypeDefs.makeExternalActionDefs(e.getChildren(T_ACTION_DEF));
            List list = e.getChildren(T_RES_TYPE_DEF);
            Iterator i = list.iterator();
            while (i.hasNext()) {
                ResTypeDef typeDef = Xml2ResTypeDef.toObject((Element)i.next(), externalActions);
                typeDefs.add(typeDef);
            }
            typeDefs.trim();
            return typeDefs;
        }
        catch (Exception ex) {
            log.error((Object)"\u6784\u9020ResTypeDefs\u5931\u8d25", (Throwable)ex);
            return null;
        }
    }

    private static final ResTypeDef.ActionGroupDefs makeActionGroupDefs(List es) {
        ResTypeDef.ActionGroupDefs list = new ResTypeDef.ActionGroupDefs();
        for (Element eChild : es) {
            list.add(Xml2ActionGroupDef.toObject(eChild));
        }
        return list;
    }

    private static final ResTypeDef.ActionDefs makeExternalActionDefs(List actionDefList) {
        return Xml2ResTypeDefs.makeActionDefs(null, actionDefList, null);
    }

    private static final ResTypeDef.ActionDefs makeActionDefs(ResTypeDef.ActionDefs externalDefs, List actionDefList, ResTypeDef typeDef) {
        ResTypeDef.ActionDefs actionDefs = new ResTypeDef.ActionDefs();
        for (Element eChild : actionDefList) {
            int j;
            String[] ss;
            if (eChild.getName().equals(T_ACTION_DEF)) {
                ActionDef actionDef = Xml2ActionDef.toObject(eChild);
                if (actionDefs.add(actionDef) != null) {
                    log.warn((Object)("\u91cd\u590d\u5b9a\u4e49action:" + actionDef.getName()));
                }
                actionDef.setResTypeDef(typeDef);
                continue;
            }
            if (eChild.getName().equals(T_ACTION_UNDEF)) {
                String unDefs = eChild.getAttributeValue(ATTR_NAMES);
                ss = unDefs.split(",");
                for (j = 0; j < ss.length; ++j) {
                    actionDefs.add(new ActionDef(ss[j], false));
                }
                continue;
            }
            if (!eChild.getName().equals(T_ACTION_IMPORTS)) continue;
            String importDefs = eChild.getAttributeValue(ATTR_NAMES);
            ss = importDefs.split(",");
            for (j = 0; j < ss.length; ++j) {
                ActionDef actionDef = externalDefs.get(ss[j]);
                if (actionDef == null) {
                    log.warn((Object)("\u672a\u627e\u5230\u5916\u90e8\u7684ActionDef\u5b9a\u4e49,name=" + ss[j]));
                    continue;
                }
                ActionDef temp = (ActionDef)CtrlUtil.Obj.safeCloneObject(actionDef);
                temp.setResTypeDef(typeDef);
                actionDefs.add(temp);
            }
        }
        return actionDefs;
    }

    public static final class Xml2IExecutorDef {
        public static final ActionExecutorDef toObject(Element e) {
            String attr = e.getAttributeValue(Xml2ResTypeDefs.ATTR_ACTION_EXECUTOR);
            if (attr == null) {
                return null;
            }
            String javaClass = attr;
            try {
                ActionExecutorDef executorDef = new ActionExecutorDef();
                executorDef.setJavaClassName(javaClass);
                executorDef.setArgs(XmlUtil.makeMap(e.getChildren(Xml2ResTypeDefs.T_ActionArg)));
                return executorDef;
            }
            catch (Exception ex) {
                log.error(null, (Throwable)ex);
                return null;
            }
        }
    }

    public static final class Xml2ActionDef {
        public static final ActionDef toObject(Element e) {
            ActionDef def = new ActionDef();
            String attr = e.getAttributeValue(Xml2ResTypeDefs.ATTR_NAME);
            if (attr == null) {
                return null;
            }
            def.setName(attr);
            def.setActionExecutorDef(Xml2IExecutorDef.toObject(e));
            List attrs = e.getAttributes();
            if (attrs != null) {
                for (int i = 0; i < attrs.size(); ++i) {
                    Attribute attrObj = (Attribute)attrs.get(i);
                    def.setProperty(attrObj.getName(), attrObj.getValue());
                }
            }
            return def;
        }
    }

    public static final class Xml2ActionGroupDef {
        public static final ActionGroupDef toObject(Element e) {
            String name = e.getAttributeValue(Xml2ResTypeDefs.ATTR_NAME);
            ActionGroupDef def = new ActionGroupDef(name);
            List attrs = e.getAttributes();
            if (attrs.size() > 1) {
                HashMap<String, String> properties = new HashMap<String, String>();
                for (Attribute attr : attrs) {
                    properties.put(attr.getName(), attr.getValue());
                }
                def.setProperties(properties);
            }
            return def;
        }
    }

    public static final class Xml2ResTypeDef {
        public static final ResTypeDef toObject(Element e, ResTypeDef.ActionDefs externalActions) {
            ResTypeDef def = new ResTypeDef();
            String attr = e.getAttributeValue(Xml2ResTypeDefs.ATTR_NAME);
            if (attr == null) {
                return null;
            }
            def.setName(attr);
            attr = e.getAttributeValue(Xml2ResTypeDefs.ATTR_EXTENDS);
            def.setExtendTypeNames(attr);
            List children = e.getChildren(Xml2ResTypeDefs.T_PROPERTY);
            if (children != null && children.size() > 0) {
                def.setProperties(XmlUtil.makeMap(children));
            }
            if ((children = e.getChildren(Xml2ResTypeDefs.T_ACTION_GROUPDEF)) != null && children.size() > 0) {
                def.setActionGroups(Xml2ResTypeDefs.makeActionGroupDefs(children));
            }
            if ((children = e.getChildren()) != null && children.size() > 0) {
                def.setActionDefs(Xml2ResTypeDefs.makeActionDefs(externalActions, children, def));
                def.solveActionGroups();
            }
            return def;
        }
    }
}

