/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.UIManager;
import org.apache.commons.io.FilenameUtils;

public class FontUtil {
    private static Font defaultFont = UIManager.getFont("FontFromFile");
    private static Font simsunServerFont;
    private static boolean simsunInited;

    public static Font getDefaultFont() {
        return defaultFont;
    }

    public static void setDefaultFont(Font defaultFont) {
        FontUtil.defaultFont = defaultFont;
    }

    public static Font getServerFontSupportedChinese() {
        if (!simsunInited) {
            String prop = System.getProperty("eas.properties.dir");
            if (prop != null) {
                try {
                    simsunServerFont = Font.createFont(0, new File(FilenameUtils.normalize((String)(prop + "/simsun.ttc"))));
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (FontFormatException fontFormatException) {
                }
                catch (IOException iOException) {
                }
                finally {
                    simsunInited = true;
                }
            } else {
                simsunInited = true;
            }
        }
        return simsunServerFont;
    }

    public static boolean isChineseDrawable(Font font) {
        return font.canDisplay('\u5b8b');
    }

    public static boolean isLatinDrawable(Font font) {
        return font.canDisplay('S');
    }

    public static AttributedString validateFont(AttributedString str) {
        if (str != null) {
            AttributedCharacterIterator.Attribute[] fatr = new AttributedCharacterIterator.Attribute[]{TextAttribute.FONT};
            AttributedCharacterIterator acitr = str.getIterator(fatr);
            Font ft = null;
            ArrayList<Integer> al = new ArrayList<Integer>();
            char c = acitr.first();
            while (c != '\uffff') {
                if (ft == null) {
                    ft = (Font)acitr.getAttribute(TextAttribute.FONT);
                }
                if (ft != null && !ft.canDisplay(c)) {
                    al.add(new Integer(acitr.getIndex()));
                }
                c = acitr.next();
            }
            if (al.size() > 0) {
                HashMap<TextAttribute, String> map = new HashMap<TextAttribute, String>();
                map.put(TextAttribute.FAMILY, ft.getFamily() + ",simsun,Segoe UI Symbol");
                Font nft = ft.deriveFont(map);
                Iterator itr = al.iterator();
                while (itr.hasNext()) {
                    int i = (Integer)itr.next();
                    str.addAttribute(TextAttribute.FONT, nft, i, i + 1);
                }
            }
        }
        return str;
    }

    public static Font validateFont(String source, Font font) {
        if (StringUtil.isEmptyString(source)) {
            return font;
        }
        boolean change = false;
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c > '\u007f' && c < '\u0100' || font.canDisplay(c)) continue;
            change = true;
            break;
        }
        if (change) {
            HashMap<TextAttribute, String> map = new HashMap<TextAttribute, String>();
            map.put(TextAttribute.FAMILY, font.getFamily() + ",simsun,Segoe UI Symbol");
            return font.deriveFont(map);
        }
        return font;
    }
}

