/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util;

import java.util.BitSet;

public class IntIDMaker {
    private BitSet bs;
    private int seekFrom;
    private int lastFreeId;

    public IntIDMaker() {
        this.clear();
    }

    public synchronized void clear() {
        if (this.bs == null) {
            this.bs = new BitSet();
        } else {
            this.bs.clear();
        }
        this.seekFrom = 0;
        this.lastFreeId = -1;
    }

    public synchronized int next() {
        int index;
        if (this.lastFreeId != -1) {
            index = this.lastFreeId;
            this.bs.set(index);
            this.lastFreeId = -1;
        } else {
            index = this.bs.nextClearBit(this.seekFrom);
            this.bs.set(index);
            this.seekFrom = index + 1;
        }
        return index;
    }

    public synchronized void free(int id) {
        try {
            this.bs.clear(id);
        }
        catch (Exception ex) {
            return;
        }
        this.lastFreeId = id;
        if (this.seekFrom > this.lastFreeId) {
            this.seekFrom = this.lastFreeId;
        }
    }

    public synchronized boolean markUsed(int id) {
        try {
            this.bs.set(id);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }
}

