/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MapUtil {
    public static final void updateValues(Map out, Map in) {
        if (in == out) {
            return;
        }
        if (in == null || out == null) {
            return;
        }
        if (out.isEmpty()) {
            return;
        }
        int z = out.size();
        Map.Entry[] ents = new Map.Entry[z];
        out.entrySet().toArray(ents);
        for (int i = 0; i < z; ++i) {
            Map.Entry ent = ents[i];
            Object inVal = in.get(ent.getKey());
            if (inVal == ent.getValue() || inVal == null && !in.containsKey(ent)) continue;
            ent.setValue(inVal);
        }
    }

    public static final void addNew(Map out, Map in) {
        if (in == null || out == null) {
            return;
        }
        int z = in.size();
        if (z == 0) {
            return;
        }
        for (Map.Entry ent : in.entrySet()) {
            Object key = ent.getKey();
            if (out.containsKey(key)) continue;
            out.put(key, ent.getValue());
        }
    }

    public static final void add(Map out, Map in) {
        if (in == null || out == null) {
            return;
        }
        int z = in.size();
        if (z == 0) {
            return;
        }
        Map.Entry[] ents = new Map.Entry[z];
        in.entrySet().toArray(ents);
        for (int i = 0; i < z; ++i) {
            Map.Entry ent = ents[i];
            out.put(ent.getKey(), ent.getValue());
        }
    }

    public static final void addKeyPrefix(Map in, String prefix, Map out) {
        if (in == null || out == null) {
            return;
        }
        int z = in.size();
        if (z == 0) {
            return;
        }
        Map.Entry[] ents = new Map.Entry[z];
        in.entrySet().toArray(ents);
        for (int i = 0; i < z; ++i) {
            Map.Entry ent = ents[i];
            out.put(prefix + (String)ent.getKey(), ent.getValue());
        }
    }

    public static final void addKeySuffix(Map in, String suffix, Map out) {
        if (in == null || out == null) {
            return;
        }
        int z = in.size();
        if (z == 0) {
            return;
        }
        Map.Entry[] ents = new Map.Entry[z];
        in.entrySet().toArray(ents);
        for (int i = 0; i < z; ++i) {
            Map.Entry ent = ents[i];
            out.put((String)ent.getKey() + suffix, ent.getValue());
        }
    }

    public static final void subKeyPrefix(Map in, String prefix, Map out) {
        if (in == null || out == null) {
            return;
        }
        int z = in.size();
        if (z == 0) {
            return;
        }
        int len = prefix.length();
        Map.Entry[] ents = new Map.Entry[z];
        in.entrySet().toArray(ents);
        for (int i = 0; i < z; ++i) {
            Map.Entry ent = ents[i];
            String key = (String)ent.getKey();
            if (!key.startsWith(prefix)) continue;
            out.put(key.substring(len), ent.getValue());
        }
    }

    public static HashMap gather(Map in, String s, boolean prefix_suffix) {
        HashMap map = new HashMap();
        Iterator keys = in.keySet().iterator();
        Iterator vals = in.values().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object val = vals.next();
            if (prefix_suffix) {
                if (!key.startsWith(s)) continue;
                map.put(key, val);
                continue;
            }
            if (!key.endsWith(s)) continue;
            map.put(key, val);
        }
        return map;
    }

    public static final void subKeySuffix(Map in, String suffix, Map out) {
        if (in == null || out == null) {
            return;
        }
        int z = in.size();
        if (z == 0) {
            return;
        }
        int len = suffix.length();
        Map.Entry[] ents = new Map.Entry[z];
        in.entrySet().toArray(ents);
        for (int i = 0; i < z; ++i) {
            Map.Entry ent = ents[i];
            String key = (String)ent.getKey();
            int pos = key.lastIndexOf(suffix);
            if (pos == -1 || pos + len != key.length()) continue;
            out.put(key.substring(0, pos), ent.getValue());
        }
    }

    public static final boolean equals(Map map1, Map map2) {
        if (map1 == map2) {
            return map1 != null;
        }
        if (map1 == null || map2 == null) {
            return false;
        }
        int z = map1.size();
        if (z != map2.size()) {
            return false;
        }
        if (z == 0) {
            return true;
        }
        Map.Entry[] ents = new Map.Entry[z];
        map1.entrySet().toArray(ents);
        for (int i = 0; i < z; ++i) {
            Map.Entry ent = ents[i];
            Object key1 = ent.getKey();
            Object val1 = ent.getValue();
            Object val2 = map2.get(key1);
            if (val2 == null) {
                if (!map2.containsKey(key1)) {
                    return false;
                }
                if (val1 == null) continue;
                return false;
            }
            if (val1 == null) {
                return false;
            }
            if (val2.equals(val1)) continue;
            return false;
        }
        return true;
    }

    public static final void removeNullVals(Map map) {
        Object[] vals = map.values().toArray();
        Object[] keys = null;
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] != null) continue;
            if (keys == null) {
                keys = map.keySet().toArray();
            }
            map.remove(keys[i]);
        }
    }
}

