/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util;

import com.kingdee.bos.ctrl.kdf.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class ObjectUtil {
    public static String objectToString(Object obj) {
        if (obj == null || !(obj instanceof Serializable)) {
            return null;
        }
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bs);
            oos.writeObject(obj);
            oos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return Base64.encodeBytes(bs.toByteArray());
    }

    public static Object stringToObject(String str) {
        Object obj;
        if (str == null || str.equals("")) {
            return null;
        }
        ByteArrayInputStream bs = new ByteArrayInputStream(Base64.decode(str));
        try {
            ObjectInputStream ois = new ObjectInputStream(bs);
            obj = ois.readObject();
        }
        catch (IOException e) {
            obj = null;
        }
        catch (ClassNotFoundException e) {
            obj = null;
        }
        return obj;
    }

    public static Object cloneObject(Object source) {
        Object result = null;
        if (source != null) {
            Class<?> c = source.getClass();
            try {
                Method mtd = c.getMethod("clone", null);
                try {
                    result = mtd.invoke(source, null);
                }
                catch (IllegalArgumentException e1) {
                    result = null;
                }
                catch (IllegalAccessException e1) {
                    result = null;
                }
                catch (InvocationTargetException e1) {
                    result = null;
                }
            }
            catch (SecurityException e) {
                result = null;
            }
            catch (NoSuchMethodException e) {
                result = null;
            }
        }
        return result;
    }

    public static HashMap cloneHashMap(HashMap map) {
        return map != null ? (HashMap)map.clone() : null;
    }

    public static Object safeCloneObject(Serializable src) {
        try {
            return ObjectUtil.cloneObject(src);
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException(ex.toString());
        }
    }

    public static Object cloneObject(Serializable src) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(src);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        return ois.readObject();
    }

    public static Integer stringToInteger(String val, Integer defaultVal) {
        if (val != null) {
            try {
                return Integer.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public static Boolean stringToBoolean(String val, Boolean defaultVal) {
        if (val == null || val.length() == 0) {
            return defaultVal;
        }
        try {
            val = val.trim();
            int bInt = Integer.parseInt(val);
            if (bInt <= 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (NumberFormatException bInt) {
            try {
                return Boolean.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                return defaultVal;
            }
        }
    }

    public static Object createObject(Class cls, Class[] paramTypes, Object[] params) {
        Object obj;
        Constructor c;
        try {
            c = cls.getConstructor(paramTypes);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
        try {
            obj = c.newInstance(params);
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
            return null;
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
            return null;
        }
        return obj;
    }

    public static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static boolean equals(byte[] val1, byte[] val2) {
        if (val1.length != val2.length) {
            return false;
        }
        int len = val1.length;
        for (int i = 0; i < len; ++i) {
            if (val1[i] == val2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] val1, char[] val2) {
        if (val1.length != val2.length) {
            return false;
        }
        int len = val1.length;
        for (int i = 0; i < len; ++i) {
            if (val1[i] == val2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equalValues(Object[] objs1, Object[] objs2) {
        int j;
        if (objs1 == objs2) {
            return true;
        }
        if (objs1 == null || objs2 == null) {
            return false;
        }
        if (objs1.length != objs2.length) {
            return false;
        }
        int len = objs1.length;
        boolean[] notEquals = new boolean[len];
        for (j = 0; j < len; ++j) {
            notEquals[j] = true;
        }
        for (int i = 0; i < len; ++i) {
            Object obj1 = objs1[i];
            for (j = 0; j < len; ++j) {
                if (!notEquals[j] || !obj1.equals(objs2[j])) continue;
                notEquals[j] = false;
                break;
            }
            if (j != len) continue;
            return false;
        }
        return true;
    }

    public static byte[] objectToBytes(Object s) throws IOException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(bo);
        os.writeObject(s);
        return bo.toByteArray();
    }

    public static Object bytesToObject(byte[] ba) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bi = new ByteArrayInputStream(ba);
        ObjectInputStream is = new ObjectInputStream(bi);
        return is.readObject();
    }
}

