/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util;

public class PathUtil {
    public static final String SPLIT_TEXT = "/";
    public static final String SPLIT_TEXT2 = "//";
    public static final char SPLIT_CHAR = '/';
    public static final String INVALID_CHARS = "\\:*?\"<>|";
    public static final String ROOT = "/";

    private static int prepare(String p) {
        if (p == null) {
            return -1;
        }
        int z = p.length();
        if (z == 0) {
            return -1;
        }
        return z;
    }

    public static final String getFirstPath(String path) {
        int z = PathUtil.prepare(path);
        if (z > 1) {
            int i = path.indexOf(47, 1);
            if (i > 1) {
                return path.substring(0, i);
            }
            if (i == -1) {
                return path.substring(0, z);
            }
        }
        return null;
    }

    public static final String getFirstName(String path) {
        int z = PathUtil.prepare(path);
        if (z > 1) {
            int i = path.indexOf(47, 1);
            if (i > 1) {
                return path.substring(1, i);
            }
            if (i == -1) {
                return path.substring(1, z);
            }
        }
        return null;
    }

    public static final String getParentPath(String path) {
        int z = PathUtil.prepare(path);
        if (z > 1) {
            int i = path.lastIndexOf(47);
            if (i > 1) {
                return path.substring(0, i);
            }
            return "/";
        }
        return null;
    }

    public static final String getLastName(String path) {
        int i;
        int z = PathUtil.prepare(path);
        if (z > 1 && (i = path.lastIndexOf(47)) < z - 1) {
            return path.substring(i + 1, z);
        }
        return null;
    }

    public static final String[] splitPath(String path) {
        if (path == null) {
            return null;
        }
        return path.split("/");
    }

    public static final String makePath(String[] names) {
        if (names == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(names.length * 16);
        int z = names.length;
        for (int i = 0; i < z; ++i) {
            sb.append("/");
            sb.append(names[i]);
        }
        return sb.toString();
    }

    public static final String makeSiblingPath(String path, String sibling) {
        return PathUtil.makeChildPath(PathUtil.getParentPath(path), sibling);
    }

    public static final String makeChildPath(String child) {
        return PathUtil.makeChildPath("/", child);
    }

    public static final String makeChildPath(String parent, int len, String child) {
        if (parent.charAt(len - 1) == '/') {
            if (child == null || child.length() == 0) {
                return parent.substring(0, len - 1);
            }
            if (child.charAt(0) == '/') {
                return parent + child.substring(1);
            }
            return parent + child;
        }
        if (child == null || child.length() == 0) {
            return parent;
        }
        if (child.charAt(0) == '/') {
            if (child.length() == 1) {
                return parent;
            }
            return parent + child;
        }
        return parent + "/" + child;
    }

    public static final String makeChildPath(String parent, String child) {
        int z = PathUtil.prepare(parent);
        if (z < 1) {
            return null;
        }
        return PathUtil.makeChildPath(parent, z, child);
    }

    public static final boolean hasInvalidChars(String s) {
        if (s == null) {
            return true;
        }
        int z = s.length();
        for (int i = 1; i < z; ++i) {
            if (INVALID_CHARS.indexOf(s.charAt(i)) == -1) continue;
            return true;
        }
        return false;
    }

    public static final boolean isValidName(String name) {
        if (PathUtil.hasInvalidChars(name)) {
            return false;
        }
        return name.indexOf(47) == -1;
    }

    public static final boolean isValidPath(String path) {
        int z = PathUtil.prepare(path);
        if (z < 1) {
            return false;
        }
        if (z == 1) {
            return true;
        }
        if ('/' == path.charAt(z - 1)) {
            return false;
        }
        if (PathUtil.hasInvalidChars(path)) {
            return false;
        }
        return path.indexOf(SPLIT_TEXT2) == -1;
    }

    public static final String cutFirstName(String path) {
        int second;
        if (path.length() > 2 && (second = path.indexOf("/", 1)) != -1) {
            return path.substring(second);
        }
        return null;
    }
}

