/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util;

import java.awt.Dimension;
import java.awt.Rectangle;

public class ScaleUtil {
    public static final int NORMAL = 0;
    public static final int FILL = 1;
    public static final int TILE = 2;
    public static final int FIT = 3;
    public static final int FIT_X = 4;
    public static final int FIT_Y = 5;
    public static final int FILL_X = 6;
    public static final int FILL_Y = 7;
    public static String[] scales = new String[]{"", "fill", "tile", "fit", "fitx", "fity", "fillx", "filly"};

    public static boolean isValid(int scale) {
        return scale >= 0 && scale < scales.length;
    }

    public static String toScaleName(int scale) {
        assert (ScaleUtil.isValid(scale));
        return scales[scale];
    }

    public static int toScaleEnum(String name) {
        if (name != null) {
            for (int i = 0; i < scales.length; ++i) {
                if (!scales[i].equals(name)) continue;
                return i;
            }
        }
        return 0;
    }

    public static double makeScale(int mode, Dimension size, Rectangle clip) {
        double zoom = 1.0;
        switch (mode) {
            case 1: {
                size.width = clip.width;
                size.height = clip.height;
                break;
            }
            case 3: {
                if (clip.width / clip.height < size.width / size.height) {
                    zoom = (double)clip.width / (double)size.width;
                    size.height = new Double((double)size.height * zoom).intValue();
                    size.width = clip.width;
                    break;
                }
                zoom = (double)clip.height / (double)size.height;
                size.width = new Double((double)size.width * zoom).intValue();
                size.height = clip.height;
                break;
            }
            case 4: {
                zoom = (double)clip.width / (double)size.width;
                size.height = new Double((double)size.height * zoom).intValue();
                size.width = clip.width;
                break;
            }
            case 5: {
                zoom = (double)clip.height / (double)size.height;
                size.width = new Double((double)size.width * zoom).intValue();
                size.height = clip.height;
                break;
            }
            case 6: {
                size.width = clip.width;
                break;
            }
            case 7: {
                size.height = clip.height;
            }
        }
        return zoom;
    }
}

