/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util.list;

import com.kingdee.bos.ctrl.common.util.list.Block;
import java.util.ArrayList;

public class BlockTable {
    private boolean fixedSize;
    private int currentUsage;
    private int maxCapacity;
    private ArrayList blocks;
    private int objectsCount;

    final boolean isFxiedOjbectSize() {
        return this.fixedSize;
    }

    public void clear() {
        this.blocks.clear();
        this.currentUsage = 0;
        this.objectsCount = 0;
    }

    public int maxCapacity() {
        return this.maxCapacity;
    }

    BlockTable(int capacity, boolean b) {
        this.maxCapacity = capacity;
        this.blocks = new ArrayList(50);
        this.currentUsage = 0;
        this.fixedSize = b;
        this.objectsCount = 0;
    }

    Block locate(int logicalIndex) {
        if (logicalIndex < 0 || logicalIndex >= this.objectsCount) {
            throw new IndexOutOfBoundsException();
        }
        int count = this.blocks.size();
        for (int i = 0; i < count; ++i) {
            Block blk = (Block)this.blocks.get(i);
            if (!blk.has(logicalIndex)) continue;
            return blk;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Block balloc(int logicalIndex, int objsCount, int size, boolean atTail, boolean onlyTest) {
        int i;
        if (logicalIndex > this.objectsCount) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isFxiedOjbectSize()) {
            size = objsCount;
        }
        if (this.maxCapacity != -1 && this.currentUsage + size > this.maxCapacity) {
            return null;
        }
        Block choice = null;
        Block tmp = null;
        Block prevAllocatedBlk = null;
        int count = this.blocks.size();
        int index = -1;
        int splitIndex = -1;
        int fragment = 0;
        boolean bestChoice = false;
        if (atTail) {
            if (count > 0) {
                tmp = (Block)this.blocks.get(count - 1);
                if (tmp.isIdleBlock()) {
                    if (count > 1) {
                        prevAllocatedBlk = (Block)this.blocks.get(count - 2);
                        if (prevAllocatedBlk.tailIndex() == logicalIndex - 1) {
                            bestChoice = true;
                        } else {
                            prevAllocatedBlk = null;
                        }
                    }
                } else {
                    prevAllocatedBlk = tmp;
                }
            }
        } else {
            for (i = 0; i < count; ++i) {
                tmp = (Block)this.blocks.get(i);
                if (tmp.startIndex() == -1) {
                    if (tmp.blockSize() >= size) {
                        index = i;
                        choice = tmp;
                        if (prevAllocatedBlk != null && prevAllocatedBlk.tailIndex() + 1 == logicalIndex) {
                            bestChoice = true;
                            break;
                        }
                    } else {
                        fragment += tmp.blockSize();
                    }
                    prevAllocatedBlk = null;
                    continue;
                }
                if (choice != null && index == i - 1 && tmp.startIndex() == logicalIndex) {
                    bestChoice = true;
                    break;
                }
                prevAllocatedBlk = tmp;
            }
        }
        if (choice == null) {
            if (this.maxCapacity != -1 && fragment + this.currentUsage + size > this.maxCapacity) return null;
            if (prevAllocatedBlk != null || tmp == null) {
                int newBlock_position = tmp == null ? 0 : prevAllocatedBlk.startPosition() + prevAllocatedBlk.blockSize();
                choice = new Block(this, newBlock_position, size);
                if (onlyTest) {
                    return choice;
                }
                this.blocks.add(choice);
                index = count;
                if (prevAllocatedBlk != null && prevAllocatedBlk.indexSequential(logicalIndex)) {
                    bestChoice = true;
                }
                ++count;
            } else if (tmp != null) {
                if (onlyTest) {
                    return tmp;
                }
                tmp.increaseSize(size - tmp.blockSize());
                choice = tmp;
                index = count - 1;
            }
        } else if (onlyTest) {
            return choice;
        }
        if (logicalIndex <= this.objectsCount) {
            for (i = 0; i < count; ++i) {
                tmp = (Block)this.blocks.get(i);
                if (tmp.startIndex() == -1 || tmp.tailIndex() < logicalIndex) continue;
                if (tmp.startIndex() < logicalIndex) {
                    splitIndex = i;
                    continue;
                }
                tmp.offsetStartIndex(objsCount);
            }
        }
        if (splitIndex != -1) {
            if (splitIndex < index) {
                ++index;
            }
            Block[] splits = ((Block)this.blocks.get(splitIndex)).splits(logicalIndex);
            this.blocks.set(splitIndex, splits[0]);
            splits[1].offsetStartIndex(objsCount);
            if (splitIndex == count - 1) {
                this.blocks.add(splits[1]);
            } else {
                this.blocks.add(splitIndex + 1, splits[1]);
            }
        }
        if (bestChoice) {
            if (prevAllocatedBlk != null) {
                prevAllocatedBlk.addObjects(size, objsCount);
                if (choice.blockSize() != size) {
                    choice.cutFront(size);
                } else {
                    this.blocks.remove(index);
                }
                choice = prevAllocatedBlk;
                if (index >= 0 && index < this.blocks.size() && choice.unit((Block)this.blocks.get(index))) {
                    this.blocks.remove(index);
                }
            } else {
                Block nextAllocatedBlk = (Block)this.blocks.get(index + 1);
                Block frontBlk = choice.cutFrontAsBlock(choice.blockSize() - size);
                if (frontBlk == choice || frontBlk == null) {
                    this.blocks.remove(index);
                    --index;
                } else {
                    this.blocks.set(index, frontBlk);
                }
                choice.setAllocated(logicalIndex, objsCount);
                choice.unit(nextAllocatedBlk);
                this.blocks.set(index + 1, choice);
            }
        } else {
            tmp = choice.cutFrontAsBlock(size);
            tmp.setAllocated(logicalIndex, objsCount);
            if (tmp != choice) {
                this.blocks.add(index, tmp);
            }
            choice = tmp;
        }
        choice.setObjectSize(logicalIndex, size);
        this.currentUsage += size;
        this.objectsCount += objsCount;
        return choice;
    }

    void freeBlock(Block blk, int logicalIndex, int objsCount) {
        int to;
        int i;
        int count = this.blocks.size();
        int index = -1;
        Block[] splits = null;
        for (i = 0; i < count; ++i) {
            Block tmp = (Block)this.blocks.get(i);
            if (tmp.startIndex() == -1) continue;
            if (blk.startIndex() == tmp.startIndex()) {
                splits = blk.freeObjects(logicalIndex, objsCount);
                index = i;
                continue;
            }
            if (tmp.startIndex() <= blk.tailIndex()) continue;
            tmp.offsetStartIndex(-objsCount);
        }
        int from = index - 1;
        if (splits[0] == null && splits[2] == null) {
            this.blocks.set(index, splits[1]);
            to = index + 1;
        } else if (splits[0] == null) {
            this.blocks.set(index, splits[1]);
            this.blocks.add(index + 1, splits[2]);
            to = index + 2;
        } else {
            this.blocks.set(index, splits[0]);
            this.blocks.add(index + 1, splits[1]);
            if (splits[2] != null) {
                this.blocks.add(index + 2, splits[2]);
            }
            to = index + (splits[2] != null ? 3 : 2);
        }
        for (i = from; i < to; ++i) {
            Block blkTmp1;
            Block blkTmp0;
            if (i < 0 || i >= this.blocks.size() - 1 || !(blkTmp0 = (Block)this.blocks.get(i)).unit(blkTmp1 = (Block)this.blocks.get(i + 1))) continue;
            this.blocks.remove(i + 1);
            --to;
            --i;
        }
        this.objectsCount -= objsCount;
        this.currentUsage -= splits[1].blockSize();
    }

    void freeBlock(Block blk, int logicalIndex) {
        this.freeBlock(blk, logicalIndex, blk.tailIndex() - logicalIndex + 1);
    }

    void freeBlock(Block blk) {
        this.freeBlock(blk, blk.startIndex());
    }

    int getObjectsCount() {
        return this.objectsCount;
    }

    public String toString() {
        return this.blocks.toString();
    }

    public static class FragmentException
    extends Exception {
        private static final long serialVersionUID = 239229760518501763L;
    }
}

