/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.expr;

import com.kingdee.bos.ctrl.kdf.expr.IElement;
import com.kingdee.bos.ctrl.kdf.expr.Variant;

class Element
implements IElement {
    private Object key;
    private String formula;
    private Variant value;
    private long flags;
    private int calcID;
    private static long NEEDCALC = 1L;
    private static long CALCQUEUED = NEEDCALC << 1;

    public Element(Object key, String formula) {
        this.key = key;
        this.formula = formula;
        this.value = Variant.getNewEmptyVariant();
        this.flags = NEEDCALC;
        this.calcID = Integer.MIN_VALUE;
    }

    @Override
    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Element) {
            Element e = (Element)obj;
            return this.key.equals(e.getKey()) && this.formula.equals(e.getFormula());
        }
        return false;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public String getFormula() {
        return this.formula;
    }

    @Override
    public void setFormula(String formula) {
        if (!this.formula.equals(formula)) {
            this.formula = formula;
            this.setNeedCalc(true);
        }
    }

    @Override
    public Variant getData() {
        return this.value;
    }

    @Override
    public void setData(Variant newValue) {
        this.value.setVariant(newValue);
        this.setNeedCalc(false);
    }

    private boolean touchFlag(long flags, long flag) {
        return (flags & flag) != 0L;
    }

    private long setFlag(long flags, long flag, boolean bSet) {
        flags = bSet ? (flags |= flag) : (flags &= flag ^ 0xFFFFFFFFFFFFFFFFL);
        return flags;
    }

    @Override
    public boolean isNeedCalc(int calcID) {
        return this.touchFlag(this.flags, NEEDCALC) || this.calcID != calcID;
    }

    @Override
    public boolean isNeedCalc() {
        return this.touchFlag(this.flags, NEEDCALC);
    }

    @Override
    public void setNeedCalc(boolean needCalc) {
        this.flags = this.setFlag(this.flags, NEEDCALC, needCalc);
    }

    @Override
    public int getCalcID() {
        return this.calcID;
    }

    @Override
    public void setCalcID(int calcID) {
        this.calcID = calcID;
    }

    @Override
    public boolean isQueued() {
        return this.touchFlag(this.flags, CALCQUEUED);
    }

    @Override
    public void setQueued(boolean queued) {
        this.flags = this.setFlag(this.flags, CALCQUEUED, queued);
    }
}

