/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.expr;

import com.kingdee.bos.ctrl.kdf.expr.ExprError;
import com.kingdee.bos.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.bos.ctrl.kdf.expr.VarBase;
import com.kingdee.bos.ctrl.kdf.expr.Variant;

class VarCharacter
extends VarBase {
    VarCharacter() {
    }

    @Override
    protected void add(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        char leftval = ((Character)left.getValue()).charValue();
        if (right.getVt() < 512) {
            char rightval = right.charValue();
            result.setChar((char)(leftval + rightval));
        }
    }

    @Override
    protected void subtract(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        char leftval = ((Character)left.getValue()).charValue();
        if (right.getVt() < 512) {
            char rightval = right.charValue();
            result.setChar((char)(leftval - rightval));
        }
    }

    @Override
    protected void multiply(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        char leftval = ((Character)left.getValue()).charValue();
        if (right.getVt() < 512) {
            char rightval = right.charValue();
            result.setChar((char)(leftval * rightval));
        }
    }

    @Override
    protected void divide(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        char leftval = ((Character)left.getValue()).charValue();
        if (right.getVt() < 512) {
            char rightval = right.charValue();
            if (rightval == '\u0000') {
                ExprError.goError(2L, "\u9664\u6570\u4e3a\u96f6");
            } else {
                result.setChar((char)(leftval / rightval));
            }
        }
    }

    @Override
    protected void mod(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        char leftval = ((Character)left.getValue()).charValue();
        if (right.getVt() < 512) {
            char rightval = right.charValue();
            if (rightval == '\u0000') {
                ExprError.goError(2L, "\u9664\u6570\u4e3a\u96f6");
            } else {
                result.setChar((char)(leftval % rightval));
            }
        }
    }

    @Override
    protected void and(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        char leftval = ((Character)left.getValue()).charValue();
        if (right.getVt() < 512) {
            char rightval = right.charValue();
            result.setChar((char)(leftval & rightval));
        }
    }

    @Override
    protected void or(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        char leftval = ((Character)left.getValue()).charValue();
        if (right.getVt() < 512) {
            char rightval = right.charValue();
            result.setChar((char)(leftval | rightval));
        }
    }

    @Override
    protected void xor(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        char leftval = ((Character)left.getValue()).charValue();
        if (right.getVt() < 512) {
            char rightval = right.charValue();
            result.setChar((char)(leftval ^ rightval));
        }
    }
}

