/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.digitalstyle;

import com.kingdee.bos.ctrl.common.digitalstyle.CompositeFormat;
import com.kingdee.bos.ctrl.common.digitalstyle.DigitDecorateFormat;
import com.kingdee.bos.ctrl.common.digitalstyle.Format;
import com.kingdee.bos.ctrl.common.digitalstyle.FormatParser;
import com.kingdee.bos.ctrl.common.digitalstyle.FormatResult;
import com.kingdee.bos.ctrl.common.digitalstyle.GeneralFormat;
import com.kingdee.bos.ctrl.common.digitalstyle.Node;
import com.kingdee.bos.ctrl.common.digitalstyle.NumberFormat;
import com.kingdee.bos.ctrl.common.digitalstyle.ScienceFormat;
import com.kingdee.bos.ctrl.common.digitalstyle.SimpleFormat;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;

public final class Formats {
    static final Format ERROR_FORMAT = new CompositeFormat();
    static final Format DEFAULT_FORMAT = new CompositeFormat();
    private static final ThreadLocal<Map<String, Format>> FORMATSLOCAL;
    private static IUserFormatParser _userFormater;

    public static boolean isErrorFormat(Format format) {
        return format == ERROR_FORMAT;
    }

    public static boolean isDefaultFormat(Format format) {
        return format == DEFAULT_FORMAT;
    }

    public static void setUserFormatParser(IUserFormatParser userParser) {
        _userFormater = userParser;
    }

    public static synchronized void addFormat(String pattern, Format format) {
        FORMATSLOCAL.get().put(pattern, format);
    }

    public static synchronized Format getFormat(String pattern) {
        Format format = null;
        Format obj = FORMATSLOCAL.get().get(pattern);
        if (null == obj) {
            if (_userFormater != null) {
                format = _userFormater.parse(pattern);
            }
            if (format == null) {
                format = new FormatParser().parse(pattern, true);
            }
            FORMATSLOCAL.get().put(pattern, format);
        } else {
            format = obj;
        }
        return format;
    }

    public static final String getRepeatStrings(FormatResult fr, FontMetrics fm, double stringWidth) {
        String oldStr = fr.getText();
        int repeatIndex = fr.getRepeatCharIndex();
        if (fm == null || stringWidth <= 0.0 || repeatIndex < 0) {
            return oldStr;
        }
        char repeatChar = oldStr.charAt(repeatIndex);
        int oldWidth = fm.stringWidth(oldStr);
        int repeatCharW = fm.charWidth(repeatChar);
        int times = 1;
        while ((double)oldWidth < stringWidth) {
            oldWidth += repeatCharW;
            ++times;
        }
        if (times <= 1) {
            return oldStr;
        }
        StringBuffer sb = new StringBuffer(oldStr);
        for (int i = 0; i < times - 1; ++i) {
            sb.insert(repeatIndex, repeatChar);
        }
        return sb.toString();
    }

    public static final String updateDecimalDigit(Format format, int dd) {
        if (dd == 0) {
            return format.toStringFormat();
        }
        if (format instanceof CompositeFormat) {
            StringBuffer sb = new StringBuffer();
            CompositeFormat cf = (CompositeFormat)format;
            int size = cf.size();
            for (int i = 0; i < size; ++i) {
                sb.append(Formats.updateDecimalDigit(cf.getFormat(i), dd)).append(';');
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        if (format instanceof DigitDecorateFormat) {
            DigitDecorateFormat df = (DigitDecorateFormat)format;
            String lc = "";
            String nc = "";
            if (df._lc != null) {
                lc = df._lc.toString();
            }
            if (df._nc != null) {
                nc = df._nc.toString();
            }
            StringBuffer sb = new StringBuffer();
            sb.append(lc).append(nc);
            return sb.append(Formats.updateDecimalDigit(df.getActualFormat(), dd)).toString();
        }
        if (format instanceof NumberFormat || format instanceof ScienceFormat) {
            SimpleFormat nf = (SimpleFormat)format;
            StringBuffer sb = new StringBuffer();
            String cc = "";
            if (nf._cc != null) {
                cc = nf._cc.toString();
            }
            sb.append(cc);
            boolean ise = nf instanceof ScienceFormat;
            int ei = Integer.MAX_VALUE;
            if (ise) {
                ei = ((ScienceFormat)nf)._scienceIndex;
            }
            ArrayList nodes = nf._nodes;
            int size = nodes.size();
            if (dd > 0) {
                int di = -1;
                int lstpi = -1;
                for (int i = 0; i < size; ++i) {
                    Node nd = (Node)nodes.get(i);
                    sb.append(nd.toString());
                    if (nd.getType() == 3) {
                        for (int j = 0; j < dd; ++j) {
                            sb.append('0');
                        }
                        di = i;
                    }
                    if (!nd.isNumber()) continue;
                    lstpi = sb.length() - 1;
                }
                if (di == -1 && lstpi >= 0) {
                    char[] cs = new char[dd + 1];
                    cs[0] = 46;
                    for (int j = 0; j < dd; ++j) {
                        cs[j + 1] = 48;
                    }
                    sb.insert(lstpi + 1, cs);
                }
            } else {
                int si = Integer.MAX_VALUE;
                int pi = -1;
                int remain = 0;
                for (int i = 0; i < size; ++i) {
                    Node nd = (Node)nodes.get(i);
                    if (nd.getType() == 3) {
                        si = i;
                        pi = sb.length();
                    }
                    if (si < i && nd.isNumber() && i < ei) {
                        if (dd < 0) {
                            ++dd;
                            continue;
                        }
                        ++remain;
                        sb.append(nd.toString());
                        continue;
                    }
                    sb.append(nd.toString());
                }
                if (remain == 0 && pi >= 0) {
                    sb.deleteCharAt(pi);
                }
            }
            return sb.toString();
        }
        return format.toStringFormat();
    }

    static {
        ((CompositeFormat)DEFAULT_FORMAT).addFormat(GeneralFormat.defaultInstance);
        FORMATSLOCAL = new ThreadLocal<Map<String, Format>>(){

            @Override
            protected Map<String, Format> initialValue() {
                return new WeakHashMap<String, Format>();
            }
        };
    }

    public static interface IUserFormatParser {
        public Format parse(String var1);
    }
}

