/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui.dragdrop;

import com.kingdee.bos.ctrl.common.ui.dragdrop.IDragDropAssistant;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.TransferHandler;

public class DragDropCopyObjHelper {
    public static void bind(JComponent ctrlFrom, JComponent ctrlTo, IDragDropAssistant assistant) {
        if (ctrlFrom instanceof JList) {
            ((JList)ctrlFrom).setDragEnabled(true);
        } else if (ctrlFrom instanceof JTree) {
            ((JTree)ctrlFrom).setDragEnabled(true);
        } else {
            throw new IllegalArgumentException("Only JList/JTree supported.");
        }
        ObjectTransferHandler oth = new ObjectTransferHandler(assistant);
        ctrlFrom.setTransferHandler(oth);
        ctrlTo.setDropTarget(new DropTarget(ctrlTo, 1, new DropHandler(assistant)));
    }

    static class DropHandler
    extends DropTargetAdapter {
        private IDragDropAssistant assistant;

        public DropHandler(IDragDropAssistant assistant) {
            this.assistant = assistant;
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            DropTarget dt = dtde.getDropTargetContext().getDropTarget();
            dtde.acceptDrop(dt.getDefaultActions());
            Transferable tf = dtde.getTransferable();
            Object obj = null;
            try {
                obj = tf.getTransferData(tf.getTransferDataFlavors()[0]);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.assistant != null) {
                this.assistant.onDrop((JComponent)dt.getComponent(), obj, dtde.getLocation());
            }
            dtde.dropComplete(true);
        }
    }

    static class ObjectTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -9033689713220996026L;
        private IDragDropAssistant assistant;

        public ObjectTransferHandler(IDragDropAssistant assistant) {
            this.assistant = assistant;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (this.assistant != null) {
                Object obj = this.assistant.onDrag(c);
                return new CustomTransferable(obj);
            }
            return null;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        class CustomTransferable
        implements Transferable {
            private Object obj;
            private DataFlavor df;

            public CustomTransferable(Object obj) {
                this.obj = obj;
                this.init();
            }

            private void init() {
                try {
                    this.df = new DataFlavor("application/x-java-jvm-local-objectref");
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{this.df};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor.equals(this.df);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                return this.obj;
            }
        }
    }
}

