/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui.editor;

import com.kingdee.bos.ctrl.common.ui.editor.EditorStyleModel;
import com.kingdee.bos.ctrl.common.ui.editor.Lexer;
import com.kingdee.bos.ctrl.common.ui.editor.MatchedToken;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class DefaultEditorStyleModel
implements EditorStyleModel {
    public static Font normal_font = new Font("\u5b8b\u4f53", 0, 13);
    public static Font font_larger = new Font(normal_font.getName(), normal_font.getStyle(), normal_font.getSize() + 2);
    private List list = new ArrayList();
    private Map map = new HashMap();
    protected SimpleAttributeSet defaultAttr = null;
    protected SimpleAttributeSet singleLineCommentAttr = null;
    protected SimpleAttributeSet multiLineCommentAttr = null;
    protected Font font = font_larger;

    public DefaultEditorStyleModel() {
        this.defaultAttr = this.createSimpleAttributeSet(Color.BLACK);
        this.singleLineCommentAttr = this.createSimpleAttributeSet(new Color(0, 136, 136));
        this.multiLineCommentAttr = this.createSimpleAttributeSet(Color.BLUE.darker());
    }

    public boolean isIgnoreCase() {
        return true;
    }

    public void addStyle(Set keySet, SimpleAttributeSet attr) {
        if (keySet == null) {
            return;
        }
        HashSet<String> newSet = new HashSet<String>();
        for (Object key : keySet) {
            if (!(key instanceof String)) continue;
            newSet.add(this.isIgnoreCase() ? ((String)key).toLowerCase() : (String)key);
        }
        if (newSet.size() > 0) {
            this.list.add(newSet);
            this.map.put(newSet, attr);
        }
    }

    public void addStyle(MatchedToken mt, SimpleAttributeSet attr) {
        this.list.add(mt);
        this.map.put(mt, attr);
    }

    public void addStyle(String[] keys, SimpleAttributeSet attr) {
        HashSet<String> s = new HashSet<String>();
        int n = keys.length;
        for (int i = 0; i < n; ++i) {
            s.add(this.isIgnoreCase() ? keys[i].toLowerCase() : keys[i]);
        }
        this.list.add(s);
        this.map.put(s, attr);
    }

    public void removeStyle(MatchedToken mt) {
        this.list.remove(mt);
        this.map.remove(mt);
    }

    public void removeStyle(String[] keys) {
        HashSet<String> r = new HashSet<String>();
        int n = keys.length;
        for (int i = 0; i < n; ++i) {
            r.add(this.isIgnoreCase() ? keys[i].toLowerCase() : keys[i]);
        }
        Set s = null;
        int i = 0;
        while (i < this.list.size()) {
            Object obj = this.list.get(i);
            if (obj instanceof MatchedToken) {
                ++i;
                continue;
            }
            s = (Set)obj;
            s.removeAll(r);
            if (s.size() == 0) {
                this.list.remove(s);
                this.map.remove(s);
                continue;
            }
            ++i;
        }
    }

    public void clearStyle() {
        this.list.clear();
        this.map.clear();
    }

    @Override
    public SimpleAttributeSet getSingleLineCommentAttributeSet() {
        return this.singleLineCommentAttr;
    }

    @Override
    public SimpleAttributeSet getMultiLineCommentAttributeSet() {
        return this.multiLineCommentAttr;
    }

    @Override
    public SimpleAttributeSet getAttributeSet(String token) {
        if (this.isIgnoreCase()) {
            token = token.toLowerCase();
        }
        Object s = null;
        for (int i = this.list.size() - 1; i >= 0; --i) {
            Object obj = this.list.get(i);
            if (obj instanceof MatchedToken) {
                MatchedToken mt = (MatchedToken)obj;
                if (!mt.match(token)) continue;
                return (SimpleAttributeSet)this.map.get(obj);
            }
            if (obj instanceof Set) {
                if (!((Set)obj).contains(token)) continue;
                return (SimpleAttributeSet)this.map.get(obj);
            }
            return (SimpleAttributeSet)this.map.get(s);
        }
        return this.getDefaultAttributeSet();
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public String[] getWrapLineKeys() {
        return null;
    }

    protected SimpleAttributeSet getDefaultAttributeSet() {
        return this.defaultAttr;
    }

    public SimpleAttributeSet createSimpleAttributeSet(Color c) {
        return this.createSimpleAttributeSet(c, false);
    }

    public SimpleAttributeSet createSimpleAttributeSet(Color c, boolean bold) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attr, this.getFont().getFamily());
        StyleConstants.setFontSize(attr, this.getFont().getSize());
        StyleConstants.setForeground(attr, c);
        StyleConstants.setBold(attr, bold);
        return attr;
    }

    @Override
    public void beforeRun(Lexer lex) {
    }
}

