/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui.restree;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.restype.def.ActionDef;
import com.kingdee.bos.ctrl.common.restype.def.ResTypeDef;
import com.kingdee.bos.ctrl.common.restype.def.ResTypeDefs;
import com.kingdee.bos.ctrl.common.restype.def.ResTypeSystem;
import com.kingdee.bos.ctrl.common.restype.def.ResTypeTree;
import com.kingdee.bos.ctrl.common.restype.spi.IResActionHandler;
import com.kingdee.bos.ctrl.common.restype.spi.IResObject;
import com.kingdee.bos.ctrl.common.ui.restree.ItemsHelper;
import com.kingdee.bos.ctrl.common.ui.restree.ResNodeAction;
import com.kingdee.bos.ctrl.common.ui.restree.ResNodesAction;
import com.kingdee.bos.ctrl.common.ui.restree.ResObjectNode;
import com.kingdee.bos.ctrl.common.ui.tree.ATreeAction;
import com.kingdee.bos.ctrl.common.ui.tree.ATreeController;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUI;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDMenu;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ResTreeController
extends ATreeController {
    public static final Logger log = LogUtil.getPackageLogger(ResTreeController.class);
    private ResTypeSystem typeSystem;

    public ResTreeController(ResTypeDefs defs) {
        this.typeSystem = new ResTypeSystem(defs);
    }

    private void makeMenu(ArrayList rawItems, Object parent, ResTypeDef runtimeType, ResObjectNode resNode) {
        ResTypeDef staticTypeDef = resNode.getStaticResType();
        String path = (String)staticTypeDef.sortProperty("multilanguagePackage");
        if (parent instanceof KDMenu) {
            KDMenu menu = (KDMenu)parent;
            ArrayList subMenuItems = new ArrayList();
            this.makeMenu(rawItems, subMenuItems, runtimeType, resNode);
            for (Object item : subMenuItems) {
                if (item instanceof ResNodeAction) {
                    menu.add((Action)((ResNodeAction)item));
                    continue;
                }
                if (item instanceof JSeparator) {
                    menu.add((Component)((JSeparator)item));
                    continue;
                }
                if (!(item instanceof KDMenu)) continue;
                menu.add((JMenuItem)((KDMenu)item));
            }
        } else {
            ArrayList menuItems = (ArrayList)parent;
            for (Object item : rawItems) {
                if (item instanceof ArrayList) {
                    ArrayList subItems = (ArrayList)item;
                    KDMenu subMenu = new KDMenu((String)subItems.remove(0));
                    this.makeMenu(subItems, subMenu, runtimeType, resNode);
                    menuItems.add(subMenu);
                    continue;
                }
                if (item instanceof ActionDef) {
                    ResNodeAction action = new ResNodeAction(this, (ActionDef)item, resNode);
                    menuItems.add(action);
                    this.setMultiLanguage(action, path);
                    Icon iconObject = ItemsHelper.loadIcon(((ActionDef)item).getProperty("display-icon"), runtimeType);
                    action.putValue("SmallIcon", iconObject);
                    continue;
                }
                menuItems.add(item);
            }
        }
    }

    public ArrayList getSingleObjectPopMenuActions(ResObjectNode resNode) {
        ResTypeTree typeTree = resNode.getTypeTree();
        ResTypeDef staticTypeDef = resNode.getStaticResType();
        String menuItems = null;
        while (staticTypeDef != null && (menuItems = (String)staticTypeDef.getProperty("menu-items")) == null && staticTypeDef.isSingleInhirt() && this.typeSystem.getTypeTree(staticTypeDef).getRuntimeResType().noAction()) {
            staticTypeDef = (ResTypeDef)staticTypeDef.getExtendTypes().get(0);
        }
        ArrayList rawItems = ItemsHelper.trimMenuItems(menuItems, typeTree);
        ArrayList list = new ArrayList();
        this.makeMenu(rawItems, list, typeTree.getRuntimeResType(), resNode);
        return list;
    }

    protected ArrayList getMultiObjectsPopMenuActions(ResObjectNode[] resObjects) {
        ResTypeDef[] typeDefs = new ResTypeDef[resObjects.length];
        ResTypeTree[] typeTrees = new ResTypeTree[typeDefs.length];
        for (int i = 0; i < resObjects.length; ++i) {
            typeDefs[i] = resObjects[i].getStaticResType();
            typeTrees[i] = resObjects[i].getTypeTree();
        }
        ResTypeDef commonType = this.typeSystem.getCommonType(typeDefs);
        ResTypeTree commonTypeTree = this.typeSystem.getTypeTree(commonType);
        String path = (String)commonType.sortProperty("multilanguagePackage");
        ArrayList<Serializable> actions = new ArrayList<Serializable>();
        ResTypeDefs runtimeTypeDefs = commonTypeTree.getRuntimeResTypes();
        for (ResTypeDef part_TypeDef : runtimeTypeDefs) {
            if (part_TypeDef.getActionDefs() == null) continue;
            for (ActionDef actionDef : part_TypeDef.getActionDefs()) {
                ActionDef[] actionDefs = new ActionDef[typeDefs.length];
                for (int i = 0; i < actionDefs.length; ++i) {
                    actionDefs[i] = typeTrees[i].findAction(actionDef.getName());
                }
                ResNodesAction tempAction = new ResNodesAction(this, actionDefs, resObjects);
                this.setMultiLanguage(tempAction, path);
                tempAction.putValue("SmallIcon", ItemsHelper.loadIcon(actionDef.getProperty("display-icon"), commonTypeTree.getRuntimeResType()));
                actions.add(tempAction);
            }
            actions.add(new JSeparator());
        }
        boolean has_useless_action = true;
        block6: while (has_useless_action) {
            has_useless_action = false;
            for (int i = 0; i < actions.size(); ++i) {
                try {
                    ResNodesAction action = (ResNodesAction)actions.get(i);
                    if (action.isVisible(null)) continue;
                    has_useless_action = true;
                    actions.remove(i);
                    continue block6;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        return actions;
    }

    private void setMultiLanguage(ATreeAction action, String path) {
        Object tooltips;
        String keyName = (String)action.getValue("Name");
        if (!StringUtil.isEmptyString((String)(keyName = this.getMultiLanguage(keyName, path, "display-label.")))) {
            action.putValue("Name", keyName);
        }
        if ((tooltips = action.getValue("ShortDescription")) != null) {
            String keyTooltips = this.getMultiLanguage((String)tooltips, path, "toolTips.");
            if (!StringUtil.isEmptyString((String)keyTooltips)) {
                action.putValue("ShortDescription", keyTooltips);
            }
        } else {
            action.putValue("ShortDescription", keyName);
        }
    }

    private String getMultiLanguage(String key, String path, String tyep) {
        if (!StringUtil.isEmptyString((String)key) && key.startsWith("#key:")) {
            key = key.substring(5);
            if (!StringUtil.isEmptyString((String)path)) {
                key = LanguageManager.getLangMessage((String)(tyep + key), (String)path, (String)key);
            } else {
                log.info((Object)("key: " + key + "\u7684\u5957\u6253\u7ba1\u7406\u754c\u9762\u83dc\u5355\u591a\u8bed\u8a00\u8def\u5f84\u4fe1\u606f\u672a\u627e\u5230\uff01"));
            }
        }
        return key;
    }

    @Override
    public ArrayList getPopMenuActions() {
        TreePath[] treePathes = this.getTreeUI().getTree().getSelectionPaths();
        if (treePathes.length == 1) {
            return this.getSingleObjectPopMenuActions((ResObjectNode)this.getTreeUI().getSelectionNode());
        }
        ResObjectNode[] resObjects = new ResObjectNode[treePathes.length];
        for (int i = 0; i < resObjects.length; ++i) {
            resObjects[i] = (ResObjectNode)((Object)treePathes[i].getLastPathComponent());
        }
        return this.getMultiObjectsPopMenuActions(resObjects);
    }

    protected void initResNode(ResObjectNode resNode) throws Exception {
        if (!resNode.getAllowsChildren() || !resNode.isChildrenLoaded()) {
            ActionDef defaultActionDef = resNode.getTypeTree().getDefaultAction();
            if (defaultActionDef != null) {
                IResActionHandler handler = ResNodeAction.createResActionHandler(defaultActionDef);
                handler.handle(defaultActionDef, (IResObject)resNode, null, true);
            } else {
                log.info((Object)"\u672a\u6307\u5b9adefault action.");
            }
            resNode.setChildrenLoaded(true);
        }
    }

    @Override
    protected boolean initNode(TreePath treePath) throws Exception {
        ResObjectNode resNode = (ResObjectNode)((Object)treePath.getLastPathComponent());
        this.initResNode(resNode);
        return true;
    }

    private Icon loadResTypeIcon(ResTypeDef staticType) {
        ResTypeTree typeTree = this.typeSystem.getTypeTree(staticType);
        ResTypeDef runtimeTypeDef = typeTree.getRuntimeResType();
        String displayIcon = (String)runtimeTypeDef.getProperty("display-icon");
        if (displayIcon == null) {
            return null;
        }
        return ItemsHelper.loadIcon(displayIcon, runtimeTypeDef);
    }

    @Override
    public TreeUINode newTreeNode(Object category, String name, String alias, boolean allowsChildren) {
        ResObjectNode node = new ResObjectNode(name, (ResTypeDef)category);
        node.setAlias(alias);
        node.setAllowsChildren(allowsChildren);
        node.setCustomIcon(this.loadResTypeIcon((ResTypeDef)category));
        return node;
    }

    public TreeUINode newTreeNode(String resTypeName, String name, String alias) throws Exception {
        ResTypeDef staticResType = this.typeSystem.findType(resTypeName);
        if (staticResType == null) {
            throw new Exception("Couldn't found ResType:" + resTypeName);
        }
        return this.newTreeNode(staticResType, name, alias);
    }

    private TreeUINode newTreeNode(ResTypeDef staticResType, String name, String alias) {
        boolean allowsChildren = true;
        ResTypeTree typeTree = this.typeSystem.getTypeTree(staticResType);
        ResTypeDef typeDef = typeTree.getRuntimeResType();
        allowsChildren = !"false".equals(typeDef.getProperty("expand-able"));
        ResObjectNode node = (ResObjectNode)this.newTreeNode(staticResType, name, alias, allowsChildren);
        node.setTypeTree(typeTree);
        node.setHook(this);
        return node;
    }

    protected TreeUINode createRootNode(String name, String alias) {
        try {
            return this.newTreeNode("ROOT", "/", "ROOT-Alias");
        }
        catch (Exception ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
    }

    @Override
    public void initTreeUI(TreeUI treeUI) {
        TreeUINode node = this.createRootNode("/", "ROOT-Alias");
        treeUI.setRootNode(node);
        treeUI.setRealtimeSelect(true);
        this.bindTreeUI(treeUI, node);
        treeUI.disableUndoRedoButtons();
    }

    public ResTypeSystem getTypeSystem() {
        return this.typeSystem;
    }
}

