/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui.stepwizard;

import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.resource.ResourceManager;
import com.kingdee.bos.ctrl.common.ui.stepwizard.IWizardStep;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;

public class WizardDialog
extends KDDialog {
    private static final long serialVersionUID = 2906879923285143136L;
    protected KDLabel labPic = new KDLabel();
    protected KDButton btnCancel;
    protected KDButton btnFinish;
    protected KDButton btnPrev;
    protected KDButton btnNext;
    protected KDPanel panContent;
    private String titleStr;
    private boolean isShowCount;
    private List steps;
    private IWizardStep currentStep;
    private StepsManager stepsManager;
    private HashMap mapIsStepInited;
    private boolean isSingle = false;
    private boolean isFinished;

    public WizardDialog() {
        this.init();
    }

    public WizardDialog(Frame owner) {
        super(owner);
        this.init();
    }

    public WizardDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    public WizardDialog(Frame owner, boolean model) {
        super(owner, model);
        this.init();
    }

    public WizardDialog(Dialog owner, boolean model) {
        super(owner, model);
        this.init();
    }

    public void setBigSize(boolean isBig) {
        if (isBig) {
            this.setSize(566, 428);
            this.labPic.setIcon((Icon)ResourceManager.getIcon("guide_pic338.png"));
        } else {
            this.setSize(486, 350);
            this.labPic.setIcon((Icon)ResourceManager.getIcon("guide_pic260.png"));
        }
        this.validate();
    }

    public void hidePicture() {
        TableLayout ly = (TableLayout)this.getContentPane().getLayout();
        ly.cell(0).getSubTable().colStyle(1).setMarginLeft(0);
        this.labPic.setIcon(null);
        this.validate();
    }

    private void init() {
        this.setResizable(false);
        this.setBigSize(false);
        this.setLocationRelativeTo(null);
        this.initComponent();
        this.initListener();
        this.stepsManager = new StepsManager(this);
    }

    protected void initComponent() {
        this.btnCancel = new KDButton(WizardDialog.getMLS("cancel", "\u53d6\u6d88"));
        this.btnFinish = new KDButton(WizardDialog.getMLS("finish", "\u5b8c\u6210"));
        this.btnPrev = new KDButton(WizardDialog.getMLS("prevStep", "\u4e0a\u4e00\u6b65"));
        this.btnNext = new KDButton(WizardDialog.getMLS("nextStep", "\u4e0b\u4e00\u6b65"));
        this.panContent = new KDPanel();
        this.panContent.setOpaque(false);
        this.panContent.setLayout((LayoutManager)new BorderLayout());
        this.btnCancel.setMargin(new Insets(0, 0, 0, 0));
        this.btnFinish.setMargin(new Insets(0, 0, 0, 0));
        this.btnPrev.setMargin(new Insets(0, 0, 0, 0));
        this.btnNext.setMargin(new Insets(0, 0, 0, 0));
        TableLayout layout = TableLayout.splitRow((int)3);
        layout.rowStyle(0).setPriY(1);
        layout.rowStyle(1).setHeight(2);
        layout.rowStyle(2).setHeight(21);
        layout.rowStyle(0).setMargin(10);
        layout.rowStyle(2).setMargin(10);
        Table tbTop = layout.cell(0).splitCol(2);
        Table tbBtm = layout.cell(2).splitCol(6);
        tbTop.colStyle(1).setPriX(1);
        tbTop.colStyle(1).setMarginLeft(8);
        tbBtm.colStyle(0).setWidth(73);
        tbBtm.colStyle(1).setPriX(1);
        tbBtm.colStyle(2).setWidth(73);
        tbBtm.colStyle(3).setMarginLeft(3);
        tbBtm.colStyle(3).setWidth(73);
        tbBtm.colStyle(4).setMarginLeft(3);
        tbBtm.colStyle(4).setWidth(73);
        tbBtm.colStyle(5).setMarginLeft(3);
        tbBtm.colStyle(5).setWidth(73);
        this.getContentPane().setLayout((LayoutManager)layout);
        this.getContentPane().add((Component)this.labPic, tbTop.cell(0));
        this.getContentPane().add((Component)this.panContent, tbTop.cell(1));
        this.getContentPane().add((Component)new KDSeparator(), layout.cell(1));
        this.getContentPane().add((Component)this.btnCancel, tbBtm.cell(2));
        this.getContentPane().add((Component)this.btnPrev, tbBtm.cell(3));
        this.getContentPane().add((Component)this.btnNext, tbBtm.cell(4));
        this.getContentPane().add((Component)this.btnFinish, tbBtm.cell(5));
    }

    protected void initListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WizardDialog.this.quit(false);
            }
        });
        this.btnFinish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WizardDialog.this.doNextStep(true)) {
                    WizardDialog.this.quit(true);
                }
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.quit(false);
            }
        });
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.doNextStep(false);
            }
        });
        this.btnPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog.this.doPreviousStep();
            }
        });
    }

    private void quit(boolean isFinished) {
        this.isFinished = isFinished;
        for (IWizardStep step : this.getStepsList()) {
            step.destroy(isFinished);
        }
        if (this.isSingle) {
            System.exit(0);
        } else {
            this.dispose();
        }
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public void show() {
        this.intoStep(this.currentStep, null, false);
        super.show();
    }

    public void showAsSingle() {
        this.isSingle = true;
        this.show();
    }

    private void intoStep(IWizardStep step, IWizardStep prev, boolean isOppose) {
        if (step == null) {
            return;
        }
        if (this.getMapIsStepInited().get(step) == null) {
            step.initStep(this.stepsManager);
            this.getMapIsStepInited().put(step, Boolean.TRUE);
        }
        this.panContent.removeAll();
        this.panContent.add((Component)step.getContent(), (Object)"Center");
        this.panContent.validate();
        this.panContent.repaint();
        this.showTitle(step);
        this.getNextStepButton().setEnabled(this.defaultNectStepEnabled());
        this.getPrevStepButton().setEnabled(this.defaultPrevStepEnabled());
        step.intoThisStep(prev, isOppose);
    }

    private boolean doNextStep(boolean isFromFinish) {
        IWizardStep next = this.currentStep.outThisStep(false);
        if (next == this.currentStep) {
            return false;
        }
        if (isFromFinish) {
            return true;
        }
        if (next == null) {
            try {
                next = this.getNextStepInList(this.currentStep);
            }
            catch (WizardDialogException e) {
                e.printStackTrace();
                return false;
            }
        } else {
            this.addNewStepIntoList(this.currentStep, next);
        }
        IWizardStep temp = this.currentStep;
        this.currentStep = next;
        this.intoStep(this.currentStep, temp, false);
        return true;
    }

    private void doPreviousStep() {
        IWizardStep prev = this.currentStep.outThisStep(true);
        if (this.currentStep == prev) {
            return;
        }
        try {
            prev = this.getPrevStepInList(this.currentStep);
        }
        catch (WizardDialogException e) {
            e.printStackTrace();
            return;
        }
        IWizardStep temp = this.currentStep;
        this.currentStep = prev;
        this.intoStep(this.currentStep, temp, true);
    }

    private void showTitle(IWizardStep step) {
        if (this.isShowCount) {
            StringBuffer str = new StringBuffer();
            str.append(this.titleStr);
            str.append("_");
            str.append(WizardDialog.getMLS("titlePrompt1", "\u7b2c"));
            str.append(this.getStepsList().indexOf(step) + 1);
            str.append(WizardDialog.getMLS("titlePrompt2", "\u6b65\uff0c\u5171"));
            str.append(this.getStepsList().size());
            str.append(WizardDialog.getMLS("titlePrompt3", "\u6b65"));
            this.setTitle(str.toString());
        }
    }

    public void setTitle(String titleStr, boolean isShowCount) {
        this.titleStr = titleStr;
        this.isShowCount = isShowCount;
        this.setTitle(titleStr);
    }

    private HashMap getMapIsStepInited() {
        if (this.mapIsStepInited == null) {
            this.mapIsStepInited = new HashMap();
        }
        return this.mapIsStepInited;
    }

    public void setStepsList(List steps) {
        this.steps = steps;
        assert (steps.size() != 0);
        this.currentStep = (IWizardStep)steps.get(0);
    }

    public List getStepsList() {
        if (this.steps == null) {
            this.steps = new LinkedList();
        }
        return this.steps;
    }

    public IWizardStep getCurrentStep() {
        return this.currentStep;
    }

    public IWizardStep getNextStepInList(IWizardStep step) throws WizardDialogException {
        int idx = this.getStepsList().indexOf(step);
        if (idx == -1 || idx == this.getStepsList().size() - 1) {
            return null;
        }
        Object next = this.getStepsList().get(idx + 1);
        if (next != null) {
            if (this.getStepsList().get(idx + 1) instanceof IWizardStep) {
                return (IWizardStep)this.getStepsList().get(idx + 1);
            }
            this.typeErr();
        }
        return null;
    }

    public IWizardStep getPrevStepInList(IWizardStep step) throws WizardDialogException {
        int idx = this.getStepsList().indexOf(step);
        if (idx <= 0) {
            return null;
        }
        Object prev = this.getStepsList().get(idx - 1);
        if (prev != null) {
            if (prev instanceof IWizardStep) {
                return (IWizardStep)prev;
            }
            this.typeErr();
        }
        return null;
    }

    private void addNewStepIntoList(IWizardStep step, IWizardStep newNextStep) {
        int idx = this.getStepsList().indexOf(step);
        for (int i = this.getStepsList().size() - 1; i > idx; --i) {
            IWizardStep st = (IWizardStep)this.getStepsList().remove(i);
            this.getMapIsStepInited().remove(st);
        }
        this.getStepsList().add(newNextStep);
    }

    private void typeErr() throws WizardDialogException {
        throw new WizardDialogException("Element in Steps list is not IWizardStep");
    }

    public KDButton getPrevStepButton() {
        return this.btnPrev;
    }

    public KDButton getNextStepButton() {
        return this.btnNext;
    }

    public KDButton getFinishButton() {
        return this.btnFinish;
    }

    public boolean defaultPrevStepEnabled() {
        IWizardStep prev = null;
        try {
            prev = this.getPrevStepInList(this.getCurrentStep());
        }
        catch (WizardDialogException e) {
            e.printStackTrace();
        }
        return prev != null && prev.isReturnable();
    }

    public boolean defaultNectStepEnabled() {
        IWizardStep next = null;
        try {
            next = this.getNextStepInList(this.getCurrentStep());
        }
        catch (WizardDialogException e1) {
            e1.printStackTrace();
        }
        return next != null;
    }

    public boolean defaultFinishEnabled() {
        return true;
    }

    public static String getMLS(String key, String defaultValue) {
        return ResourceManager.getMLS(key, defaultValue);
    }

    public static class StepsManager {
        private WizardDialog dialog;
        private Object userObj;

        public StepsManager(WizardDialog dialog) {
            this.dialog = dialog;
        }

        public Object getUserObject() {
            return this.userObj;
        }

        public void setUserObject(Object obj) {
            this.userObj = obj;
        }

        public IWizardStep getNextStep(IWizardStep step) {
            try {
                return this.dialog.getNextStepInList(step);
            }
            catch (WizardDialogException e) {
                e.printStackTrace();
                return null;
            }
        }

        public IWizardStep getPreviousStep(IWizardStep step) {
            try {
                return this.dialog.getPrevStepInList(step);
            }
            catch (WizardDialogException e) {
                e.printStackTrace();
                return null;
            }
        }

        public void setNextStepEnabled(boolean enabled) {
            this.dialog.getNextStepButton().setEnabled(enabled);
        }

        public boolean isNextStepEnabled() {
            return this.dialog.getNextStepButton().isEnabled();
        }

        public void setPreviousStepEnabled(boolean enabled) {
            if (this.dialog.defaultPrevStepEnabled()) {
                this.dialog.getPrevStepButton().setEnabled(enabled);
                return;
            }
            this.dialog.getPrevStepButton().setEnabled(false);
        }

        public boolean isPreviousStepEnabled() {
            return this.dialog.getPrevStepButton().isEnabled();
        }

        public void setFinishEnabled(boolean enabled) {
            this.dialog.getFinishButton().setEnabled(enabled);
        }

        public boolean isFinishEnabled() {
            return this.dialog.getFinishButton().isEnabled();
        }

        public void setNextStep(IWizardStep nextStep, boolean isOppose) {
            this.dialog.addNewStepIntoList(this.dialog.currentStep, nextStep);
            IWizardStep temp = this.dialog.currentStep;
            this.dialog.currentStep = nextStep;
            this.dialog.intoStep(this.dialog.currentStep, temp, isOppose);
        }

        public KDButton getNextStepButton() {
            return this.dialog.getNextStepButton();
        }

        public KDButton getPrevStepButton() {
            return this.dialog.getPrevStepButton();
        }

        public KDButton getFinishButton() {
            return this.dialog.getFinishButton();
        }

        public WizardDialog getWizardDialog() {
            return this.dialog;
        }
    }

    public static class WizardDialogException
    extends Exception {
        private static final long serialVersionUID = 3553453121639153694L;

        public WizardDialogException() {
        }

        public WizardDialogException(String message) {
            super(message);
        }

        public WizardDialogException(String message, Throwable cause) {
            super(message, cause);
        }

        public WizardDialogException(Throwable cause) {
            super(cause);
        }
    }
}

