/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.render;

import com.kingdee.bos.ctrl.common.util.FontUtil;
import com.kingdee.bos.ctrl.kdf.util.render.TextDetail;
import com.kingdee.bos.ctrl.kdf.util.render.formatparser.HtmlFormatParser;
import com.kingdee.bos.ctrl.kdf.util.render.formatparser.IParser;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import sun.font.FontDesignMetrics;

public class TextRender {
    public static TextRender instance;
    private String source;
    private IParser parser;
    private TextDetail cell = new TextDetail();
    private boolean flagSimple = true;
    private boolean flagStyle = true;
    private Style cellStyle;
    protected boolean isBlackWhite = false;

    public static TextRender sharedInstance() {
        if (instance == null) {
            instance = new TextRender();
        }
        return instance;
    }

    public TextRender() {
        this.parser = new HtmlFormatParser();
        this.cellStyle = Styles.getDefaultStyle();
    }

    public TextRender(String source, Style cellStyle) {
        this();
        this.source = source;
        if (cellStyle == null) {
            throw new IllegalArgumentException("\u4f20\u5165\u7684\u683c\u5f0f\u96c6\u4e0d\u80fd\u4e3anull");
        }
        this.cellStyle = cellStyle;
    }

    public void setBlackWhite(boolean isBlackWhite) {
        this.isBlackWhite = isBlackWhite;
    }

    public boolean isBlackWhite() {
        return this.isBlackWhite;
    }

    public TextRender(String source, Style cellStyle, IParser parser) {
        this(source, cellStyle);
        this.parser = parser;
    }

    public void draw(Graphics g, Shape clip) {
        TextRender.draw(this, g, clip);
    }

    private AttributedString parseStyleToAttributes() {
        if (this.source == null || this.source.length() < 1) {
            return null;
        }
        AttributedString as = new AttributedString(this.source);
        as.addAttribute(TextAttribute.FONT, this.cellStyle.getKDFont().getFont());
        Color fontColor = this.cellStyle.getFontColor();
        if (!this.isBlackWhite() || fontColor.getBlue() == fontColor.getRed() && fontColor.getBlue() == fontColor.getGreen()) {
            as.addAttribute(TextAttribute.FOREGROUND, fontColor);
        } else {
            as.addAttribute(TextAttribute.FOREGROUND, Color.BLACK);
        }
        if (this.cellStyle.isUnderline()) {
            as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (this.cellStyle.isStrikeThrough()) {
            as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        return as;
    }

    public void draw(Graphics g, Shape clip, String source) {
        this.setSource(source);
        this.draw(g, clip);
    }

    public void draw(Graphics g, Shape clip, String source, Style cellStyle) {
        Object f;
        this.setSource(source);
        if (null != cellStyle) {
            this.setCellStyle(cellStyle);
        }
        if (Styles.HorizontalAlignment.LEFT == cellStyle.getHorizontalAlign()) {
            Rectangle rect = clip.getBounds();
            if (cellStyle.getIndentation() > 0) {
                int fontStyle = 0;
                if (cellStyle.isBold()) {
                    ++fontStyle;
                }
                if (cellStyle.isItalic()) {
                    fontStyle += 2;
                }
                f = new Font(cellStyle.getFontName(), fontStyle, cellStyle.getFontSize());
                FontDesignMetrics fm = FontDesignMetrics.getMetrics((Font)f);
                rect.x += ((FontMetrics)fm).charWidth('A') * cellStyle.getIndentation();
            }
            clip = rect;
        }
        Graphics2D g2d = (Graphics2D)g;
        if (cellStyle.isVerticalText() && null != this.getSource() && this.getSource().length() > 0) {
            Rectangle rect = clip.getBounds();
            f = cellStyle.getKDFont();
            g2d.setColor(cellStyle.getFontColor());
            g2d.setFont((Font)f);
            LineMetrics lm = f.getLineMetrics(this.getSource(), g2d.getFontRenderContext());
            FontMetrics fontMetrics = g2d.getFontMetrics((Font)f);
            double fontHeight = lm.getAscent() + lm.getDescent();
            double x = 0.0;
            double y = 0.0;
            Styles.HorizontalAlignment hAlign = cellStyle.getHorizontalAlign();
            if (hAlign == Styles.HorizontalAlignment.CENTER) {
                double clipCenter = rect.getWidth() / 2.0;
                double fontCenter = fontHeight / 2.0;
                x = rect.getX() + clipCenter - fontCenter;
            } else {
                x = hAlign == Styles.HorizontalAlignment.RIGHT ? rect.getX() + rect.getWidth() - 1.0 - fontHeight : rect.getX() + 1.0;
            }
            int sourceHeight = (int)(fontHeight * (double)this.getSource().length());
            Styles.VerticalAlignment vAlign = cellStyle.getVerticalAlign();
            if (vAlign == Styles.VerticalAlignment.TOP) {
                y = rect.getY() + (double)lm.getAscent();
            } else if (vAlign == Styles.VerticalAlignment.BOTTOM) {
                y = rect.getY() + rect.getHeight() - 1.0 - (double)sourceHeight;
            } else {
                double clipCenter = rect.getHeight() / 2.0;
                double fontCenter = (double)sourceHeight / 2.0;
                y = rect.getY() + (clipCenter - fontCenter) + (double)lm.getAscent() - 1.0;
            }
            int length = this.getSource().length();
            for (int i = 0; i < length; ++i) {
                String text = String.valueOf(this.getSource().charAt(i));
                int textWidht = fontMetrics.stringWidth(text);
                g2d.drawString(text, (int)(x + fontHeight / 2.0 - (double)textWidht / 2.0), (int)y);
                y += fontHeight;
            }
        } else {
            this.draw(g2d, clip);
        }
    }

    public void draw(Graphics g, Shape clip, String source, Style cellStyle, IParser parser) {
        this.setSource(source);
        this.setParser(parser);
        this.setCellStyle(cellStyle);
        this.draw(g, clip);
    }

    public IParser getParser() {
        return this.parser;
    }

    public String getSource() {
        return this.source;
    }

    public void setParser(IParser parser) {
        this.parser = parser;
    }

    public Style getCellStyle() {
        return this.cellStyle;
    }

    public void setCellStyle(Style style) {
        if (style == null) {
            throw new IllegalArgumentException("\u4f20\u5165\u7684Style\u53c2\u6570\u4e0d\u80fd\u4e3anull");
        }
        this.cellStyle = style;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public boolean isFlagSimple() {
        return this.flagSimple;
    }

    public void setFlagSimple(boolean b) {
        this.flagSimple = b;
    }

    public boolean isFlagStyle() {
        return this.flagStyle;
    }

    public void setFlagStyle(boolean flagStyle) {
        this.flagStyle = flagStyle;
    }

    private static synchronized void draw(TextRender render, Graphics g, Shape clip) {
        if (render.isFlagSimple()) {
            if (null == render.source || render.source.trim().length() == 0) {
                return;
            }
            if (render.isFlagStyle()) {
                AttributedString as = render.parseStyleToAttributes();
                render.cell.setText(FontUtil.validateFont((AttributedString)as));
            } else {
                render.cell.setSource(render.source);
            }
        } else {
            AttributedString as = render.parser.parse(render.source, render.getCellStyle());
            if (null == as) {
                return;
            }
            render.cell.setText(as);
        }
        render.cell.setCellStyle(render.cellStyle);
        render.cell.draw((Graphics2D)g, clip);
    }
}

