/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.render.layout;

import com.kingdee.bos.ctrl.kdf.util.render.layout.ITextArea;
import com.kingdee.bos.ctrl.kdf.util.render.layout.SureRow;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

class CellTextArea
implements ITextArea {
    static final double E = 0.1;
    protected int rotate;
    protected AffineTransform atSave;
    protected AffineTransform at;
    protected double shrinkRate;
    protected Shape clip;
    protected double clipWidth;
    protected double clipHeight;
    protected double clipY;
    protected double clipX;
    protected double angel;
    protected double rectAngel;
    protected ArrayList rows = new ArrayList();
    protected Style style;

    public CellTextArea(Shape clip, Style style) {
        this(clip, 0, style);
    }

    public CellTextArea(Shape clip, int rotate, Style style) {
        this.setClip(clip);
        this.setRotate(rotate);
        this.setShrinkRate(1.0);
        this.updateVariables();
        this.style = style;
    }

    public double getRectAngel() {
        return this.rectAngel;
    }

    public void setRectAngel(double d) {
        this.rectAngel = d;
    }

    public void addRow(SureRow row) {
        this.rows.add(row);
    }

    public ArrayList getRows() {
        return this.rows;
    }

    public double getShrinkRate() {
        return this.shrinkRate;
    }

    @Override
    public double getLineMaxX(int index) {
        double maxX = 0.0;
        SureRow stl = (SureRow)this.getRows().get(index);
        if (this.angel < -0.1) {
            maxX = stl.getPoint().x + stl.getAdvance() * Math.cos(-this.angel);
            maxX += stl.getDescent() * Math.sin(-this.angel);
        } else if (this.angel > 0.1) {
            maxX = stl.getPoint().x + stl.getAdvance() * Math.cos(this.angel);
            maxX += stl.getAscent() * Math.sin(this.angel);
        } else {
            maxX = stl.getPoint().x + stl.getAdvance();
        }
        return maxX * this.getShrinkRate();
    }

    @Override
    public double getLineMaxY(int index) {
        double maxY = 0.0;
        SureRow stl = (SureRow)this.getRows().get(index);
        if (this.angel > 0.1) {
            maxY = stl.getPoint().y + stl.getAdvance() * Math.sin(this.angel);
            maxY += stl.getDescent() * Math.cos(this.angel);
        } else {
            maxY = this.angel < -0.1 ? stl.getPoint().y + stl.getDescent() * Math.cos(this.angel) : stl.getPoint().y + stl.getDescent();
        }
        return maxY * this.getShrinkRate();
    }

    @Override
    public double getLineMinX(int index) {
        double minX = 0.0;
        SureRow stl = (SureRow)this.getRows().get(index);
        minX = this.angel > 0.1 ? stl.getPoint().x - stl.getDescent() * Math.sin(this.angel) : (this.angel < -0.1 ? stl.getPoint().x - stl.getAscent() * Math.sin(-this.angel) : stl.getPoint().x);
        return minX * this.getShrinkRate();
    }

    @Override
    public double getLineMinY(int index) {
        double minY = 0.0;
        SureRow stl = (SureRow)this.getRows().get(index);
        if (this.angel > 0.1) {
            minY = stl.getPoint().y - stl.getAscent() * Math.cos(this.angel);
        } else if (this.angel < -0.1) {
            minY = stl.getPoint().y - stl.getAdvance() * Math.sin(-this.angel);
            minY -= stl.getAscent() * Math.cos(-this.angel);
        } else {
            minY = stl.getPoint().y - stl.getAscent();
        }
        return minY * this.getShrinkRate();
    }

    public int getRotate() {
        return this.rotate;
    }

    protected void updateVariables() {
        this.clipWidth = this.clip.getBounds2D().getWidth();
        this.clipHeight = this.clip.getBounds2D().getHeight();
        this.clipY = this.clip.getBounds2D().getMinY();
        this.clipX = this.clip.getBounds2D().getMinX();
        this.angel = (double)this.getRotate() * Math.PI / 180.0;
        this.rectAngel = Math.atan(this.clipHeight / this.clipWidth);
    }

    public void setShrinkRate(double f) {
        this.shrinkRate = f;
        for (int i = this.rows.size() - 1; i >= 0; --i) {
            SureRow stl = (SureRow)this.rows.get(i);
            stl.setX(stl.getPoint().x / f);
            stl.setY(stl.getPoint().y / f);
        }
        this.updateVariables();
    }

    public void setClip(Shape shape) {
        if (!(shape instanceof Rectangle2D)) {
            throw new IllegalArgumentException("Only rectangle clip area supported.");
        }
        this.clip = shape;
        this.updateVariables();
    }

    @Override
    public double getMinX() {
        double minx = 0.0;
        if (this.angel > this.rectAngel) {
            minx = this.getLineMinX(this.getRows().size() - 1);
            if (this.getRows().size() > 1) {
                double minxTemp = this.getLineMinX(this.getRows().size() - 2);
                minx = minx < minxTemp ? minx : minxTemp;
            }
        } else {
            minx = this.getLineMinX(0);
        }
        return minx;
    }

    @Override
    public double getMinY() {
        double miny = this.getLineMinY(0);
        for (int i = this.getRows().size() - 1; i >= 0; --i) {
            if (!(this.getLineMinY(i) < miny)) continue;
            miny = this.getLineMinY(i);
        }
        return miny;
    }

    @Override
    public double getMaxX() {
        double maxx = 0.0;
        if (this.angel >= this.rectAngel) {
            maxx = this.getLineMaxX(0);
        } else {
            maxx = this.getLineMaxX(this.getRows().size() - 1);
            if (this.getRows().size() > 1) {
                double maxxTemp = this.getLineMaxX(this.getRows().size() - 2);
                maxx = maxx > maxxTemp ? maxx : maxxTemp;
            }
        }
        return maxx;
    }

    @Override
    public double getMaxY() {
        double maxy = 0.0;
        maxy = this.getLineMaxY(this.getRows().size() - 1);
        if (this.getRows().size() > 1) {
            double maxyTemp = this.getLineMaxY(this.getRows().size() - 2);
            maxy = maxy > maxyTemp ? maxy : maxyTemp;
        }
        return maxy;
    }

    @Override
    public void moveAllX(double ox) {
        ox /= this.getShrinkRate();
        for (int i = this.getRows().size() - 1; i >= 0; --i) {
            SureRow stl = (SureRow)this.getRows().get(i);
            stl.setX(stl.getPoint().x + ox);
        }
    }

    @Override
    public void moveAllY(double oy) {
        oy /= this.getShrinkRate();
        for (int i = this.getRows().size() - 1; i >= 0; --i) {
            SureRow stl = (SureRow)this.getRows().get(i);
            stl.setY(stl.getPoint().y + oy);
        }
    }

    @Override
    public void moveLineX(int index, double ox) {
        SureRow stl = (SureRow)this.getRows().get(index);
        stl.setX(stl.getPoint().x + (ox /= this.getShrinkRate()));
    }

    @Override
    public void moveLineY(int index, double oy) {
        SureRow stl = (SureRow)this.getRows().get(index);
        stl.setY(stl.getPoint().y + (oy /= this.getShrinkRate()));
    }

    public void setRotate(int i) {
        this.rotate = i;
        this.updateVariables();
    }

    public Shape getClip() {
        return this.clip;
    }

    @Override
    public void draw(Graphics2D g2d) {
        Shape clipSave = g2d.getClip();
        this.atSave = (AffineTransform)g2d.getTransform().clone();
        if (this.style.isClip()) {
            g2d.clip(this.clip);
        }
        this.at = (AffineTransform)g2d.getTransform().clone();
        if (this.getShrinkRate() == 1.0) {
            AffineTransform atTemp = (AffineTransform)this.at.clone();
            for (int i = this.getRows().size() - 1; i >= 0; --i) {
                SureRow stl = (SureRow)this.rows.get(i);
                this.at.rotate(Math.PI / 180 * (double)this.getRotate(), stl.getPoint().x, stl.getPoint().y);
                g2d.setTransform(this.at);
                this.at = (AffineTransform)atTemp.clone();
                stl.draw(g2d);
            }
        } else {
            this.at.concatenate(new AffineTransform(this.getShrinkRate(), 0.0, 0.0, this.getShrinkRate(), 0.0, 0.0));
            AffineTransform atTemp = (AffineTransform)this.at.clone();
            for (int i = 0; i < this.rows.size(); ++i) {
                SureRow stl = (SureRow)this.rows.get(i);
                this.at.rotate(Math.PI / 180 * (double)this.getRotate(), stl.getPoint().x, stl.getPoint().y);
                g2d.setTransform(this.at);
                this.at = (AffineTransform)atTemp.clone();
                stl.draw(g2d);
            }
        }
        g2d.setTransform(this.atSave);
        g2d.setClip(clipSave);
    }

    Style getStyle() {
        return this.style;
    }

    void setStyle(Style style) {
        this.style = style;
    }
}

