/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.render.view;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JTextArea;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.CompositeView;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.ParagraphView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class KDPlainParagraph
extends ParagraphView {
    public KDPlainParagraph(Element elem) {
        super(elem);
        this.layoutPool = new LogicalView(elem);
        this.layoutPool.setParent(this);
    }

    @Override
    public void setParent(View parent) {
        super.setParent(parent);
        if (parent != null) {
            this.setPropertiesFromAttributes();
        }
    }

    public void setHorizontalAlign(int align) {
        this.setJustification(align);
    }

    @Override
    public int getFlowSpan(int index) {
        JTextArea area;
        Container c = this.getContainer();
        if (c instanceof JTextArea && !(area = (JTextArea)c).getLineWrap()) {
            return Integer.MAX_VALUE;
        }
        return super.getFlowSpan(index);
    }

    @Override
    protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
        SizeRequirements req = super.calculateMinorAxisRequirements(axis, r);
        Container c = this.getContainer();
        if (c instanceof JTextArea) {
            JTextArea area = (JTextArea)c;
            if (!area.getLineWrap()) {
                req.minimum = req.preferred;
            } else {
                req.minimum = 0;
                req.preferred = this.getWidth();
                if (req.preferred == Short.MAX_VALUE) {
                    req.preferred = 100;
                }
            }
        }
        return req;
    }

    @Override
    public void setSize(float width, float height) {
        if ((int)width != this.getWidth()) {
            this.preferenceChanged(null, true, true);
        }
        super.setSize(width, height);
    }

    static class LogicalView
    extends CompositeView {
        LogicalView(Element elem) {
            super(elem);
        }

        @Override
        protected int getViewIndexAtPosition(int pos) {
            Element elem = this.getElement();
            if (elem.getElementCount() > 0) {
                return elem.getElementIndex(pos);
            }
            return 0;
        }

        @Override
        protected boolean updateChildren(DocumentEvent.ElementChange ec, DocumentEvent e, ViewFactory f) {
            return false;
        }

        @Override
        protected void loadChildren(ViewFactory f) {
            Element elem = this.getElement();
            if (elem.getElementCount() > 0) {
                super.loadChildren(f);
            } else {
                GlyphView v = new GlyphView(elem);
                this.append(v);
            }
        }

        @Override
        public float getPreferredSpan(int axis) {
            if (this.getViewCount() != 1) {
                throw new Error("One child view is assumed.");
            }
            View v = this.getView(0);
            return v.getPreferredSpan(axis);
        }

        @Override
        protected void forwardUpdateToView(View v, DocumentEvent e, Shape a, ViewFactory f) {
            v.setParent(this);
            super.forwardUpdateToView(v, e, a, f);
        }

        @Override
        public void paint(Graphics g, Shape allocation) {
        }

        @Override
        protected boolean isBefore(int x, int y, Rectangle alloc) {
            return false;
        }

        @Override
        protected boolean isAfter(int x, int y, Rectangle alloc) {
            return false;
        }

        @Override
        protected View getViewAtPoint(int x, int y, Rectangle alloc) {
            return null;
        }

        @Override
        protected void childAllocation(int index, Rectangle a) {
        }
    }
}

