/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.res.tool.miniscript;

import com.kingdee.bos.ctrl.common.ui.editor.EditorRowHeader;
import com.kingdee.bos.ctrl.common.ui.editor.styled.MiniScriptEditor;
import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.script.miniscript.MiniScriptEngine;
import com.kingdee.bos.ctrl.script.miniscript.exec.IDebugListener;
import com.kingdee.bos.ctrl.script.miniscript.exec.IMiniScriptEngineListener;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;

public class MiniScriptConsole
extends JFrame
implements IMiniScriptEngineListener,
IDebugListener {
    private static final String script_path = "script_path";
    private MiniScriptEditor editor = new MiniScriptEditor();
    private JTextArea outer = new JTextArea();
    private JLabel lblStatus = new JLabel();
    private ConsoleConfig cc = new ConsoleConfig("MiniScript.ini");
    private EditorRowHeader rh = new EditorRowHeader();
    private String filename = null;
    private JFileChooser jfc = new JFileChooser();
    MiniScriptEngine se = null;
    boolean debuging = false;

    public MiniScriptConsole() {
        this.init();
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.exit();
        } else {
            super.processWindowEvent(e);
        }
    }

    private void init() {
        this.enableEvents(64L);
        this.setTitle("Mini Script Console");
        this.setSize(800, 600);
        Dimension d = this.getToolkit().getScreenSize();
        this.setLocation((int)(d.getWidth() - (double)this.getWidth()) / 2, (int)(d.getHeight() - (double)this.getHeight()) / 2);
        this.setDefaultCloseOperation(2);
        this.setExtendedState(6);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JPanel(), "North");
        this.getContentPane().add((Component)new JPanel(), "West");
        this.getContentPane().add((Component)new JPanel(), "East");
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new FlowLayout(0, 1, 5));
        statusPanel.add(this.lblStatus);
        this.getContentPane().add((Component)statusPanel, "South");
        JSplitPane sp = new JSplitPane(0);
        sp.setDividerLocation(450);
        JPanel editorPanel = new JPanel();
        editorPanel.setLayout(new BorderLayout());
        JScrollPane p = new JScrollPane((Component)((Object)this.editor));
        p.setRowHeaderView(this.rh);
        this.rh.setFont(this.editor.getFont());
        this.editor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MiniScriptConsole.this.rh.showMaxRowNumber(MiniScriptConsole.this.editor.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MiniScriptConsole.this.rh.showMaxRowNumber(MiniScriptConsole.this.editor.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        editorPanel.add((Component)p, "Center");
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new BorderLayout());
        outerPanel.add((Component)new JScrollPane(this.outer), "Center");
        outerPanel.add((Component)new JLabel("\u63a7\u5236\u53f0\u8f93\u51fa"), "North");
        sp.add((Component)editorPanel, "top");
        sp.add((Component)outerPanel, "bottom");
        this.getContentPane().add((Component)sp, "Center");
        PrintStream ps = new PrintStream(new ByteArrayOutputStream(){

            @Override
            public synchronized void write(byte[] b, int off, int len) {
                SwingUtilities.invokeLater(new PrintMsgRunnable(new String(b, off, len)));
            }
        });
        System.setOut(ps);
        System.setErr(ps);
        this.editor.requestFocus();
        JMenuBar bar = new JMenuBar();
        this.setJMenuBar(bar);
        JMenu menuFile = new JMenu("\u6587\u4ef6");
        menuFile.setMnemonic('F');
        JMenuItem item = new JMenuItem("\u65b0\u5efa...");
        item.setMnemonic('N');
        item.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MiniScriptConsole.this.newFile();
            }
        });
        menuFile.add(item);
        item = new JMenuItem("\u6253\u5f00\u6587\u4ef6...");
        item.setMnemonic('O');
        item.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MiniScriptConsole.this.open();
            }
        });
        menuFile.add(item);
        item = new JMenuItem("\u4fdd\u5b58");
        item.setMnemonic('S');
        item.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MiniScriptConsole.this.save();
            }
        });
        menuFile.add(item);
        item = new JMenuItem("\u9000\u51fa");
        item.setMnemonic('X');
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MiniScriptConsole.this.exit();
            }
        });
        menuFile.add(item);
        JMenu menuRun = new JMenu("\u8fd0\u884c");
        menuRun.setMnemonic('R');
        item = new JMenuItem("\u8fd0\u884c");
        item.setAccelerator(KeyStroke.getKeyStroke(120, 0));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MiniScriptConsole.this.exec(false);
            }
        });
        menuRun.add(item);
        item = new JMenuItem("\u8c03\u8bd5");
        item.setAccelerator(KeyStroke.getKeyStroke(120, 2));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MiniScriptConsole.this.exec(true);
            }
        });
        menuRun.add(item);
        item = new JMenuItem("\u5355\u6b65\u6267\u884c");
        item.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MiniScriptConsole.this.stepGo();
            }
        });
        menuRun.add(item);
        JMenu menuHelp = new JMenu("\u5e2e\u52a9");
        menuHelp.setMnemonic('H');
        item = new JMenuItem("\u5173\u4e8e");
        item.setMnemonic('A');
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MiniScriptConsole.this.about();
            }
        });
        menuHelp.add(item);
        bar.add(menuFile);
        bar.add(menuRun);
        bar.add(menuHelp);
        this.jfc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getAbsolutePath().toLowerCase().endsWith(".ms");
            }

            @Override
            public String getDescription() {
                return "MiniScript(*.ms)";
            }
        });
        this.initData();
    }

    private void initData() {
        this.cc.load();
        this.jfc.setSelectedFile(new File(FilenameUtils.normalize((String)this.cc.getProperty(script_path))));
    }

    private void about() {
        JOptionPane.showMessageDialog(this, "MiniScript V0.92 2006(c).", "\u5173\u4e8eMiniScript", 1);
    }

    private void newFile() {
        if (this.ensureClearModified("\u65b0\u5efa...")) {
            this.editor.setText(null);
            this.editor.setModified(false);
            this.filename = null;
            this.setStatusInfo("\u65b0\u5efa\u6587\u4ef6...");
        }
    }

    private void open() {
        if (this.ensureClearModified("\u6253\u5f00\u6587\u4ef6...") && this.jfc.showOpenDialog(this) == 0) {
            this.openFile(this.jfc.getSelectedFile());
        }
    }

    private void openFile(File f) {
        try {
            String fname = f.getAbsolutePath();
            if (!f.exists()) {
                f = new File(fname + ".ms");
            }
            if (!f.exists()) {
                throw new Exception("\u6587\u4ef6" + fname + "\u4e0d\u5b58\u5728\uff01");
            }
            this.editor.loadFrom(f.getAbsolutePath());
            this.cc.setProperty(script_path, f.getAbsolutePath());
            this.filename = f.getAbsolutePath();
            this.editor.setModified(false);
            this.setStatusInfo(this.filename);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "\u6253\u5f00\u6587\u4ef6...", 2);
        }
    }

    private boolean save() {
        block5: {
            try {
                if (this.filename == null) {
                    if (this.jfc.showSaveDialog(this) == 0) {
                        String f = this.jfc.getSelectedFile().getAbsolutePath();
                        if (f.indexOf(46) == -1) {
                            f = f + ".ms";
                        }
                        this.editor.saveTo(f);
                        this.filename = f;
                        this.setStatusInfo(f);
                        this.cc.setProperty(script_path, new File(f).getAbsolutePath());
                        return true;
                    }
                    break block5;
                }
                this.editor.saveTo(this.filename);
                return true;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "\u4fdd\u5b58", 2);
            }
        }
        return false;
    }

    private boolean ensureClearModified(String title) {
        if (this.editor.isModified()) {
            int r = JOptionPane.showConfirmDialog(this, "\u5f53\u524d\u6587\u4ef6\u5df2\u88ab\u7f16\u8f91\uff0c\u8981\u4fdd\u5b58\u4fee\u6539\u5417\uff1f", title, 1);
            if (r == 2) {
                return false;
            }
            if (r == 0) {
                return this.save();
            }
            return true;
        }
        return true;
    }

    private void exit() {
        if (this.ensureClearModified("\u9000\u51fa")) {
            this.cc.save();
            if (this.se != null) {
                this.se.stop();
            }
            this.dispose();
        }
    }

    private void setStatusInfo(String msg) {
        this.lblStatus.setText("    " + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exec(boolean debug) {
        block8: {
            if (this.debuging) {
                if (debug) {
                    JOptionPane.showMessageDialog(this, "\u6b63\u5728\u8c03\u8bd5\u6267\u884c...");
                } else {
                    this.se.stepOver();
                    this.se.resume();
                }
                return;
            }
            this.outer.setText(null);
            String s = this.editor.getText();
            try {
                this.debuging = debug;
                if (debug) {
                    this.se = MiniScriptEngine.exec((String)s, null, null, (int[])new int[]{2}, (boolean)true, (IMiniScriptEngineListener)this, (IDebugListener)this);
                    break block8;
                }
                this.se = null;
                MiniScriptEngine.exec((String)s, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void stepGo() {
        if (!this.debuging) {
            return;
        }
        this.se.resume();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(WindowsLookAndFeel.class.getName());
            if (args.length > 0) {
                StringBuffer s = new StringBuffer();
                for (int i = 0; i < args.length; ++i) {
                    s.append(args[i]).append(' ');
                }
                System.out.println("====MiniScript execute console====");
                MiniScriptEngine.exec((String)s.toString(), null);
            } else {
                new MiniScriptConsole().setVisible(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void execFinished() {
        this.debuging = false;
        System.out.println("\n[\u8c03\u8bd5]\u6267\u884c\u5b8c\u6bd5");
        int end = this.editor.getDocument().getLength() - 1;
        this.editor.select(end, end);
    }

    public void gotoLine(final int line) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Point p = MiniScriptConsole.this.editor.getLinePos(line);
                if (p != null) {
                    MiniScriptConsole.this.editor.select(p.x, p.y);
                }
            }
        });
    }

    class ConsoleConfig {
        private String fileName;
        private Properties pros = new Properties();

        public ConsoleConfig(String fileName) {
            this.fileName = fileName;
        }

        public void load() {
            block4: {
                block5: {
                    if (!new File(this.fileName).exists()) break block5;
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream(this.fileName);
                        this.pros.load(is);
                    }
                    catch (Exception e) {
                        try {
                            e.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            StreamUtil.closeStream(is);
                            throw throwable;
                        }
                        StreamUtil.closeStream((InputStream)is);
                        break block4;
                    }
                    StreamUtil.closeStream((InputStream)is);
                    break block4;
                }
                this.pros.setProperty(MiniScriptConsole.script_path, new File("").getAbsolutePath());
            }
        }

        public void save() {
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(this.fileName);
                this.pros.save(os, this.getClass().getName());
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    StreamUtil.closeStream(os);
                    throw throwable;
                }
                StreamUtil.closeStream((OutputStream)os);
            }
            StreamUtil.closeStream((OutputStream)os);
        }

        public void setProperty(String key, String value) {
            this.pros.setProperty(key, value);
        }

        public String getProperty(String key) {
            return this.pros.getProperty(key);
        }

        public String getProperty(String key, String defaultValue) {
            return this.pros.getProperty(key, defaultValue);
        }
    }

    class PrintMsgRunnable
    implements Runnable {
        String msg;

        PrintMsgRunnable(String aMsg) {
            this.msg = aMsg;
        }

        @Override
        public void run() {
            MiniScriptConsole.this.outer.append(this.msg);
            MiniScriptConsole.this.outer.setCaretPosition(MiniScriptConsole.this.outer.getDocument().getLength());
        }
    }
}

