/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.res.tool.resscan;

import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.res.tool.resscan.CNItem;
import com.kingdee.bos.ctrl.res.tool.resscan.ItemEntity;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class JavaFileFormator {
    public static Font font = new Font("\u5b8b\u4f53", 0, 15);
    static SimpleAttributeSet lineNoAttr = new SimpleAttributeSet();
    static SimpleAttributeSet itemTagAttr = new SimpleAttributeSet();
    static SimpleAttributeSet defaultAttr = new SimpleAttributeSet();
    private static Map lineNoCache;

    private static void addDocAttr(List list, int offset, int length, AttributeSet s) {
        list.add(new Object[]{new Integer(offset), new Integer(length), s});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showCNFile(CNItem ci, final JTextPane jt) {
        FileReader r = null;
        BufferedReader br = null;
        try {
            String line;
            jt.setIgnoreRepaint(true);
            jt.setEnabled(false);
            jt.setText(null);
            r = new FileReader(ci.getFile());
            br = new BufferedReader(r);
            int n = 1;
            String buf = null;
            int len = 0;
            int firstLocatePos = 0;
            Set lineNoSet = ci.getLineNoSet();
            StringBuffer sb = new StringBuffer();
            final ArrayList attrList = new ArrayList();
            while ((line = br.readLine()) != null) {
                if (lineNoSet.contains(new Integer(n))) {
                    buf = JavaFileFormator.getLineNo(n, 4);
                    sb.append(buf);
                    JavaFileFormator.addDocAttr(attrList, len, buf.length(), itemTagAttr);
                    int base = len += buf.length();
                    sb.append(line).append('\n');
                    len += line.length() + 1;
                    List lineItems = ci.getItemsByLineNo(n);
                    int m = lineItems.size();
                    for (int i = 0; i < m; ++i) {
                        ItemEntity ie = (ItemEntity)lineItems.get(i);
                        JavaFileFormator.addDocAttr(attrList, base + ie.colFrom - 1, ie.len, itemTagAttr);
                    }
                    if (firstLocatePos == 0) {
                        firstLocatePos = len;
                    }
                } else {
                    buf = JavaFileFormator.getLineNo(n, 4);
                    sb.append(buf);
                    len += buf.length();
                    sb.append(line).append('\n');
                    len += line.length() + 1;
                }
                ++n;
            }
            br.close();
            jt.setText(sb.toString());
            jt.setCaretPosition(firstLocatePos);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StyledDocument sd = jt.getStyledDocument();
                    int m = attrList.size();
                    for (int i = 0; i < m; ++i) {
                        Object[] s = (Object[])attrList.get(i);
                        sd.setCharacterAttributes((Integer)s[0], (Integer)s[1], (AttributeSet)s[2], true);
                    }
                }
            });
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                jt.setEnabled(true);
                jt.setIgnoreRepaint(false);
                StreamUtil.closeCloseable((Closeable[])new Closeable[]{br, r});
                throw throwable;
            }
            jt.setEnabled(true);
            jt.setIgnoreRepaint(false);
            StreamUtil.closeCloseable((Closeable[])new Closeable[]{br, r});
        }
        jt.setEnabled(true);
        jt.setIgnoreRepaint(false);
        StreamUtil.closeCloseable((Closeable[])new Closeable[]{br, r});
    }

    private static String getLineNo(int no, int fullLength) {
        Integer n = new Integer(no);
        if (!lineNoCache.containsKey(n)) {
            String SPACE = "                         ";
            String s = String.valueOf(no);
            int len = fullLength - s.length();
            if (len < 0) {
                len = 0;
            }
            lineNoCache.put(n, "                         ".substring(0, len) + s + "|  ");
        }
        return (String)lineNoCache.get(n);
    }

    static {
        int fontSize = font.getSize();
        String family = font.getFamily();
        StyleConstants.setFontFamily(lineNoAttr, family);
        StyleConstants.setFontSize(lineNoAttr, fontSize);
        StyleConstants.setForeground(lineNoAttr, Color.GRAY);
        StyleConstants.setFontFamily(itemTagAttr, family);
        StyleConstants.setFontSize(itemTagAttr, fontSize);
        StyleConstants.setForeground(itemTagAttr, new Color(0xFF0000));
        StyleConstants.setFontFamily(defaultAttr, family);
        StyleConstants.setFontSize(defaultAttr, fontSize);
        StyleConstants.setForeground(defaultAttr, Color.BLACK);
        lineNoCache = new HashMap();
    }
}

