/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.res.tool.resscan;

import com.kingdee.bos.ctrl.common.util.StreamUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class LocateCode {
    public static final int S_TYPE = 0;
    public static final int T_TYPE = 0;
    private static Map sMap = new HashMap();
    private static Map tMap = new HashMap();
    private static List sWordList = new ArrayList();
    private static List tWordList = new ArrayList();

    private static void addCharMap(char sChar, char tChar) {
        LocateCode.addCharMap(String.valueOf(sChar), String.valueOf(tChar));
    }

    private static void addCharMap(String sChar, String tChar) {
        sMap.put(sChar, tChar);
        tMap.put(tChar, sChar);
        if (sChar.length() > 1) {
            sWordList.add(sChar);
        }
        if (tChar.length() > 1) {
            tWordList.add(tChar);
        }
    }

    public static String simplized(String value) {
        return LocateCode.convertCode(value, tMap, tWordList);
    }

    public static String traditionalized(String value) {
        return LocateCode.convertCode(value, sMap, sWordList);
    }

    private static String convertCode(String value, Map descMap) {
        char[] chs = value.toCharArray();
        StringBuffer sb = new StringBuffer(chs.length);
        int n = chs.length;
        for (int i = 0; i < n; ++i) {
            String ch = (String)descMap.get(String.valueOf(chs[i]));
            if (ch == null) {
                sb.append(chs[i]);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static String convertCode(String value, Map descMap, List srcWordList) {
        int n = srcWordList.size();
        for (int i = 0; i < n; ++i) {
            String key = (String)srcWordList.get(i);
            if (value.indexOf(key) == -1) continue;
            value = value.replace(key, (String)descMap.get(key));
        }
        return LocateCode.convertCode(value, descMap);
    }

    private static String transFromFile(String file, int type) throws Exception {
        block6: {
            BufferedReader br;
            FileReader r;
            StringBuilder sb;
            block5: {
                String string;
                sb = new StringBuilder();
                r = null;
                br = null;
                try {
                    String line;
                    r = new FileReader(FilenameUtils.normalize((String)file));
                    br = new BufferedReader(r);
                    while ((line = br.readLine()) != null) {
                        sb.append(line).append("\r\n");
                    }
                    br.close();
                    if (type != 0) break block5;
                    string = LocateCode.simplized(sb.toString());
                }
                catch (Throwable throwable) {
                    StreamUtil.closeCloseable((Closeable[])new Closeable[]{br, r});
                    throw throwable;
                }
                StreamUtil.closeCloseable((Closeable[])new Closeable[]{br, r});
                return string;
            }
            if (type != 0) break block6;
            String string = LocateCode.traditionalized(sb.toString());
            StreamUtil.closeCloseable((Closeable[])new Closeable[]{br, r});
            return string;
        }
        throw new Exception("translate type not supported.");
    }

    private static void usage() {
        StringBuffer sb = new StringBuffer();
        sb.append("Usage:\nLocateCode [option] file").append("\n\t[option]").append("\n\t-s translate to simplized").append("\n\t-t translate to traditionalized");
        System.out.println(sb.toString());
    }

    public static void main(String[] args) throws Exception {
        System.out.println(LocateCode.traditionalized("\u6a21\u677f\u554a\u4e2d\u56fd"));
        if (args.length == 2) {
            if ("-s".equals(args[0])) {
                System.out.println(LocateCode.transFromFile(args[1], 0));
            } else if ("-t".equals(args[0])) {
                System.out.println(LocateCode.transFromFile(args[1], 0));
            } else {
                LocateCode.usage();
            }
        } else {
            LocateCode.usage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream in = null;
        InputStreamReader r = null;
        BufferedReader br = null;
        try {
            String line;
            in = LocateCode.class.getResourceAsStream("sc2tc");
            r = new InputStreamReader(in, StandardCharsets.UTF_16);
            br = new BufferedReader(r);
            while ((line = br.readLine()) != null) {
                String[] s = line.split("\\s");
                if (s.length == 2) {
                    LocateCode.addCharMap(s[0], s[1]);
                    continue;
                }
                System.err.println("[File]'sc2tc' Error Line:" + line);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                StreamUtil.closeCloseable((Closeable[])new Closeable[]{br, r, in});
                throw throwable;
            }
            StreamUtil.closeCloseable((Closeable[])new Closeable[]{br, r, in});
        }
        StreamUtil.closeCloseable((Closeable[])new Closeable[]{br, r, in});
        System.out.println("\u5b57\u5e93\u5927\u5c0f=" + sMap.size());
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o2).length() - ((String)o1).length();
            }
        };
        Collections.sort(sWordList, c);
        Collections.sort(tWordList, c);
    }
}

