/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.wizard.common;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.MultiLangUI;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.wizard.common.CommonResource;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComboBox;

public abstract class ParamTable
extends KDPanel {
    public static final int COL_NAME = 0;
    public static final int COL_ALIAS = 1;
    public static final int COL_TYPE = 2;
    public static final int COL_DESC = 3;
    public static final int COL_EXPR = 4;
    protected boolean isChanged;
    protected boolean isHideEXPR;
    protected boolean isHideDESC;
    protected boolean isHideBtnInput;
    protected String title;
    protected KDTable table;
    private KDWorkButton btnInput;
    private KDWorkButton btnUp;
    private KDWorkButton btnDown;
    private KDWorkButton btnInsert;
    private KDWorkButton btnDelete;

    public ParamTable() {
        this.init();
        this.installListener();
    }

    public ParamTable(String txt) {
        this.title = txt;
        this.init();
        this.installListener();
    }

    public ParamTable(String txt, boolean hideBtnNewInput) {
        this.isHideBtnInput = hideBtnNewInput;
        this.init();
        this.installListener();
    }

    public ParamTable(boolean hideEXPR, boolean hideDESC, boolean hideBtnNewInput) {
        this.isHideEXPR = hideEXPR;
        this.isHideDESC = hideDESC;
        this.isHideBtnInput = hideBtnNewInput;
        this.init();
        this.installListener();
    }

    private void init() {
        this.btnInput = new KDWorkButton((Icon)Resource.ICON_FORMULA_WIZARD);
        this.btnInput.setVisible(false);
        this.btnUp = new KDWorkButton((Icon)Resource.ICON_MOVE_TOP);
        this.btnDown = new KDWorkButton((Icon)Resource.ICON_MOVE_DOWN);
        this.btnInsert = new KDWorkButton((Icon)Resource.ICON_INSERT);
        this.btnDelete = new KDWorkButton((Icon)Resource.ICON_DELETE);
        this.btnInput.setToolTipText(CommonResource.getString("res_42"));
        this.btnUp.setToolTipText(CommonResource.getString("res_28"));
        this.btnDown.setToolTipText(CommonResource.getString("res_29"));
        this.btnInsert.setToolTipText(CommonResource.getString("res_30"));
        this.btnUp.setMinimumSize(new Dimension(26, 19));
        this.btnDown.setMinimumSize(new Dimension(26, 19));
        this.btnInsert.setMinimumSize(new Dimension(26, 19));
        this.btnDelete.setMinimumSize(new Dimension(26, 19));
        this.initTable();
        TableLayout layout = TableLayout.splitRow((int)2);
        this.setLayout((LayoutManager)layout);
        layout.defaultStyle().setMarginBottom(0);
        layout.rowStyle(1).setPriY(1);
        layout.rowStyle(0).setMarginTop(0);
        layout.rowStyle(0).setMarginBottom(2);
        Table t2 = layout.cell(0).splitCol(6);
        t2.colStyle(0).setPriX(1);
        this.add((Component)new KDLabel(this.title), t2.cell(0));
        this.add((Component)this.btnInput, t2.cell(1));
        this.add((Component)this.btnInsert, t2.cell(2));
        this.add((Component)this.btnDelete, t2.cell(3));
        this.add((Component)this.btnUp, t2.cell(4));
        this.add((Component)this.btnDown, t2.cell(5));
        this.add((Component)this.table, layout.cell(1));
        if (this.isHideBtnInput) {
            this.btnInput.setVisible(true);
        }
    }

    private void initTable() {
        this.table = new KDTable();
        this.table.getSelectManager().setSelectMode(10);
        KDComboBox typeEditor = new KDComboBox();
        for (int i = 0; i < DataType.ALL_TYPES.length; ++i) {
            typeEditor.addItem((Object)DataType.ALL_TYPES[i]);
        }
        KDMultiLangBox mlb = MultiLangUI.newKDMultiLangBox();
        mlb.putClientProperty((Object)"All_Modal", (Object)Boolean.TRUE);
        KDTDefaultCellEditor kdtMlb = new KDTDefaultCellEditor((JComboBox)mlb);
        this.table.addColumns(5);
        this.table.getColumn(0).setWidth(180);
        IColumn col = this.table.getColumn(1);
        col.setWidth(120);
        col.setEditor((ICellEditor)kdtMlb);
        col = this.table.getColumn(2);
        col.setWidth(100);
        col.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)typeEditor));
        this.table.getColumn(4).setWidth(120);
        col = this.table.getColumn(3);
        col.setWidth(300);
        col.setEditor((ICellEditor)kdtMlb);
        col.getStyleAttributes().setFontColor(Color.GRAY);
        IRow row = this.table.addHeadRow();
        row.getCell(0).setValue((Object)CommonResource.getString("res_1"));
        row.getCell(1).setValue((Object)CommonResource.getString("res_8"));
        row.getCell(2).setValue((Object)CommonResource.getString("res_2"));
        row.getCell(4).setValue((Object)CommonResource.getString("res_43"));
        row.getCell(3).setValue((Object)CommonResource.getString("res_38"));
        if (this.isHideDESC) {
            this.table.getColumn(3).setWidth(0);
        }
        if (this.isHideEXPR) {
            this.table.getColumn(4).setWidth(0);
        }
    }

    private void installListener() {
        this.btnInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParamTable.this.popSelectTree();
            }
        });
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParamTable.this.rowUp();
            }
        });
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParamTable.this.rowDown();
            }
        });
        this.btnInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParamTable.this.insertRow();
            }
        });
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParamTable.this.deleteRow();
            }
        });
        this.table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                int counts = ParamTable.this.table.getRowCount();
                int index = ParamTable.this.table.getSelectManager().getActiveRowIndex();
                for (int i = 0; i < counts; ++i) {
                    String name = null;
                    if (ParamTable.this.table.getCell(i, 0).getValue() != null) {
                        name = ParamTable.this.table.getCell(i, 0).getValue().toString();
                    }
                    if (i == index || ParamTable.this.table.getCell(index, 0).getValue() == null || !StringUtil.equals((String)name, (String)ParamTable.this.table.getCell(index, 0).getValue().toString())) continue;
                    WindowUtil.msgboxInfo((Object)CommonResource.getString("res_3"), (String)CommonResource.getString("res_4"), (Component)((Object)ParamTable.this));
                    ParamTable.this.table.getCell(index, 0).setValue(null);
                }
                if (e.getValue() != null && !e.getValue().equals(e.getOldValue()) || e.getValue() == null && e.getOldValue() != null) {
                    ParamTable.this.setChanged(true);
                }
            }
        });
        this.table.getActionMap().remove("Copy");
        this.table.getActionMap().remove("Cut");
        this.table.getActionMap().remove("Paste");
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    protected void popSelectTree() {
    }

    private void rowUp() {
        KDTSelectBlock sel = this.table.getSelectManager().get();
        if (sel == null) {
            return;
        }
        int idx = sel.getBeginRow();
        if (idx == 0) {
            return;
        }
        this.setChanged(true);
        IRow selRow = this.table.removeRow(idx);
        this.table.addRow(idx - 1, selRow);
        this.table.getSelectManager().select(idx - 1, 0);
    }

    private void rowDown() {
        KDTSelectBlock sel = this.table.getSelectManager().get();
        if (sel == null) {
            return;
        }
        int idx = sel.getBeginRow();
        if (idx == this.table.getRowCount() - 1) {
            return;
        }
        this.setChanged(true);
        IRow selRow = this.table.removeRow(idx);
        this.table.addRow(idx + 1, selRow);
        this.table.getSelectManager().select(idx + 1, 0);
    }

    private void insertRow() {
        IRow newRow = this.table.getSelectManager().get() == null ? this.table.addRow() : this.table.addRow(this.table.getSelectManager().get().getBeginRow());
        newRow.getCell(2).setValue((Object)DataType.STRING);
    }

    private void deleteRow() {
        KDTSelectBlock sel = this.table.getSelectManager().get();
        if (sel == null) {
            return;
        }
        if (!WindowUtil.msgboxYesNo((Component)((Object)this), (Object)CommonResource.getString("res_39"), (String)CommonResource.getString("res_40"))) {
            return;
        }
        this.setChanged(true);
        int selBegin = sel.getBeginRow();
        int selEnd = sel.getEndRow();
        for (int i = selBegin; i <= selEnd; ++i) {
            this.table.removeRow(i);
        }
        this.table.getSelectManager().setActiveRowIndex(selBegin);
    }

    public final void setHideDESC(boolean isHideComment) {
        this.isHideDESC = isHideComment;
    }

    public final void setHideEXPR(boolean isHideEXPR) {
        this.isHideEXPR = isHideEXPR;
    }

    public final void setHideBtnInput(boolean isHideBtnInput) {
        this.isHideBtnInput = isHideBtnInput;
    }
}

