/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.wizard.formula;

import com.kingdee.bos.ctrl.common.ui.formulawizard.Formula;
import com.kingdee.bos.ctrl.common.ui.formulawizard.Group;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.data.meta.MetaManager;
import com.kingdee.bos.ctrl.data.meta.MetaPackage;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.data.modal.query.Column;
import com.kingdee.bos.ctrl.data.modal.query.ITable;
import com.kingdee.bos.ctrl.data.modal.query.io.Meta2Query;
import com.kingdee.bos.ctrl.data.wizard.formula.FormulaResource;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FieldSupplyGroup
extends Group {
    private DefaultKingdeeTreeNode nodeMetaFields;
    private DefaultKingdeeTreeNode nodeCurrentFields;
    private DefaultKingdeeTreeNode nodeDsFields;
    private DefaultKingdeeTreeNode paramFields;
    private DefaultKingdeeTreeNode outputFields;

    public FieldSupplyGroup() {
        this.setTitle(FormulaResource.getString("res_4"));
    }

    public void addNodeCurrentFields() {
        this.nodeCurrentFields = this.addNode(null, FormulaResource.getString("res_5"));
        this.addNode(this.nodeCurrentFields, "(" + FormulaResource.getString("res_3") + ")", new Formula(""));
        this.expandRoot();
    }

    public void addNodeMetaFields() {
        this.nodeMetaFields = this.addNode(null, FormulaResource.getString("res_6"));
        this.addNode(this.nodeMetaFields, "(" + FormulaResource.getString("res_3") + ")", new Formula(""));
        this.expandRoot();
    }

    public void addNodeDsFields() {
        this.nodeDsFields = this.addNode(null, FormulaResource.getString("res_2"));
        this.addNode(this.nodeDsFields, "(" + FormulaResource.getString("res_3") + ")", new Formula(""));
        this.expandRoot();
    }

    public void addNodeParamFields() {
        this.paramFields = this.addNode(null, FormulaResource.getString("res_7"));
        this.addNode(this.paramFields, "(" + FormulaResource.getString("res_3") + ")", new Formula(""));
        this.expandRoot();
    }

    public void addNodeOutputFields() {
        this.outputFields = this.addNode(null, FormulaResource.getString("res_8"));
        this.addNode(this.outputFields, "(" + FormulaResource.getString("res_3") + ")", new Formula(""));
        this.expandRoot();
    }

    public void updateFieldSupplyGroup(KDList fields, boolean isProcess) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < fields.getElementCount(); ++i) {
            list.add(fields.getElement(i));
        }
        this.updateFieldSupplyGroup(list, isProcess);
    }

    public void updateFieldSupplyGroup(List listColumns, boolean isProcess) {
        this.removeAllChildren(this.nodeCurrentFields);
        if (listColumns.size() == 0) {
            this.addNode(this.nodeCurrentFields, "(" + FormulaResource.getString("res_3") + ")", new Formula(""));
        } else {
            for (Column column : listColumns) {
                if (isProcess) {
                    this.addNode(this.nodeCurrentFields, column.getName(), new Formula(column.getName()));
                    continue;
                }
                this.addNode(this.nodeCurrentFields, column.getAliasName(), new Formula(column.getExpr()));
            }
        }
    }

    public void updateTableSupplyGroup(ITable[] tables, MetaClass[] mcs, boolean isProcess) {
        this.removeAllChildren(this.nodeMetaFields);
        int tableCount = 0;
        for (int i = 0; i < tables.length; ++i) {
            ITable tbl = tables[i];
            MetaClass mc = mcs[i];
            if (mc == null) continue;
            ++tableCount;
            DefaultKingdeeTreeNode parent = this.addNode(this.nodeMetaFields, tbl.getAlias());
            Iterator it = mc.getFields().iterator();
            while (it.hasNext()) {
                Column column = Meta2Query.makeColumn((ITable)tbl, (MetaField)((MetaField)it.next()));
                if (isProcess) {
                    this.addNode(parent, column.getName(), new Formula(column.getName()));
                    continue;
                }
                this.addNode(parent, column.getAliasName(), new Formula(column.getExpr()));
            }
        }
        if (tableCount == 0) {
            this.addNode(this.nodeMetaFields, "(" + FormulaResource.getString("res_3") + ")", new Formula(""));
        }
    }

    public void updateImportSupplyGroup(String[] names, MetaClass[] mcs) {
        this.removeAllChildren(this.nodeMetaFields);
        int tableCount = 0;
        for (int i = 0; i < names.length; ++i) {
            MetaClass mc = mcs[i];
            if (mc == null) continue;
            ++tableCount;
            DefaultKingdeeTreeNode parent = this.addNode(this.nodeMetaFields, names[i]);
            Iterator it = mc.getFields().iterator();
            while (it.hasNext()) {
                String name = ((MetaField)it.next()).getName();
                this.addNode(parent, name, new Formula(name));
            }
        }
        if (tableCount == 0) {
            this.addNode(this.nodeMetaFields, "(" + FormulaResource.getString("res_3") + ")", new Formula(""));
        }
    }

    public void updateFieldSupplyGroup(MetaClass mc, boolean isProcess) {
        if (mc == null) {
            return;
        }
        this.removeAllChildren(this.nodeMetaFields);
        for (int i = 0; i < mc.getFields().size(); ++i) {
            MetaField mf = (MetaField)mc.getFields().get(i);
            if (isProcess) {
                this.addNode(this.nodeMetaFields, mf.getName(), new Formula(mf.getName()));
                continue;
            }
            if (mc.getName() == null) {
                this.addNode(this.nodeMetaFields, mf.getAliasName(), new Formula(mf.getName()));
                continue;
            }
            this.addNode(this.nodeMetaFields, mf.getAliasName(), new Formula("[" + mc.getName() + "].[" + mf.getName() + "]"));
        }
    }

    public void updateAllTables(MetaLibrary ml, boolean isProcess) {
        if (ml == null) {
            return;
        }
        MetaManager mng = new MetaManager();
        mng.setName("MetaManager");
        mng.addLibaray(ml);
        List libraries = mng.getLibraries();
        if (libraries != null) {
            if (libraries.size() > 0) {
                this.removeAllChildren(this.nodeDsFields);
            }
            for (int i = 0; i < libraries.size(); ++i) {
                this.addAllMeta(this.nodeDsFields, (DefObj)libraries.get(i), isProcess);
            }
        }
    }

    private void addAllMeta(DefaultKingdeeTreeNode parent, DefObj obj, boolean isProcess) {
        block5: {
            block4: {
                DefaultKingdeeTreeNode childNode;
                if (obj.getClass() != MetaLibrary.class && obj.getClass() != MetaPackage.class) break block4;
                MetaPackage pkg = obj.getClass() == MetaLibrary.class ? ((MetaLibrary)obj).getRootPackage() : (MetaPackage)obj;
                for (DefObj item : pkg.getPackages()) {
                    childNode = this.addNode(parent, item.getAliasName(), new Formula(""));
                    this.addAllMeta(childNode, item, isProcess);
                }
                for (DefObj item : pkg.getClasses()) {
                    childNode = this.addNode(parent, item.getAliasName(), new Formula("[" + item.getName() + "]"));
                    this.addAllMeta(childNode, item, isProcess);
                }
                break block5;
            }
            if (obj.getClass() != MetaClass.class) break block5;
            MetaClass cls = (MetaClass)obj;
            for (DefObj item : cls.getFields()) {
                if (isProcess) {
                    this.addNode(parent, item.getName(), new Formula(item.getName()));
                    continue;
                }
                this.addNode(parent, item.getAliasName(), new Formula("[" + cls.getName() + "].[" + item.getName() + "]"));
            }
        }
    }

    public void updateParamGroup(List parameters) {
        this.removeAllChildren(this.paramFields);
        if (parameters == null) {
            return;
        }
        Iterator itr = parameters.iterator();
        boolean hasParam = false;
        while (itr.hasNext()) {
            DefObj p = (DefObj)itr.next();
            this.addNode(this.paramFields, p.getName(), new Formula("@" + p.getName()));
            hasParam = true;
        }
        if (!hasParam) {
            this.addNode(this.paramFields, "(" + FormulaResource.getString("res_3") + ")", new Formula(""));
        }
    }

    public void updateOutputFieldGroup(KDList fields) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < fields.getElementCount(); ++i) {
            list.add(fields.getElement(i));
        }
        this.updateOutputFieldGroup(list);
    }

    public void updateOutputFieldGroup(List listOutputs) {
        this.removeAllChildren(this.outputFields);
        List listOutputColumns = null;
        if (listOutputs != null && listOutputs.size() > 0) {
            listOutputColumns = (List)listOutputs.get(0);
        }
        if (listOutputColumns == null || listOutputColumns.size() == 0) {
            this.addNode(this.outputFields, "(" + FormulaResource.getString("res_3") + ")", new Formula(""));
        } else {
            for (Column column : listOutputColumns) {
                this.addNode(this.outputFields, column.getAliasName(), new Formula(column.getName()));
            }
        }
    }

    public DefaultKingdeeTreeNode getNodeCurrentFields() {
        return this.nodeCurrentFields;
    }

    public DefaultKingdeeTreeNode getNodeMetaFields() {
        return this.nodeMetaFields;
    }

    public DefaultKingdeeTreeNode getNodeDsFields() {
        return this.nodeDsFields;
    }

    public void setNodeDsFields(DefaultKingdeeTreeNode nodeDsFields) {
        this.nodeDsFields = nodeDsFields;
    }

    public void setNodeCurrentFields(DefaultKingdeeTreeNode nodeCurrentFields) {
        this.nodeCurrentFields = nodeCurrentFields;
    }

    public void setNodeMetaFields(DefaultKingdeeTreeNode nodeMetaFields) {
        this.nodeMetaFields = nodeMetaFields;
    }
}

