/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.wizard.process;

import com.kingdee.bos.ctrl.data.wizard.process.GenericPanel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;

public abstract class TablePanel
extends GenericPanel {
    protected KDTable table = new KDTable();
    private ComponentAdapter parentListener;

    public TablePanel() {
        this(27, false);
    }

    public TablePanel(int useBTs, boolean autoAdjustLastCol) {
        super(useBTs);
        this.setComponent((JComponent)this.table);
        if (autoAdjustLastCol) {
            this.autoAdjustLastColumn();
        }
    }

    private void autoAdjustLastColumn() {
        this.removeComponentListener(this.parentListener);
        if (this.parentListener == null) {
            this.parentListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    Component prt = (Component)e.getSource();
                    int newWidth = 0;
                    for (int i = 0; i < TablePanel.this.table.getColumnCount() - 1; ++i) {
                        newWidth += TablePanel.this.table.getColumn(i).getWidth();
                    }
                    newWidth = prt.getWidth() - newWidth - 4 - TablePanel.this.table.getIndexColumn().getWidth();
                    if (newWidth > 0 && TablePanel.this.table.getColumnCount() > 0) {
                        TablePanel.this.table.getColumn(TablePanel.this.table.getColumnCount() - 1).setWidth(newWidth);
                    }
                }
            };
        }
        this.addComponentListener(this.parentListener);
    }

    @Override
    protected void onClickBT(int btVal) {
        switch (btVal) {
            case 1: {
                this.table.addRow();
                break;
            }
            case 2: {
                int index = this.table.getSelectManager().getActiveRowIndex();
                if (index == -1) break;
                this.table.removeRow(index);
                break;
            }
            case 8: {
                int index = this.table.getSelectManager().getActiveRowIndex();
                if (index == -1 || index == 0) break;
                this.moveTableItem(index, true);
                break;
            }
            case 16: {
                int index = this.table.getSelectManager().getActiveRowIndex();
                if (index == -1 || index == this.table.getRowCount() - 1) break;
                this.moveTableItem(index, false);
            }
        }
    }

    private void moveTableItem(int rowIndex, boolean moveUp) {
        int colCount = this.table.getColumnCount();
        int newRowIndex = moveUp ? rowIndex - 1 : rowIndex + 1;
        IRow row0 = this.table.getRow(rowIndex);
        IRow row2 = this.table.getRow(newRowIndex);
        for (int i = 0; i < colCount; ++i) {
            Object objTemp = row0.getCell(i).getValue();
            row0.getCell(i).setValue(row2.getCell(i).getValue());
            row2.getCell(i).setValue(objTemp);
        }
        this.table.invalidate();
        KDTableUtil.setSelectedRow((KDTable)this.table, (int)newRowIndex);
    }

    public final KDTable getTable() {
        return this.table;
    }
}

