/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.wizard.util;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaManager;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.data.modal.query.ITable;
import com.kingdee.bos.ctrl.data.modal.query.ITableList;
import com.kingdee.bos.ctrl.data.modal.query.Order;
import com.kingdee.bos.ctrl.data.modal.query.Table;
import com.kingdee.bos.ctrl.data.modal.query.io.Query2Meta;
import com.kingdee.bos.ctrl.data.wizard.framework.query.IQueryWizardModel;
import com.kingdee.bos.ctrl.swing.KDList;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WizardUtil {
    public static final String INVALID_CHARS = "\\/:*?\"<>|";
    private static final Pattern QT_MF = Pattern.compile("\\[[^\\[\\]]*\\]\\.\\[[^\\[\\]]*\\]", 32);

    public static void makeSureDefObjUnique(KDList list, IDefObj defObj) {
        int i = WizardUtil.numberIndexOf(defObj.getName());
        String strNum = defObj.getName().substring(i);
        int num = StringUtil.isEmptyString((String)strNum) ? 0 : Integer.parseInt(strNum);
        String strCap = defObj.getName().substring(0, i);
        while (!WizardUtil.isIDUnique(list, defObj)) {
            defObj.setName(strCap + ++num);
        }
        String alias = defObj.getAlias();
        if (alias == null || alias.length() == 0) {
            alias = defObj.getName();
            defObj.setAlias(alias);
        }
        num = StringUtil.isEmptyString((String)(strNum = alias.substring(i = WizardUtil.numberIndexOf(alias)))) ? 0 : Integer.parseInt(strNum);
        strCap = alias.substring(0, i);
        while (!WizardUtil.isAliasUnique(list, defObj)) {
            defObj.setAlias(strCap + ++num);
        }
    }

    private static int numberIndexOf(String name) {
        int idx = name.length() - 1;
        String lastChr = name.substring(idx);
        while (lastChr.matches("\\d+")) {
            if (idx == 0) {
                return name.length();
            }
            lastChr = name.substring(--idx);
        }
        return idx + 1;
    }

    public static boolean isIDUnique(KDList list, IDefObj defObj) {
        return WizardUtil.isIDUnique(list, defObj, defObj.getName());
    }

    public static boolean isIDUnique(KDList list, IDefObj defObj, String id) {
        for (int i = 0; i < list.getElementCount(); ++i) {
            if (list.getElement(i).equals(defObj) || !StringUtil.equalsIgnoreCase((String)id, (String)((IDefObj)list.getElement(i)).getName())) continue;
            return false;
        }
        return true;
    }

    public static boolean isAliasUnique(KDList list, IDefObj defObj) {
        return WizardUtil.isAliasUnique(list, defObj, defObj.getAlias());
    }

    public static boolean isAliasUnique(KDList list, IDefObj defObj, String alias) {
        for (int i = 0; i < list.getElementCount(); ++i) {
            if (list.getElement(i).equals(defObj) || !StringUtil.equalsIgnoreCase((String)alias, (String)((IDefObj)list.getElement(i)).getAlias())) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidString(String val) {
        if (val == null || val.length() == 0) {
            return true;
        }
        for (int i = 0; i < val.length(); ++i) {
            if (INVALID_CHARS.indexOf(val.charAt(i)) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isTableField(String fieldExpr, String tableName) {
        String temp = "[" + tableName + "].[";
        return fieldExpr.indexOf(temp) != -1;
    }

    public static MetaClass lookForMetaClass(ITable dataObj, MetaManager metaManager) {
        if (dataObj instanceof Table) {
            return WizardUtil.lookForMetaClass(((Table)dataObj).getExpr(), metaManager);
        }
        if (dataObj instanceof IQuery) {
            return Query2Meta.toMetaClass((IQuery)((IQuery)dataObj));
        }
        return null;
    }

    public static MetaClass lookForMetaClass(String expr, MetaManager metaManager) {
        if (expr == null) {
            return null;
        }
        return metaManager.findClass(expr);
    }

    public static boolean isSortUnique(KDList list, Order order) {
        for (int i = 0; i < list.getElementCount(); ++i) {
            if (!list.getElement(i).equals(order)) {
                if (!StringUtil.equalsIgnoreCase((String)order.getExpr(), (String)((Order)list.getElement(i)).getExpr())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static String replaceExpression(String expr, String oldName, String newName) {
        Matcher mch = QT_MF.matcher(expr);
        StringBuffer sb = new StringBuffer();
        int j = 0;
        int i = 0;
        while (mch.find()) {
            i = mch.start();
            sb.append(expr.substring(j, i));
            j = mch.end();
            sb.append(WizardUtil.replaceTableName(expr.substring(i, j), oldName, newName));
        }
        sb.append(expr.substring(j));
        return sb.toString();
    }

    private static String replaceTableName(String expr, String oldName, String newName) {
        String temp = "[" + oldName + "].[";
        String result = expr;
        if (expr.indexOf(temp) != -1) {
            result = "[" + newName + expr.substring(expr.indexOf("].["));
        }
        return result;
    }

    public static MetaClass lookForMetaClass(ITable queryTable, IQueryWizardModel model) {
        return WizardUtil.lookForMetaClass(queryTable.getExpr(), model);
    }

    public static MetaClass lookForMetaClass(String tableExpr, IQueryWizardModel model) {
        Object obj = model.getObjectSelector().getObject(tableExpr);
        if (obj != null) {
            return (MetaClass)obj;
        }
        return null;
    }

    public static List queryTables2MetaClasses(IQueryWizardModel model) {
        ArrayList<MetaClass> mcs = new ArrayList<MetaClass>();
        ITableList queryTables = model.getQuery().getTables();
        for (int i = 0; i < queryTables.size(); ++i) {
            mcs.add(WizardUtil.lookForMetaClass((ITable)queryTables.get(i), model));
        }
        return mcs;
    }
}

