/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.engine.script.java;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.FileUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.engine.script.java.ClassDescriptor;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.log4j.Logger;

public class FileClassLoader
extends ClassLoader {
    public static final Logger log = LogUtil.getPackageLogger(FileClassLoader.class);
    private static String STR_PACKAGE_PREFIX = "package ";
    private static String STR_CLASS_PREFIX = "public class ";
    private static String STR_CLASS_SUFFIX = " implements IDataProvider";
    protected File home;
    protected String homePath;
    protected String output_classes;
    protected String src_folder;
    private static RandomAccessFile logFile;

    public FileClassLoader(String tempFolder) {
        super(FileClassLoader.class.getClassLoader());
        this.home = new File(tempFolder);
        FileUtil.createFolder((String)tempFolder);
        this.src_folder = tempFolder + FileUtil.FILE_SEPARATOR + "src";
        FileUtil.createFolder((String)this.src_folder);
        this.output_classes = tempFolder + FileUtil.FILE_SEPARATOR + "classes";
        FileUtil.createFolder((String)this.output_classes);
        this.homePath = tempFolder;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        String classFile = this.getClassFilePath(className);
        if (!FileUtil.isExist((String)classFile)) {
            return super.loadClass(className);
        }
        byte[] classBytes = CtrlUtil.File.readFile((String)classFile);
        return super.defineClass(null, classBytes, 0, classBytes.length);
    }

    private String getClassFilePath(String className) {
        String temp = "" + className;
        temp = temp.replace('.', FileUtil.FILE_SEPARATOR_CHAR);
        StringBuffer sb = new StringBuffer(this.output_classes).append(FileUtil.FILE_SEPARATOR_CHAR).append(temp).append(".class");
        return sb.toString();
    }

    private String getJavaFilePath(ClassDescriptor cd) {
        StringBuffer javaFilePath = new StringBuffer(this.src_folder);
        javaFilePath.append(FileUtil.FILE_SEPARATOR);
        if (!cd.isEmptyPackage()) {
            String[] parts = StringUtil.splitString((String)cd.package_name, (String)".");
            for (int i = 0; i < parts.length; ++i) {
                javaFilePath.append(parts[i]).append(FileUtil.FILE_SEPARATOR);
            }
        }
        javaFilePath.append(cd.class_name);
        javaFilePath.append(".java");
        return javaFilePath.toString();
    }

    public boolean discardClass(String className) {
        String classFile = this.getClassFilePath(className);
        CtrlUtil.File.deleteFile((String)classFile);
        return true;
    }

    public boolean isClassComplied(String className) {
        String classFilePath = this.getClassFilePath(className);
        File classFile = new File(classFilePath);
        return classFile.exists() && classFile.isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logJavac(Process process, StringBuffer cmd) {
        InputStream in = null;
        try {
            int read;
            in = process.getInputStream();
            if (logFile == null) {
                logFile = new RandomAccessFile(this.homePath + File.separatorChar + "javac.out", "rw");
            }
            cmd.insert(0, "CMD:");
            cmd.append("\r\n");
            logFile.write(cmd.toString().getBytes());
            while ((read = in.read()) != -1) {
                logFile.write(read);
            }
            logFile.write("===================\r\n".getBytes());
        }
        catch (Exception ex) {
            log.warn((Object)"", (Throwable)ex);
        }
        finally {
            CtrlUtil.Stream.closeStream((InputStream)in);
        }
    }

    public ClassDescriptor compileCode(ClassDescriptor cd, String javaCode) throws Exception {
        if (cd == null) {
            cd = FileClassLoader.parseClassByJavaCode(javaCode);
        }
        if (cd == null) {
            throw new Exception("\u683c\u5f0f\u4e0d\u5bf9,\u627e\u4e0d\u5230\u5408\u9002\u7684\u5305\u6216\u662f\u7c7b\u540d.");
        }
        String javaFile = this.getJavaFilePath(cd);
        FileUtil.createFile((String)javaFile);
        FileUtil.writeFileString((String)javaFile, (String)javaCode);
        String classPath = System.getProperty("java.class.path");
        StringBuffer sb = new StringBuffer("javac -d ");
        sb.append("\"").append(this.output_classes).append("\"");
        sb.append(" -classpath ");
        if (classPath != null && classPath.length() != 0) {
            String[] classpath_parts = classPath.split(";");
            for (int i = 0; i < classpath_parts.length; ++i) {
                sb.append("\"").append(classpath_parts[i]).append("\"");
                if (i == classpath_parts.length - 1) continue;
                sb.append(";");
            }
        }
        sb.append(" ").append("\"").append(javaFile).append("\"");
        if (log.isDebugEnabled()) {
            log.debug((Object)sb);
        }
        Process javacProcess = Runtime.getRuntime().exec(sb.toString());
        javacProcess.waitFor();
        if (javaCode.indexOf("log javac") != -1) {
            this.logJavac(javacProcess, sb);
        }
        CtrlUtil.File.deleteFile((String)javaFile);
        return cd;
    }

    public static ClassDescriptor parseClassByJavaCode(String javaCode) throws InvalidJavaCodeException {
        try {
            int index1;
            String package_name = "";
            int index0 = javaCode.indexOf(STR_PACKAGE_PREFIX);
            if (index0 != -1 && (index1 = javaCode.indexOf(";", index0)) != -1) {
                String package_line = javaCode.substring(index0, index1);
                package_name = package_line.substring(STR_PACKAGE_PREFIX.length());
            }
            if ((index0 = javaCode.indexOf(STR_CLASS_PREFIX)) != -1 && (index1 = javaCode.indexOf(STR_CLASS_SUFFIX, index0)) != -1) {
                index1 = javaCode.indexOf(" ", index0 + STR_CLASS_PREFIX.length());
                String simple_name = javaCode.substring(index0 + STR_CLASS_PREFIX.length(), index1);
                if (package_name.length() == 0) {
                    return new ClassDescriptor(simple_name);
                }
                return new ClassDescriptor(package_name, simple_name);
            }
            throw new InvalidJavaCodeException("Expected statement 'public class'");
        }
        catch (Exception ex) {
            throw new InvalidJavaCodeException("", ex);
        }
    }

    public static class InvalidJavaCodeException
    extends Exception {
        public InvalidJavaCodeException(String message) {
            super(message);
        }

        public InvalidJavaCodeException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

