/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.engine.script.java;

import com.kingdee.bos.ctrl.common.GlobalLocator;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.data.engine.script.ScriptException;
import com.kingdee.bos.ctrl.data.engine.script.java.ClassDescriptor;
import com.kingdee.bos.ctrl.data.engine.script.java.FileClassLoader;
import com.kingdee.bos.ctrl.data.engine.script.java.JavaClassExecutor;
import java.io.File;
import org.apache.log4j.Logger;

public class JavaFileExecutor
extends JavaClassExecutor {
    public static final Logger log = LogUtil.getPackageLogger(JavaFileExecutor.class);
    private static File jworkFolder = GlobalLocator.getInstance().locateResourceFolder("/server/dataProcess/jwork");
    private FileClassLoader fileClassLoader = new FileClassLoader(jworkFolder.getAbsolutePath());

    public ClassDescriptor complieJavaCode(String trimmer_codes) throws Exception {
        ClassDescriptor cd = FileClassLoader.parseClassByJavaCode(trimmer_codes);
        return this.fileClassLoader.compileCode(cd, trimmer_codes);
    }

    @Override
    public void executeScript(String trimmer_codes) throws ScriptException {
        try {
            ClassDescriptor cd = FileClassLoader.parseClassByJavaCode(trimmer_codes);
            if (!this.fileClassLoader.isClassComplied(cd.getFullClassName())) {
                this.fileClassLoader.compileCode(cd, trimmer_codes);
            }
            super.executeScript(cd.getFullClassName());
        }
        catch (Exception ex) {
            throw new ScriptException("", ex);
        }
    }

    @Override
    protected ClassLoader getClassLoader() {
        return this.fileClassLoader;
    }
}

