/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.framework.datasource;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.data.engine.resultset.BasicResultSet;
import com.kingdee.bos.ctrl.data.framework.datasource.VirtualQueryAccess;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class QueryBasedResultSet
extends BasicResultSet
implements ResultSet {
    public static final int DEFAULT_PAGE_SIZE = 10000;
    private VirtualQueryAccess queryAccess;
    private int currentRow;
    private int fetchFrom = 0;
    private int pageSize = 10000;
    private IRowSet bosRowSet;

    private final boolean assertCursor(boolean doNext) throws SQLException {
        if (this.currentRow == -1) {
            throw new SQLException("Cursor is before the first row.");
        }
        if (this.currentRow == -2) {
            throw new SQLException("Cursor is after the last row.");
        }
        if (doNext) {
            if (this.bosRowSet == null) {
                try {
                    this.bosRowSet = this.queryAccess.getRowSet(this.fetchFrom, this.pageSize);
                    this.fetchFrom = this.pageSize = this.bosRowSet.size();
                    return this.bosRowSet.next();
                }
                catch (BOSException ex) {
                    throw this.getSQLException(ex);
                }
            }
            boolean b = this.bosRowSet.next();
            if (!b) {
                try {
                    this.bosRowSet = this.queryAccess.getRowSet(this.fetchFrom, this.pageSize);
                    this.pageSize = this.bosRowSet.size();
                    this.fetchFrom += this.pageSize;
                    b = this.bosRowSet.next();
                    if (!b) {
                        this.currentRow = -2;
                    }
                }
                catch (BOSException ex) {
                    throw this.getSQLException(ex);
                }
            }
            return b;
        }
        return true;
    }

    private final SQLException getSQLException(BOSException e) {
        return new SQLException("Generated BOSException when fetching data, error:" + e.toString());
    }

    public QueryBasedResultSet(VirtualQueryAccess vqa) {
        this.queryAccess = vqa;
        int rowCount = vqa.getRowCount();
        this.currentRow = rowCount == 0 ? -2 : -1;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.pageSize;
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public void close() {
        this.queryAccess = null;
    }

    @Override
    public boolean next() throws SQLException {
        return this.assertCursor(true);
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.wasNull();
    }

    @Override
    public byte getByte(int arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getByte(arg0);
    }

    @Override
    public double getDouble(int arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getDouble(arg0);
    }

    @Override
    public float getFloat(int arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getFloat(arg0);
    }

    @Override
    public int getInt(int arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getInt(arg0);
    }

    @Override
    public long getLong(int arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getLong(arg0);
    }

    @Override
    public short getShort(int arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getShort(arg0);
    }

    @Override
    public void setFetchSize(int arg0) throws SQLException {
        this.pageSize = arg0;
    }

    @Override
    public boolean getBoolean(int arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getBoolean(arg0);
    }

    @Override
    public byte[] getBytes(int arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getBytes(arg0);
    }

    @Override
    public InputStream getAsciiStream(int arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getAsciiStream(arg0);
    }

    @Override
    public InputStream getBinaryStream(int arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getBinaryStream(arg0);
    }

    @Override
    public InputStream getUnicodeStream(int arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getUnicodeStream(arg0);
    }

    @Override
    public Reader getCharacterStream(int arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getCharacterStream(arg0);
    }

    @Override
    public Object getObject(int arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getObject(arg0);
    }

    @Override
    public String getString(int arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getString(arg0);
    }

    @Override
    public byte getByte(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getByte(arg0);
    }

    @Override
    public double getDouble(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getDouble(arg0);
    }

    @Override
    public float getFloat(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getFloat(arg0);
    }

    @Override
    public int findColumn(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.findColumn(arg0);
    }

    @Override
    public int getInt(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getInt(arg0);
    }

    @Override
    public long getLong(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getLong(arg0);
    }

    @Override
    public short getShort(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getShort(arg0);
    }

    @Override
    public boolean getBoolean(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getBoolean(arg0);
    }

    @Override
    public byte[] getBytes(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getBytes(arg0);
    }

    @Override
    public BigDecimal getBigDecimal(int arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getBigDecimal(arg0);
    }

    @Override
    public BigDecimal getBigDecimal(int arg0, int arg1) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getBigDecimal(arg0, arg1);
    }

    @Override
    public URL getURL(int arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getURL(arg0);
    }

    @Override
    public Array getArray(int arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getArray(arg0);
    }

    @Override
    public Blob getBlob(int arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getBlob(arg0);
    }

    @Override
    public Clob getClob(int arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getClob(arg0);
    }

    @Override
    public Date getDate(int arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getDate(arg0);
    }

    @Override
    public Ref getRef(int arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getRef(arg0);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getMetaData();
    }

    @Override
    public Time getTime(int arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getTime(arg0);
    }

    @Override
    public Timestamp getTimestamp(int arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getTimestamp(arg0);
    }

    @Override
    public InputStream getAsciiStream(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getAsciiStream(arg0);
    }

    @Override
    public InputStream getBinaryStream(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getBinaryStream(arg0);
    }

    @Override
    public InputStream getUnicodeStream(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getUnicodeStream(arg0);
    }

    @Override
    public Reader getCharacterStream(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getCharacterStream(arg0);
    }

    @Override
    public Object getObject(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getObject(arg0);
    }

    @Override
    public Object getObject(int arg0, Map arg1) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getObject(arg0, arg1);
    }

    @Override
    public String getString(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getString(arg0);
    }

    @Override
    public BigDecimal getBigDecimal(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getBigDecimal(arg0);
    }

    @Override
    public BigDecimal getBigDecimal(String arg0, int arg1) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getBigDecimal(arg0, arg1);
    }

    @Override
    public URL getURL(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getURL(arg0);
    }

    @Override
    public Array getArray(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getArray(arg0);
    }

    @Override
    public Blob getBlob(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getBlob(arg0);
    }

    @Override
    public Clob getClob(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getClob(arg0);
    }

    @Override
    public Date getDate(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getDate(arg0);
    }

    @Override
    public Date getDate(int arg0, Calendar arg1) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getDate(arg0, arg1);
    }

    @Override
    public Ref getRef(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getRef(arg0);
    }

    @Override
    public Time getTime(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getTime(arg0);
    }

    @Override
    public Time getTime(int arg0, Calendar arg1) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getTime(arg0, arg1);
    }

    @Override
    public Timestamp getTimestamp(String arg0) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getTimestamp(arg0);
    }

    @Override
    public Timestamp getTimestamp(int arg0, Calendar arg1) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getTimestamp(arg0, arg1);
    }

    @Override
    public Object getObject(String arg0, Map arg1) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getObject(arg0, arg1);
    }

    @Override
    public Date getDate(String arg0, Calendar arg1) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getDate(arg0, arg1);
    }

    @Override
    public Time getTime(String arg0, Calendar arg1) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getTime(arg0, arg1);
    }

    @Override
    public Timestamp getTimestamp(String arg0, Calendar arg1) throws SQLException {
        this.assertCursor(false);
        return this.bosRowSet.getTimestamp(arg0, arg1);
    }
}

