/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.framework.datasource;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class VirtualQueryAccess {
    private static final Logger log = LogUtil.getPackageLogger(VirtualQueryAccess.class);
    public static final int PAGED_ID_COUNT = 10000;
    private static final int ID_MODE_SWITCH = 200;
    private boolean isFirst = true;
    private boolean isIdMode = true;
    private List allIdList = null;
    protected IMetaDataPK queryPK = null;
    protected EntityViewInfo entityView = null;
    private IQueryExecutor queryExecutor;

    public static VirtualQueryAccess newInstance(String queryPath, EntityViewInfo evi) {
        return new VirtualQueryAccess((IMetaDataPK)new MetaDataPK(queryPath), evi);
    }

    public static VirtualQueryAccess newInstance(String queryPath, String[] fields) {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = evi.getSelector();
        for (int i = 0; i < fields.length; ++i) {
            sic.add(new SelectorItemInfo(fields[i]));
        }
        return VirtualQueryAccess.newInstance(queryPath, evi);
    }

    public VirtualQueryAccess(IMetaDataPK queryPK, EntityViewInfo entityView) {
        this.queryPK = queryPK;
        this.entityView = entityView;
    }

    public int getRowCount() {
        return this.allIdList != null ? this.allIdList.size() : -1;
    }

    private IQueryExecutor getQueryExecutor() {
        if (this.queryExecutor == null) {
            this.queryExecutor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.queryPK);
            this.queryExecutor.setObjectView(this.entityView);
            QueryExecuteOption opt = this.queryExecutor.option();
            opt.isIgnoreOrder = true;
            opt.isAutoIgnoreZero = true;
            opt.isAutoTranslateBoolean = true;
            opt.isAutoTranslateEnum = true;
        }
        return this.queryExecutor;
    }

    public IRowSet getRowSet() throws BOSException {
        return this.getQueryExecutor().executeQuery();
    }

    public void setIDMode() throws BOSException {
        this.fetchIDList();
        this.isFirst = true;
        this.isIdMode = true;
    }

    public IRowSet getRowSet(int start, int length) throws BOSException {
        if (this.isFirst) {
            this.isFirst = false;
            IRowSet rowSet = this.executeQuery(start, length);
            this.isIdMode = rowSet.size() < length ? start + rowSet.size() > 200 : true;
            if (this.isIdMode) {
                this.background_fetchIDList();
            }
            return rowSet;
        }
        if (this.isIdMode && this.allIdList != null) {
            return this.exectueQueryWithId(start, length);
        }
        return this.executeQuery(start, length);
    }

    private IRowSet exectueQueryWithId(int start, int length) throws BOSException {
        ArrayList newList = new ArrayList(length);
        for (int i = start; i < start + length && i < this.allIdList.size(); ++i) {
            newList.add(this.allIdList.get(i));
        }
        log.debug((Object)("Execute Query (ID-Mode): start=" + start + ", length=" + newList.size()));
        if (this.allIdList.size() == 0) {
            return null;
        }
        return this.getQueryExecutor().executeQuery(newList);
    }

    private IRowSet executeQuery(int start, int length) throws BOSException {
        log.debug((Object)("Execute Query: start=" + start + ", length=" + length));
        return this.getQueryExecutor().executeQuery(start, length);
    }

    private void background_fetchIDList() {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    VirtualQueryAccess.this.fetchIDList();
                }
                catch (Exception e) {
                    VirtualQueryAccess.this.allIdList = null;
                    log.error((Object)e);
                }
            }
        };
        t.start();
    }

    private void fetchIDList() throws BOSException {
        List idList;
        IQueryExecutor exec = this.getQueryExecutor();
        Uuid queryUuid = exec.openQuery();
        this.allIdList = null;
        do {
            idList = exec.getQueryKeys(queryUuid, 10000);
            if (this.allIdList == null) {
                this.allIdList = idList;
                continue;
            }
            this.allIdList.addAll(idList);
        } while (idList.size() == 10000);
        log.debug((Object)("allIdList.size() is : " + this.allIdList.size()));
    }
}

