/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.process.dataset.group.resultset;

import com.kingdee.bos.ctrl.data.process.dataset.group.resultset.IGroupTotalResultSet;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class GroupTotalResultSetUtil {
    public static final String TOTAL_TAG = "groupTotalTAG";

    public static final boolean isTotal(ResultSet rs) throws SQLException {
        int lastColumn;
        if (rs instanceof IGroupTotalResultSet) {
            return true;
        }
        ResultSetMetaData meta = rs.getMetaData();
        return TOTAL_TAG.equals(meta.getColumnName(lastColumn = meta.getColumnCount())) && 12 == meta.getColumnType(lastColumn);
    }

    public static final int getCurrentTotalLevel(ResultSet rs) throws SQLException {
        return GroupTotalResultSetUtil.getTotalLevel((String)rs.getObject(rs.getMetaData().getColumnCount()));
    }

    public static final int getTotalLevel(String tag) {
        try {
            int c;
            int totalLevel = -1;
            if (tag != null && tag.charAt((c = tag.length()) - 1) == 't') {
                totalLevel = 1;
                --c;
                for (int i = 0; i < c; ++i) {
                    totalLevel += tag.charAt(i) == '.' ? 1 : 0;
                }
            }
            return totalLevel;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Couldn't find any group/total information on this field. field value:'" + tag + "'");
        }
    }
}

